/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_load-default-log-attributes")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="load.default.log.attributes")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="load-default-log-attributes")})
public class LoadDefaultLogAttributes
implements AdminCommand {
    @Inject
    LoggingConfigImpl loggingConfig;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoadDefaultLogAttributes.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String target = "default template";
        try {
            HashMap props = null;
            props = (HashMap)this.loggingConfig.getDefaultLoggingProperties();
            ArrayList keys = new ArrayList();
            keys.addAll(props.keySet());
            Collections.sort(keys);
            Iterator it2 = keys.iterator();
            HashMap<String, String> logAttributes = new HashMap<String, String>();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                if (name.endsWith(".level") || name.equals(".level")) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(name + "\t<" + (String)props.get(name) + ">");
                logAttributes.put(name, (String)props.get(name));
            }
            Properties restData = new Properties();
            restData.put("logAttributes", logAttributes);
            report.setExtraProperties(restData);
        }
        catch (IOException ex) {
            report.setMessage(localStrings.getLocalString("get.log.attribute.failed", "Could not get logging attributes for {0}.", new Object[]{"default template"}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

