/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class CompatValidator {
    private String msg = "";
    private boolean hasBuild;
    private boolean hasPackage;
    private boolean hasInitCompat;
    private boolean hasCompileCompat;
    private boolean hasBuildCompat;
    private boolean hasPackageCompat;
    private Element buildCompatTarget;

    CompatValidator() {
    }

    public static void main(String[] args) throws Exception {
        String[] s = new String[]{"D:/compat.xml", "D:/tx.xml", "D:/whitebox.xml", "D:/connection.xml"};
        for (int i = 0; i < s.length; ++i) {
            CompatValidator validator = new CompatValidator();
            validator.validate(s[i]);
            System.out.println("Result of validation:" + s[i]);
            System.out.println(validator.getMsg());
        }
    }

    public String getMsg() {
        return this.msg;
    }

    public void validate(File file) {
        this.validate(file.getPath());
    }

    public void validate(String path) {
        NodeList nl;
        File file = new File(path);
        DocumentBuilder docb = null;
        Document doc = null;
        try {
            docb = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = docb.parse(file);
        }
        catch (ParserConfigurationException ex) {
            System.out.println("Failed to create a DOM parser.");
            ex.printStackTrace();
        }
        catch (SAXException sax) {
            System.out.println("Failed to parse build file:" + path);
            sax.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.walkNode(doc.getDocumentElement());
        if (!this.hasInitCompat) {
            this.msg = this.msg + "WARN: need to define init.compat target.\n";
        }
        if (!this.hasPackage) {
            this.msg = this.msg + "WARN: need to define package target.\n";
        }
        if (!this.hasCompileCompat) {
            this.msg = this.msg + "WARN: need to define compile.compat target.\n";
        }
        if (!this.hasPackageCompat && !this.hasBuildCompat) {
            this.msg = this.msg + "WARN: need to define build.compat target.\n";
        }
        if (!this.hasPackageCompat && this.hasBuildCompat && ((nl = this.buildCompatTarget.getElementsByTagName("package")) == null || nl.getLength() != 1)) {
            this.msg = this.msg + "WARN: build.compat target should contain 1 package task.\n";
        }
    }

    private void walkNode(Element node) {
        NodeList nl = node.getElementsByTagName("target");
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                this.walkTarget((Element)nl.item(i));
            }
        }
    }

    private void checkDisallowed(String targetName, Element target) {
        String[] disallowed = new String[]{"webwar", "ejb-jar", "ejbjar", "resrar", "appear", "clientjar", "jar", "zip"};
        for (int m = 0; m < disallowed.length; ++m) {
            NodeList nl = target.getElementsByTagName(disallowed[m]);
            if (nl == null || nl.getLength() <= 0) continue;
            this.msg = this.msg + "WARN: " + targetName + " target should not have " + disallowed[m] + " task.\n";
        }
    }

    private void walkTarget(Element target) {
        NamedNodeMap attrs = target.getAttributes();
        String name = attrs.getNamedItem("name").getNodeValue();
        if (name.equals("compile")) {
            this.msg = this.msg + "WARN: compile target should be removed.\n";
            return;
        }
        ArrayList<String> dependsList = new ArrayList<String>();
        Node dependsNode = attrs.getNamedItem("depends");
        if (dependsNode != null) {
            String depends = dependsNode.getNodeValue();
            StringTokenizer st = new StringTokenizer(depends, ", \n\r\f\t");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                dependsList.add(token);
            }
        }
        if (name.equals("build")) {
            this.hasBuild = true;
            if (dependsList.size() != 1 || !((String)dependsList.get(0)).equals("package")) {
                this.msg = this.msg + "WARN: build target should depend only on package target.\n";
            }
            this.checkDisallowed(name, target);
        } else if (name.equals("package")) {
            this.hasPackage = true;
            NodeList children = target.getChildNodes();
            int count = children.getLength();
            int countPackageTasks = 0;
            int countCopyTasks = 0;
            for (int i = 0; i < count; ++i) {
                Node child = children.item(i);
                String childName = child.getNodeName();
                if (!childName.equals("package")) continue;
                ++countPackageTasks;
                NodeList copyTasks = child.getChildNodes();
                for (int j = 0; j < copyTasks.getLength(); ++j) {
                    Node copyTask = copyTasks.item(j);
                    String copyName = copyTask.getNodeName();
                    if (!copyName.equals("copy")) continue;
                    ++countCopyTasks;
                }
            }
            if (countPackageTasks == 0) {
                this.msg = this.msg + "WARN: package target should contain 1 package task.\n";
            } else if (countPackageTasks > 1) {
                this.msg = this.msg + "WARN: package target should contain only 1 package task.\n";
            }
            if (countCopyTasks != 2) {
                this.msg = this.msg + "WARN: package task inside package target should contain 2 copy tasks. One for class file and the other for archives.\n";
            }
            this.checkDisallowed(name, target);
        } else if (name.equals("init.compat")) {
            this.hasInitCompat = true;
        } else if (name.equals("compile.compat")) {
            this.hasCompileCompat = true;
            if (!dependsList.contains("init.compat")) {
                this.msg = this.msg + "WARN: compile.compat should depend on init.compat.\n";
            }
        } else if (name.equals("build.compat")) {
            this.hasBuildCompat = true;
            this.buildCompatTarget = target;
            if (!dependsList.contains("init.compat")) {
                this.msg = this.msg + "WARN: build.compat should depend on init.compat.\n";
            }
            if (!dependsList.contains("compile.compat") && !dependsList.contains("package.compat")) {
                this.msg = this.msg + "WARN: build.compat should depend on compile.compat or package.compat.\n";
            }
        } else if (name.equals("package.compat")) {
            NodeList nl;
            this.hasPackageCompat = true;
            if (!dependsList.contains("init.compat")) {
                this.msg = this.msg + "WARN: package.compat should depend on init.compat.\n";
            }
            if (!dependsList.contains("compile.compat")) {
                this.msg = this.msg + "WARN: package.compat should depend on compile.compat.\n";
            }
            if ((nl = target.getElementsByTagName("package")) == null || nl.getLength() != 1) {
                this.msg = this.msg + "WARN: package.compat target should contain 1 package task.\n";
            }
        }
    }
}

