/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NResourceBundle
extends ResourceBundle {
    private String name;
    private ResourceBundle delegate;
    private ClassLoader classLoader;

    public static I18NResourceBundle getBundleForClass(Class c) {
        String cn = c.getName();
        int dot = cn.lastIndexOf(46);
        String rn = dot == -1 ? "i18n" : cn.substring(0, dot) + ".i18n";
        return new I18NResourceBundle(rn, c.getClassLoader());
    }

    private I18NResourceBundle(String name, ClassLoader cl) {
        this.name = name;
        this.classLoader = cl;
    }

    public String getString(String key, Object arg) {
        return this.getString(key, new Object[]{arg});
    }

    public String getString(String key, Object[] args) {
        try {
            return MessageFormat.format(this.getString(key), args);
        }
        catch (MissingResourceException e) {
            System.err.println("WARNING: missing resource: " + key + " for " + this.name);
            StringBuffer sb = new StringBuffer(key);
            for (int i = 0; i < args.length; ++i) {
                sb.append('\n');
                sb.append(args[i].toString());
            }
            return sb.toString();
        }
    }

    public String getOptionalString(String key) {
        if (this.delegate == null) {
            this.delegate = ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader);
        }
        try {
            String s = (String)this.delegate.getObject(key);
            if (s != null) {
                System.out.println("i18n: " + key);
            }
            return s;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        try {
            if (this.delegate == null) {
                this.delegate = ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader);
            }
            return this.delegate.getObject(key);
        }
        catch (MissingResourceException e) {
            System.err.println("WARNING: missing resource: " + key + " for " + this.name);
            return key;
        }
    }

    public Enumeration getKeys() {
        if (this.delegate == null) {
            this.delegate = ResourceBundle.getBundle(this.name);
        }
        return this.delegate.getKeys();
    }

    public String getName() {
        return this.name;
    }
}

