/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.wizard.EditableList;
import com.sun.interview.wizard.I18NResourceBundle;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileList
extends EditableList {
    private JFileChooser chooser = new JFileChooser();
    private File baseDir;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public FileList(String uiKey, File[] files) {
        super(uiKey, files);
        this.chooser.setName(uiKey + "chsr");
    }

    public void setBaseDirectory(File dir) {
        this.baseDir = dir;
        if (dir == null) {
            dir = new File(System.getProperty("user.dir"));
        }
        this.chooser.setCurrentDirectory(dir);
    }

    public void addFilter(FileFilter filter) {
        this.chooser.addChoosableFileFilter(filter);
    }

    public void setFileSelectionMode(int mode) {
        this.chooser.setFileSelectionMode(mode);
    }

    public File[] getFiles() {
        return (File[])this.getItems(File.class);
    }

    @Override
    protected Object getNewItem() {
        this.chooser.setDialogTitle(i18n.getString("flst.addFile.title"));
        int opt = this.chooser.showDialog(this, i18n.getString("flst.addFile.ok"));
        if (opt == 0) {
            return this.getBaseRelativeFile(this.chooser.getSelectedFile());
        }
        return null;
    }

    @Override
    protected Object getNewItem(Object oldItem) {
        File f = (File)oldItem;
        if (!f.isAbsolute() && this.baseDir != null) {
            f = new File(this.baseDir, f.getPath());
        }
        this.chooser.setSelectedFile(f);
        this.chooser.setDialogTitle(i18n.getString("flst.changeFile.title"));
        int opt = this.chooser.showDialog(this, i18n.getString("flst.changeFile.ok"));
        if (opt == 0) {
            return this.getBaseRelativeFile(this.chooser.getSelectedFile());
        }
        return null;
    }

    private File getBaseRelativeFile(File f) {
        if (this.baseDir == null) {
            return f;
        }
        String bp = this.baseDir.getPath();
        if (f.getPath().startsWith(bp + File.separatorChar)) {
            return new File(f.getPath().substring(bp.length() + 1));
        }
        return f;
    }
}

