/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.Iterator;
import java.util.concurrent.Flow;

class PullPublisher<T>
implements Flow.Publisher<T> {
    private final Iterable<T> iterable;

    PullPublisher(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(new Subscription(subscriber, this.iterable.iterator()));
    }

    private class Subscription
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final Iterator<T> iter;
        private boolean done = false;
        private long demand = 0L;
        private int recursion = 0;

        Subscription(Flow.Subscriber<? super T> subscriber, Iterator<T> iterator) {
            this.subscriber = subscriber;
            this.iter = iterator;
        }

        @Override
        public void request(long l) {
            if (this.done) {
                this.subscriber.onError(new IllegalArgumentException("request(" + l + ")"));
            }
            this.demand += l;
            ++this.recursion;
            if (this.recursion > 1) {
                return;
            }
            while (this.demand > 0L) {
                boolean bl = this.done = !this.iter.hasNext();
                if (this.done) {
                    this.subscriber.onComplete();
                    --this.recursion;
                    return;
                }
                this.subscriber.onNext(this.iter.next());
                --this.demand;
            }
        }

        @Override
        public void cancel() {
            this.done = true;
        }
    }
}

