/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.base64binary.length.length_2;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class length2_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        length2_GetSetCTTests test = new length2_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    static strictfp boolean equal(byte [] a, byte [] b) { 
        if (a.length != b.length) {
            return false;
        }
        for (int i = a.length; --i >= 0; ) {
            if (a[i] != b[i]) {
                return false;
            }
        }
        return true;
    };

    static final String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    static byte [] getBytes(String base64) {
        if (base64.length()%4 != 0) {
            throw new TestFailureException("test error: wrong length of base64 encoded data:" + base64);
        }
        int nOctets = base64.length() / 4 * 3;
        if (base64.endsWith("==")) {
            nOctets -= 2;
        } else if (base64.endsWith("=")) {
            nOctets -= 1;
        }
        byte [] bytes = new byte[nOctets];
        for (int i = (base64.length() / 4) - 1; i >= 0; --i) {
            int threeBytes = ((base64Chars.indexOf(base64.charAt(i*4)) & 0x3f) << 18)
                       | ((base64Chars.indexOf(base64.charAt(i*4 + 1)) & 0x3f) << 12)
                       | ((base64Chars.indexOf(base64.charAt(i*4 + 2)) & 0x3f) << 6)
                       | ((base64Chars.indexOf(base64.charAt(i*4 + 3)) & 0x3f));
            bytes[i*3] = (byte)((threeBytes >> 16) & 0xff);
            if (base64.charAt(i*4 + 2) != '=') {
                bytes[i*3 + 1] = (byte)((threeBytes >> 8) & 0xff);
                if (base64.charAt(i*4 + 3) != '=') {
                    bytes[i*3 + 2] = (byte)((threeBytes) & 0xff);
                }
            }
        }
        return bytes;
    }

    JAXBElement<byte[]> elemObj;

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "length-2-1.xml", "length-2-2.xml", "length-2-3.xml",
            "length-2-4.xml", "length-2-5.xml"
        };
        String [] initialValues = {"cmM=", "Ynk=", "cXM=", "a3c=", "c20="};
        String [] setValues = {"AAA=", "/nk=", "Y3c=", "//M=", "--k="};
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<byte[]> elemObj = (JAXBElement<byte[]>)unmarshal(xmlDocNames[i]);
            if (!equal(elemObj.getValue(), getBytes(initialValues[i]))){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + initialValues[i]);
            }
            elemObj.setValue(getBytes(setValues[i]));
            if (!equal(elemObj.getValue(), getBytes(setValues[i]))){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + setValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + setValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        String [] initialValues = {"cmM=", "Ynk=", "cXM=", "a3c=", "c20="};
        String [] setValues = {"AAA=", "/nk=", "Y3c=", "//M=", "--k="};
    
        for (int i = 0; i < initialValues.length; ++i){
            
                elemObj = (JAXBElement<byte[]>)(new ObjectFactory()).createNISTSchemaBase64BinaryLength2(getBytes(initialValues[i]));
            
            if (!equal(elemObj.getValue(), getBytes(initialValues[i]))){
                return Status.failed("dynamically created JAXBElement<byte[]>, elemObj.getValue() != " + initialValues[i]);
            }
            elemObj.setValue(getBytes(setValues[i]));
            if (!equal(elemObj.getValue(), getBytes(setValues[i]))){
                return Status.failed("dynamically created JAXBElement<byte[]>, elemObj.setValue(" + setValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + setValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

