/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.MultiStatus;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.Subscription;
import org.eclipse.jdt.annotation.NonNull;

public abstract class FieldEditor<T>
extends Region {
    private StringProperty label = new SimpleStringProperty((Object)this, "label");
    private String name;
    private Memento memento;
    private boolean isDefault;
    private boolean isLoaded = false;
    private final ChangeListener<Object> valueListener = (obs, old, newValue) -> this.setDefault(false);
    private final ReadOnlyStringWrapper errorMessage = new ReadOnlyStringWrapper((Object)this, "errorMessage", null);
    private final ReadOnlyObjectWrapper<Status> status = new ReadOnlyObjectWrapper((Object)this, "status", (Object)Status.ok());
    protected final ObservableList<Function<? super T, Status>> validationFunctions = FXCollections.observableArrayList();

    public FieldEditor(String name, String label) {
        this.name = name;
        this.setLabel(label);
        this.errorMessage.bind((ObservableValue)Bindings.createStringBinding(() -> ((Status)this.status.get()).isOk() ? null : ((Status)this.status.get()).getMessage(), (Observable[])new Observable[]{this.status}));
    }

    private void configureStatus() {
        ObjectExpression<Status> createStatusBinding = this.createStatusBinding();
        this.status.bind(createStatusBinding);
    }

    protected ObjectExpression<Status> createStatusBinding() {
        return Bindings.createObjectBinding(this::validate, (Observable[])new Observable[]{this.validationFunctions, this.getValue()});
    }

    private Status validate() {
        Object value = this.getValue().getValue();
        List errorStatuses = this.validationFunctions.stream().map(vf -> (Status)vf.apply(value)).filter(Objects::nonNull).filter(Status::isNotOk).collect(Collectors.toList());
        String errorMessages = errorStatuses.stream().map(Status::getMessage).filter(m -> m != null && !m.isEmpty()).collect(Collectors.joining("\n"));
        MultiStatus status = (MultiStatus)errorStatuses.stream().collect(MultiStatus.toMultiStatus((String)errorMessages, (int)-1));
        return status;
    }

    public FieldEditor(String name) {
        this(name, null);
    }

    protected void layoutChildren() {
        Insets padding = this.getPadding();
        double width = this.getWidth() - padding.getRight() - padding.getLeft();
        double height = this.getHeight() - padding.getTop() - padding.getBottom();
        for (Node node : this.getManagedChildren()) {
            node.resize(width, height);
        }
    }

    public void setMemento(Memento memento) {
        this.memento = memento;
    }

    public Memento getMemento() {
        return this.memento;
    }

    protected String getName() {
        return this.name;
    }

    protected void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public final void load() {
        if (this.getMemento() != null) {
            this.isDefault = false;
            this.doLoad();
        }
        if (!this.isLoaded) {
            this.isLoaded = true;
            this.getValue().addListener(this.valueListener);
            this.configureStatus();
        }
    }

    public final void persist() {
        if (this.getMemento() != null) {
            if (this.isDefault) {
                this.getMemento().remove(this.getName());
            } else {
                this.doPersist();
            }
            this.isDefault = false;
        }
    }

    public final void restoreDefaults() {
        this.doRestoreDefaults();
        this.setDefault(true);
    }

    protected abstract void doLoad();

    protected abstract void doPersist();

    protected abstract void doRestoreDefaults();

    public StringExpression errorMessage() {
        return this.errorMessage.getReadOnlyProperty();
    }

    public final StringProperty labelProperty() {
        return this.label;
    }

    public final String getLabel() {
        return (String)this.labelProperty().get();
    }

    public final void setLabel(String label) {
        this.labelProperty().set((Object)label);
    }

    public abstract ObservableValue<T> getValue();

    public boolean displayLabel() {
        return true;
    }

    public ObjectExpression<Status> statusProperty() {
        return this.status.getReadOnlyProperty();
    }

    public Subscription registerStatusValidator(@NonNull Function<? super T, Status> validationFunction) {
        this.validationFunctions.add(validationFunction);
        return () -> {
            boolean bl = this.validationFunctions.remove((Object)validationFunction);
        };
    }

    public Subscription registerValidator(@NonNull Function<? super T, String> validationFunction) {
        return this.registerStatusValidator(validationFunction.andThen(m -> m == null || m.isEmpty() ? Status.ok() : Status.status((Status.State)Status.State.ERROR, (int)-1, (String)m, null)));
    }
}

