package org.eclipse.fx.code.editor.ldef.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.code.editor.ldef.lDef.CodeIntegration;
import org.eclipse.fx.code.editor.ldef.lDef.Codegeneration;
import org.eclipse.fx.code.editor.ldef.lDef.ConfigValue;
import org.eclipse.fx.code.editor.ldef.lDef.E4CodeGeneration;
import org.eclipse.fx.code.editor.ldef.lDef.Integration;
import org.eclipse.fx.code.editor.ldef.lDef.JavaCodeGeneration;
import org.eclipse.fx.code.editor.ldef.lDef.JavaFXIntegration;
import org.eclipse.fx.code.editor.ldef.lDef.Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.LanguageDef;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalHighlighting;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalPartitionHighlighting;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalPartitionHighlighting_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Paritioning;
import org.eclipse.fx.code.editor.ldef.lDef.Partition;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_MultiLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_SingleLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Partitioner;
import org.eclipse.fx.code.editor.ldef.lDef.Partitioner_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_CharacterRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_MultiLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_PatternRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_SingleLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Token;
import org.eclipse.fx.code.editor.ldef.lDef.WhitespaceRule;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class JavaFXCodeGenerator {
  public Object generate(final LanguageDef model, final IFileSystemAccess access) {
    Object _xblockexpression = null;
    {
      Integration _integration = model.getIntegration();
      EList<CodeIntegration> _codeIntegrationList = _integration.getCodeIntegrationList();
      Iterable<JavaFXIntegration> _filter = Iterables.<JavaFXIntegration>filter(_codeIntegrationList, JavaFXIntegration.class);
      final JavaFXIntegration javaFXIntegration = IterableExtensions.<JavaFXIntegration>head(_filter);
      Object _xifexpression = null;
      boolean _notEquals = (!Objects.equal(javaFXIntegration, null));
      if (_notEquals) {
        Object _xblockexpression_1 = null;
        {
          EList<Codegeneration> _codegenerationList = javaFXIntegration.getCodegenerationList();
          Iterable<JavaCodeGeneration> _filter_1 = Iterables.<JavaCodeGeneration>filter(_codegenerationList, JavaCodeGeneration.class);
          final JavaCodeGeneration javaCodeGen = IterableExtensions.<JavaCodeGeneration>head(_filter_1);
          boolean _notEquals_1 = (!Objects.equal(javaCodeGen, null));
          if (_notEquals_1) {
            final String project = this.findProjectResource(javaCodeGen);
            String _xifexpression_1 = null;
            boolean _equals = Objects.equal(project, null);
            if (_equals) {
              _xifexpression_1 = "";
            } else {
              _xifexpression_1 = (("/" + project) + "/src/");
            }
            final String prefix = _xifexpression_1;
            final String basePackage = javaCodeGen.getName();
            String _replace = basePackage.replace(".", "/");
            String _plus = (prefix + _replace);
            String _plus_1 = (_plus + "/");
            String _name = model.getName();
            String _firstUpper = StringExtensions.toFirstUpper(_name);
            String _plus_2 = (_plus_1 + _firstUpper);
            String _plus_3 = (_plus_2 + "PartitionScanner.java");
            CharSequence _generateRulePartitioner = this.generateRulePartitioner(model, basePackage);
            access.generateFile(_plus_3, _generateRulePartitioner);
            String _replace_1 = basePackage.replace(".", "/");
            String _plus_4 = (prefix + _replace_1);
            String _plus_5 = (_plus_4 + "/");
            String _name_1 = model.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
            String _plus_6 = (_plus_5 + _firstUpper_1);
            String _plus_7 = (_plus_6 + "Partitioner.java");
            CharSequence _generatePartitioner = this.generatePartitioner(model, basePackage);
            access.generateFile(_plus_7, _generatePartitioner);
            String _replace_2 = basePackage.replace(".", "/");
            String _plus_8 = (prefix + _replace_2);
            String _plus_9 = (_plus_8 + "/");
            String _name_2 = model.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper(_name_2);
            String _plus_10 = (_plus_9 + _firstUpper_2);
            String _plus_11 = (_plus_10 + "PresentationReconciler.java");
            CharSequence _generatePresentationReconciler = this.generatePresentationReconciler(model, basePackage);
            access.generateFile(_plus_11, _generatePresentationReconciler);
            LexicalHighlighting _lexicalHighlighting = model.getLexicalHighlighting();
            EList<LexicalPartitionHighlighting> _list = _lexicalHighlighting.getList();
            for (final LexicalPartitionHighlighting h : _list) {
              if ((h instanceof LexicalPartitionHighlighting_Rule)) {
                String _replace_3 = basePackage.replace(".", "/");
                String _plus_12 = (prefix + _replace_3);
                String _plus_13 = (_plus_12 + "/");
                String _name_3 = model.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper(_name_3);
                String _plus_14 = (_plus_13 + _firstUpper_3);
                Partition _partition = ((LexicalPartitionHighlighting_Rule)h).getPartition();
                String _name_4 = _partition.getName();
                String _plus_15 = (_plus_14 + _name_4);
                String _plus_16 = (_plus_15 + ".java");
                CharSequence _generateScanner = this.generateScanner(model, ((LexicalPartitionHighlighting_Rule)h), basePackage);
                access.generateFile(_plus_16, _generateScanner);
              }
            }
          }
          EList<Codegeneration> _codegenerationList_1 = javaFXIntegration.getCodegenerationList();
          Iterable<E4CodeGeneration> _filter_2 = Iterables.<E4CodeGeneration>filter(_codegenerationList_1, E4CodeGeneration.class);
          final E4CodeGeneration e4CodeGen = IterableExtensions.<E4CodeGeneration>head(_filter_2);
          Object _xifexpression_2 = null;
          boolean _notEquals_2 = (!Objects.equal(e4CodeGen, null));
          if (_notEquals_2) {
            Object _xifexpression_3 = null;
            boolean _notEquals_3 = (!Objects.equal(javaCodeGen, null));
            if (_notEquals_3) {
              final String basePackage_1 = e4CodeGen.getName();
              final String javaBasePackage = javaCodeGen.getName();
              final String project_1 = this.findProjectResource(e4CodeGen);
              String _xifexpression_4 = null;
              boolean _equals_1 = Objects.equal(project_1, null);
              if (_equals_1) {
                _xifexpression_4 = "";
              } else {
                _xifexpression_4 = (("/" + project_1) + "/src/");
              }
              final String prefix_1 = _xifexpression_4;
              String _replace_4 = basePackage_1.replace(".", "/");
              String _plus_17 = (prefix_1 + _replace_4);
              String _plus_18 = (_plus_17 + "/");
              String _name_5 = model.getName();
              String _firstUpper_4 = StringExtensions.toFirstUpper(_name_5);
              String _plus_19 = (_plus_18 + _firstUpper_4);
              String _plus_20 = (_plus_19 + "DocumentPartitionerTypeProvider.java");
              CharSequence _generateDocumentPartitionerTypeProvider = this.generateDocumentPartitionerTypeProvider(model, basePackage_1, javaBasePackage);
              access.generateFile(_plus_20, _generateDocumentPartitionerTypeProvider);
              String _replace_5 = basePackage_1.replace(".", "/");
              String _plus_21 = (prefix_1 + _replace_5);
              String _plus_22 = (_plus_21 + "/");
              String _name_6 = model.getName();
              String _firstUpper_5 = StringExtensions.toFirstUpper(_name_6);
              String _plus_23 = (_plus_22 + _firstUpper_5);
              String _plus_24 = (_plus_23 + "PresentationReconcilerTypeProvider.java");
              CharSequence _generatePresentationReconcilerTypeProvider = this.generatePresentationReconcilerTypeProvider(model, basePackage_1, javaBasePackage);
              access.generateFile(_plus_24, _generatePresentationReconcilerTypeProvider);
            } else {
              _xifexpression_3 = null;
            }
            _xifexpression_2 = _xifexpression_3;
          }
          _xblockexpression_1 = _xifexpression_2;
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public String findProjectResource(final Codegeneration codeGen) {
    EList<ConfigValue> _configValue = codeGen.getConfigValue();
    final Function1<ConfigValue, Boolean> _function = new Function1<ConfigValue, Boolean>() {
      public Boolean apply(final ConfigValue it) {
        String _key = it.getKey();
        return Boolean.valueOf(Objects.equal(_key, "project"));
      }
    };
    ConfigValue _findFirst = IterableExtensions.<ConfigValue>findFirst(_configValue, _function);
    String _simpleValue = null;
    if (_findFirst!=null) {
      _simpleValue=_findFirst.getSimpleValue();
    }
    return _simpleValue;
  }
  
  public CharSequence generateDocumentPartitionerTypeProvider(final LanguageDef model, final String basePackage, final String javaBasePackage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(basePackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("@org.osgi.service.component.annotations.Component");
    _builder.newLine();
    _builder.append("public class ");
    String _name = model.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    _builder.append("DocumentPartitionerTypeProvider implements org.eclipse.fx.code.editor.services.DocumentPartitionerTypeProvider {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Class<? extends org.eclipse.jface.text.IDocumentPartitioner> getType(org.eclipse.fx.code.editor.Input<?> s) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    _builder.append(javaBasePackage, "\t\t");
    _builder.append(".");
    String _name_1 = model.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "\t\t");
    _builder.append("Partitioner.class;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public boolean test(org.eclipse.fx.code.editor.Input<?> t) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (t instanceof org.eclipse.fx.code.editor.services.URIProvider) && ((org.eclipse.fx.code.editor.services.URIProvider)t).getURI().lastSegment().endsWith(\".");
    String _name_2 = model.getName();
    _builder.append(_name_2, "\t\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generatePresentationReconcilerTypeProvider(final LanguageDef model, final String basePackage, final String javaBasePackage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(basePackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("@org.osgi.service.component.annotations.Component");
    _builder.newLine();
    _builder.append("public class ");
    String _name = model.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    _builder.append("PresentationReconcilerTypeProvider implements org.eclipse.fx.code.editor.fx.services.PresentationReconcilerTypeProvider {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Class<? extends org.eclipse.jface.text.presentation.PresentationReconciler> getType(org.eclipse.fx.code.editor.Input<?> s) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    _builder.append(javaBasePackage, "\t\t");
    _builder.append(".");
    String _name_1 = model.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "\t\t");
    _builder.append("PresentationReconciler.class;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public boolean test(org.eclipse.fx.code.editor.Input<?> t) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (t instanceof org.eclipse.fx.code.editor.services.URIProvider) && ((org.eclipse.fx.code.editor.services.URIProvider)t).getURI().lastSegment().endsWith(\".dart\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generatePartitioner(final LanguageDef model, final String basePackage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(basePackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _name = model.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    _builder.append("Partitioner extends org.eclipse.jface.text.rules.FastPartitioner {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    String _name_1 = model.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "\t");
    _builder.append("Partitioner() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(new ");
    String _name_2 = model.getName();
    String _firstUpper_2 = StringExtensions.toFirstUpper(_name_2);
    _builder.append(_firstUpper_2, "\t\t");
    _builder.append("PartitionScanner(), new String[] {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    Paritioning _paritioning = model.getParitioning();
    EList<Partition> _partitions = _paritioning.getPartitions();
    final Function1<Partition, String> _function = new Function1<Partition, String>() {
      public String apply(final Partition it) {
        return it.getName();
      }
    };
    List<String> _map = ListExtensions.<Partition, String>map(_partitions, _function);
    final Function1<String, Boolean> _function_1 = new Function1<String, Boolean>() {
      public Boolean apply(final String it) {
        boolean _equals = it.equals("__dftl_partition_content_type");
        return Boolean.valueOf((!_equals));
      }
    };
    Iterable<String> _filter = IterableExtensions.<String>filter(_map, _function_1);
    final Function1<String, String> _function_2 = new Function1<String, String>() {
      public String apply(final String it) {
        return (("\"" + it) + "\"");
      }
    };
    Iterable<String> _map_1 = IterableExtensions.<String, String>map(_filter, _function_2);
    String _join = IterableExtensions.join(_map_1, ",");
    _builder.append(_join, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateRulePartitioner(final LanguageDef model, final String basePackage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(basePackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _name = model.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    _builder.append("PartitionScanner extends org.eclipse.jface.text.rules.RuleBasedPartitionScanner {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    String _name_1 = model.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "\t");
    _builder.append("PartitionScanner() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.text.rules.IPredicateRule[] pr = new org.eclipse.jface.text.rules.IPredicateRule[");
    Paritioning _paritioning = model.getParitioning();
    Partitioner _partitioner = _paritioning.getPartitioner();
    EList<Partition_Rule> _ruleList = ((Partitioner_Rule) _partitioner).getRuleList();
    int _size = _ruleList.size();
    _builder.append(_size, "\t\t");
    _builder.append("];");
    _builder.newLineIfNotEmpty();
    {
      Paritioning _paritioning_1 = model.getParitioning();
      Partitioner _partitioner_1 = _paritioning_1.getPartitioner();
      EList<Partition_Rule> _ruleList_1 = ((Partitioner_Rule) _partitioner_1).getRuleList();
      Iterable<Pair<Integer, Partition_Rule>> _indexed = IterableExtensions.<Partition_Rule>indexed(_ruleList_1);
      for(final Pair<Integer, Partition_Rule> r : _indexed) {
        _builder.append("\t\t");
        _builder.append("pr[");
        Integer _key = r.getKey();
        _builder.append(_key, "\t\t");
        _builder.append("] = ");
        Partition_Rule _value = r.getValue();
        CharSequence _generatePartitionRule = this.generatePartitionRule(_value);
        _builder.append(_generatePartitionRule, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("setPredicateRules(pr);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generatePresentationReconciler(final LanguageDef model, final String basePackage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(basePackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _name = model.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    _builder.append("PresentationReconciler extends org.eclipse.jface.text.presentation.PresentationReconciler {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    String _name_1 = model.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "\t");
    _builder.append("PresentationReconciler() {");
    _builder.newLineIfNotEmpty();
    {
      LexicalHighlighting _lexicalHighlighting = model.getLexicalHighlighting();
      EList<LexicalPartitionHighlighting> _list = _lexicalHighlighting.getList();
      for(final LexicalPartitionHighlighting h : _list) {
        {
          if ((h instanceof LexicalPartitionHighlighting_Rule)) {
            _builder.append("\t\t");
            _builder.append("org.eclipse.jface.text.rules.DefaultDamagerRepairer ");
            Partition _partition = ((LexicalPartitionHighlighting_Rule)h).getPartition();
            String _name_2 = _partition.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("DamageRepairer = new org.eclipse.jface.text.rules.DefaultDamagerRepairer(new ");
            String _name_3 = model.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
            _builder.append(_firstUpper_2, "\t\t");
            Partition _partition_1 = ((LexicalPartitionHighlighting_Rule)h).getPartition();
            String _name_4 = _partition_1.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("());");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t\t");
            _builder.append("//FIXME Need to generate JS-Damager");
            _builder.newLine();
          }
        }
        _builder.append("\t\t");
        _builder.append("setDamager(");
        Partition _partition_2 = h.getPartition();
        String _name_5 = _partition_2.getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("DamageRepairer, \"");
        Partition _partition_3 = h.getPartition();
        String _name_6 = _partition_3.getName();
        _builder.append(_name_6, "\t\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("setRepairer(");
        Partition _partition_4 = h.getPartition();
        String _name_7 = _partition_4.getName();
        _builder.append(_name_7, "\t\t");
        _builder.append("DamageRepairer, \"");
        Partition _partition_5 = h.getPartition();
        String _name_8 = _partition_5.getName();
        _builder.append(_name_8, "\t\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateScanner(final LanguageDef model, final LexicalPartitionHighlighting_Rule highlighter, final String basePackage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(basePackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _name = model.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    Partition _partition = highlighter.getPartition();
    String _name_1 = _partition.getName();
    _builder.append(_name_1, "");
    _builder.append(" extends org.eclipse.jface.text.rules.RuleBasedScanner {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    String _name_2 = model.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_2);
    _builder.append(_firstUpper_1, "\t");
    Partition _partition_1 = highlighter.getPartition();
    String _name_3 = _partition_1.getName();
    _builder.append(_name_3, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    {
      EList<Token> _tokenList = highlighter.getTokenList();
      for(final Token t : _tokenList) {
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.text.rules.Token ");
        String _name_4 = t.getName();
        _builder.append(_name_4, "\t\t");
        _builder.append("Token = new org.eclipse.jface.text.rules.Token(new org.eclipse.jface.text.TextAttribute(\"");
        String _name_5 = model.getName();
        _builder.append(_name_5, "\t\t");
        _builder.append(".");
        String _name_6 = t.getName();
        _builder.append(_name_6, "\t\t");
        _builder.append("\"));");
        _builder.newLineIfNotEmpty();
        {
          boolean _isDefault = t.isDefault();
          if (_isDefault) {
            _builder.append("\t\t");
            _builder.append("setDefaultReturnToken(");
            String _name_7 = t.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append("Token);");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.text.rules.IRule[] rules = new org.eclipse.jface.text.rules.IRule[");
    int _countRules = JavaFXCodeGenerator.countRules(highlighter);
    int _addKeywordGroup = JavaFXCodeGenerator.addKeywordGroup(_countRules, highlighter);
    WhitespaceRule _whitespace = highlighter.getWhitespace();
    int _addWhitespaceRule = JavaFXCodeGenerator.addWhitespaceRule(_addKeywordGroup, _whitespace);
    _builder.append(_addWhitespaceRule, "\t\t");
    _builder.append("];");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    int count = 0;
    _builder.newLineIfNotEmpty();
    {
      EList<Token> _tokenList_1 = highlighter.getTokenList();
      for(final Token t_1 : _tokenList_1) {
        {
          EList<Scanner> _scannerList = t_1.getScannerList();
          final Function1<Scanner, Boolean> _function = new Function1<Scanner, Boolean>() {
            public Boolean apply(final Scanner s) {
              return Boolean.valueOf((s instanceof Scanner_Rule));
            }
          };
          Iterable<Scanner> _filter = IterableExtensions.<Scanner>filter(_scannerList, _function);
          for(final Scanner s : _filter) {
            _builder.append("\t\t");
            _builder.append("rules[");
            int _plusPlus = count++;
            _builder.append(_plusPlus, "\t\t");
            _builder.append("] = ");
            CharSequence _generateScannerRule = this.generateScannerRule(t_1, ((Scanner_Rule) s));
            _builder.append(_generateScannerRule, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      WhitespaceRule _whitespace_1 = highlighter.getWhitespace();
      boolean _notEquals = (!Objects.equal(_whitespace_1, null));
      if (_notEquals) {
        _builder.append("\t\t");
        _builder.append("rules[");
        int _plusPlus_1 = count++;
        _builder.append(_plusPlus_1, "\t\t");
        _builder.append("] = ");
        WhitespaceRule _whitespace_2 = highlighter.getWhitespace();
        CharSequence _generateWhitespaceRule = this.generateWhitespaceRule(_whitespace_2);
        _builder.append(_generateWhitespaceRule, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      boolean _hasKeywordGroup = JavaFXCodeGenerator.hasKeywordGroup(highlighter);
      if (_hasKeywordGroup) {
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.text.source.JavaLikeWordDetector wordDetector= new org.eclipse.jface.text.source.JavaLikeWordDetector();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.text.rules.CombinedWordRule combinedWordRule= new org.eclipse.jface.text.rules.CombinedWordRule(wordDetector, ");
        EList<Token> _tokenList_2 = highlighter.getTokenList();
        final Function1<Token, Boolean> _function_1 = new Function1<Token, Boolean>() {
          public Boolean apply(final Token t) {
            return Boolean.valueOf(t.isDefault());
          }
        };
        Token _findFirst = IterableExtensions.<Token>findFirst(_tokenList_2, _function_1);
        String _name_8 = _findFirst.getName();
        _builder.append(_name_8, "\t\t");
        _builder.append("Token);");
        _builder.newLineIfNotEmpty();
        {
          EList<Token> _tokenList_3 = highlighter.getTokenList();
          for(final Token t_2 : _tokenList_3) {
            {
              EList<Scanner> _scannerList_1 = t_2.getScannerList();
              final Function1<Scanner, Boolean> _function_2 = new Function1<Scanner, Boolean>() {
                public Boolean apply(final Scanner s) {
                  return Boolean.valueOf((s instanceof Scanner_Keyword));
                }
              };
              Iterable<Scanner> _filter_1 = IterableExtensions.<Scanner>filter(_scannerList_1, _function_2);
              for(final Scanner kw : _filter_1) {
                _builder.append("\t\t");
                _builder.append("org.eclipse.jface.text.rules.CombinedWordRule.WordMatcher ");
                String _name_9 = t_2.getName();
                _builder.append(_name_9, "\t\t");
                _builder.append("WordRule = new org.eclipse.jface.text.rules.CombinedWordRule.WordMatcher();");
                _builder.newLineIfNotEmpty();
                {
                  EList<Keyword> _keywords = ((Scanner_Keyword) kw).getKeywords();
                  for(final Keyword w : _keywords) {
                    _builder.append("\t\t");
                    String _name_10 = t_2.getName();
                    _builder.append(_name_10, "\t\t");
                    _builder.append("WordRule.addWord(\"");
                    String _name_11 = w.getName();
                    _builder.append(_name_11, "\t\t");
                    _builder.append("\", ");
                    String _name_12 = t_2.getName();
                    _builder.append(_name_12, "\t\t");
                    _builder.append("Token);");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t\t");
                _builder.append("combinedWordRule.addWordMatcher(");
                String _name_13 = t_2.getName();
                _builder.append(_name_13, "\t\t");
                _builder.append("WordRule);");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t\t");
        _builder.append("rules[");
        int _plusPlus_2 = count++;
        _builder.append(_plusPlus_2, "\t\t");
        _builder.append("] = combinedWordRule;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("setRules(rules);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public static boolean hasKeywordGroup(final LexicalPartitionHighlighting_Rule highlighter) {
    EList<Token> _tokenList = highlighter.getTokenList();
    for (final Token t : _tokenList) {
      EList<Scanner> _scannerList = t.getScannerList();
      final Function1<Scanner, Boolean> _function = new Function1<Scanner, Boolean>() {
        public Boolean apply(final Scanner s) {
          return Boolean.valueOf((s instanceof Scanner_Keyword));
        }
      };
      Iterable<Scanner> _filter = IterableExtensions.<Scanner>filter(_scannerList, _function);
      Scanner _head = IterableExtensions.<Scanner>head(_filter);
      boolean _notEquals = (!Objects.equal(_head, null));
      if (_notEquals) {
        return true;
      }
    }
    return false;
  }
  
  public static int addKeywordGroup(final int count, final LexicalPartitionHighlighting_Rule highlighter) {
    EList<Token> _tokenList = highlighter.getTokenList();
    for (final Token t : _tokenList) {
      EList<Scanner> _scannerList = t.getScannerList();
      final Function1<Scanner, Boolean> _function = new Function1<Scanner, Boolean>() {
        public Boolean apply(final Scanner s) {
          return Boolean.valueOf((s instanceof Scanner_Keyword));
        }
      };
      Iterable<Scanner> _filter = IterableExtensions.<Scanner>filter(_scannerList, _function);
      Scanner _head = IterableExtensions.<Scanner>head(_filter);
      boolean _notEquals = (!Objects.equal(_head, null));
      if (_notEquals) {
        return (count + 1);
      }
    }
    return count;
  }
  
  public static int addWhitespaceRule(final int count, final WhitespaceRule r) {
    boolean _notEquals = (!Objects.equal(r, null));
    if (_notEquals) {
      return (count + 1);
    }
    return count;
  }
  
  public static int countRules(final LexicalPartitionHighlighting_Rule highlighter) {
    int c = 0;
    EList<Token> _tokenList = highlighter.getTokenList();
    for (final Token t : _tokenList) {
      int _c = c;
      EList<Scanner> _scannerList = t.getScannerList();
      final Function1<Scanner, Boolean> _function = new Function1<Scanner, Boolean>() {
        public Boolean apply(final Scanner s) {
          return Boolean.valueOf((s instanceof Scanner_Rule));
        }
      };
      Iterable<Scanner> _filter = IterableExtensions.<Scanner>filter(_scannerList, _function);
      int _length = ((Object[])Conversions.unwrapArray(_filter, Object.class)).length;
      c = (_c + _length);
    }
    return c;
  }
  
  protected CharSequence _generateScannerRule(final Token t, final Scanner_SingleLineRule r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.jface.text.rules.SingleLineRule(");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("\"");
    String _startSeq = r.getStartSeq();
    String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
    _builder.append(_escapeString, "\t  ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", \"");
    String _endSeq = r.getEndSeq();
    String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
    _builder.append(_escapeString_1, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", ");
    String _name = t.getName();
    _builder.append(_name, "\t");
    _builder.append("Token");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _escapeSeq = r.getEscapeSeq();
      boolean _notEquals = (!Objects.equal(_escapeSeq, null));
      if (_notEquals) {
        _builder.append(", \'");
        String _escapeSeq_1 = r.getEscapeSeq();
        char _charAt = _escapeSeq_1.charAt(0);
        _builder.append(_charAt, "\t");
        _builder.append("\'");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _generateScannerRule(final Token t, final Scanner_MultiLineRule r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.jface.text.rules.MultiLineRule(");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("\"");
    String _startSeq = r.getStartSeq();
    String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
    _builder.append(_escapeString, "\t  ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", \"");
    String _endSeq = r.getEndSeq();
    String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
    _builder.append(_escapeString_1, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", ");
    String _name = t.getName();
    _builder.append(_name, "\t");
    _builder.append("Token");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _escapeSeq = r.getEscapeSeq();
      boolean _notEquals = (!Objects.equal(_escapeSeq, null));
      if (_notEquals) {
        _builder.append(", \'");
        String _escapeSeq_1 = r.getEscapeSeq();
        char _charAt = _escapeSeq_1.charAt(0);
        _builder.append(_charAt, "\t");
        _builder.append("\'");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateWhitespaceRule(final WhitespaceRule r) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isJavawhitespace = r.isJavawhitespace();
      if (_isJavawhitespace) {
        _builder.append("new org.eclipse.jface.text.rules.WhitespaceRule(Character::isWhitespace);");
        _builder.newLine();
      } else {
        _builder.append("new org.eclipse.jface.text.rules.WhitespaceRule(new org.eclipse.jface.text.rules.FixedCharacterWSDetector(new char[] {");
        EList<String> _characters = r.getCharacters();
        final Function1<String, String> _function = new Function1<String, String>() {
          public String apply(final String it) {
            String _escapeChar = JavaFXCodeGenerator.escapeChar(it);
            String _plus = ("\'" + _escapeChar);
            return (_plus + "\'");
          }
        };
        List<String> _map = ListExtensions.<String, String>map(_characters, _function);
        String _join = IterableExtensions.join(_map, ",");
        _builder.append(_join, "");
        _builder.append("}));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _generateScannerRule(final Token t, final Scanner_CharacterRule r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.jface.text.source.CharacterRule(");
    String _name = t.getName();
    _builder.append(_name, "");
    _builder.append("Token, new char[] {");
    EList<String> _characters = r.getCharacters();
    final Function1<String, String> _function = new Function1<String, String>() {
      public String apply(final String it) {
        String _escapeChar = JavaFXCodeGenerator.escapeChar(it);
        String _plus = ("\'" + _escapeChar);
        return (_plus + "\'");
      }
    };
    List<String> _map = ListExtensions.<String, String>map(_characters, _function);
    String _join = IterableExtensions.join(_map, ",");
    _builder.append(_join, "");
    _builder.append("});");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _generateScannerRule(final Token t, final Scanner_PatternRule r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.fx.text.RegexRule(");
    String _name = t.getName();
    _builder.append(_name, "");
    _builder.append("Token, java.util.regex.Pattern.compile(\"");
    String _startPattern = r.getStartPattern();
    String _replace = _startPattern.replace("\\", "\\\\");
    _builder.append(_replace, "");
    _builder.append("\"),");
    int _length = r.getLength();
    int _max = Math.max(1, _length);
    _builder.append(_max, "");
    _builder.append(",java.util.regex.Pattern.compile(\"");
    String _contentPattern = r.getContentPattern();
    String _replace_1 = _contentPattern.replace("\\", "\\\\");
    _builder.append(_replace_1, "");
    _builder.append("\"));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _generatePartitionRule(final Partition_SingleLineRule r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.jface.text.rules.SingleLineRule(");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("\"");
    String _startSeq = r.getStartSeq();
    String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
    _builder.append(_escapeString, "\t  ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", \"");
    String _endSeq = r.getEndSeq();
    String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
    _builder.append(_escapeString_1, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", new org.eclipse.jface.text.rules.Token(\"");
    Partition _parition = r.getParition();
    String _name = _parition.getName();
    _builder.append(_name, "\t");
    _builder.append("\")");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _escapeSeq = r.getEscapeSeq();
      boolean _notEquals = (!Objects.equal(_escapeSeq, null));
      if (_notEquals) {
        _builder.append(", \'");
        String _escapeSeq_1 = r.getEscapeSeq();
        char _charAt = _escapeSeq_1.charAt(0);
        _builder.append(_charAt, "\t");
        _builder.append("\'");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _generatePartitionRule(final Partition_MultiLineRule r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.jface.text.rules.MultiLineRule(");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("\"");
    String _startSeq = r.getStartSeq();
    String _escapeString = JavaFXCodeGenerator.escapeString(_startSeq);
    _builder.append(_escapeString, "\t  ");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", \"");
    String _endSeq = r.getEndSeq();
    String _escapeString_1 = JavaFXCodeGenerator.escapeString(_endSeq);
    _builder.append(_escapeString_1, "\t");
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(", new org.eclipse.jface.text.rules.Token(\"");
    Partition _parition = r.getParition();
    String _name = _parition.getName();
    _builder.append(_name, "\t");
    _builder.append("\")");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      String _escapeSeq = r.getEscapeSeq();
      boolean _notEquals = (!Objects.equal(_escapeSeq, null));
      if (_notEquals) {
        _builder.append(", \'");
        String _escapeSeq_1 = r.getEscapeSeq();
        char _charAt = _escapeSeq_1.charAt(0);
        _builder.append(_charAt, "\t");
        _builder.append("\'");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public static String escapeString(final String data) {
    return data.replaceAll("\"", "\\\\\"");
  }
  
  public static String escapeChar(final String data) {
    boolean _equals = Objects.equal(data, "\\");
    if (_equals) {
      return "\\\\";
    } else {
      boolean _equals_1 = Objects.equal(data, "\'");
      if (_equals_1) {
        return "\\\'";
      }
    }
    return data;
  }
  
  public CharSequence generateScannerRule(final Token t, final Scanner_Rule r) {
    if (r instanceof Scanner_CharacterRule) {
      return _generateScannerRule(t, (Scanner_CharacterRule)r);
    } else if (r instanceof Scanner_MultiLineRule) {
      return _generateScannerRule(t, (Scanner_MultiLineRule)r);
    } else if (r instanceof Scanner_PatternRule) {
      return _generateScannerRule(t, (Scanner_PatternRule)r);
    } else if (r instanceof Scanner_SingleLineRule) {
      return _generateScannerRule(t, (Scanner_SingleLineRule)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t, r).toString());
    }
  }
  
  public CharSequence generatePartitionRule(final Partition_Rule r) {
    if (r instanceof Partition_MultiLineRule) {
      return _generatePartitionRule((Partition_MultiLineRule)r);
    } else if (r instanceof Partition_SingleLineRule) {
      return _generatePartitionRule((Partition_SingleLineRule)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(r).toString());
    }
  }
}
