/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.debug.TextRegionsToString;
import org.eclipse.xtext.formatting2.internal.ConflictingRegionsException;
import org.eclipse.xtext.formatting2.internal.RegionTrace;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

public abstract class TextSegmentSet<T>
implements Iterable<T> {
    private final Function<? super T, ? extends ITextSegment> regionGetter;
    private final Function<? super T, String> titleGetter;
    private final IdentityHashMap<T, RegionTrace> traces = new IdentityHashMap();

    public TextSegmentSet(Function<? super T, ? extends ITextSegment> region, Function<? super T, String> title) {
        this.regionGetter = region;
        this.titleGetter = title;
    }

    public void add(T segment) throws ConflictingRegionsException {
        this.add(segment, null);
    }

    public abstract void add(T var1, IMerger<T> var2) throws ConflictingRegionsException;

    public abstract T get(T var1);

    protected ITextSegment getRegion(T t) {
        return (ITextSegment)this.regionGetter.apply(t);
    }

    public Function<? super T, ? extends ITextSegment> getRegionAccess() {
        return this.regionGetter;
    }

    protected String getTitle(T t) {
        return (String)this.titleGetter.apply(t);
    }

    public IdentityHashMap<T, RegionTrace> getTraces() {
        return this.traces;
    }

    protected void handleConflict(List<T> conflicts, Exception cause) throws ConflictingRegionsException {
        ArrayList causes = Lists.newArrayList();
        for (T t : conflicts) {
            RegionTrace exception = this.traces.get(t);
            if (exception == null) continue;
            causes.add(exception);
        }
        throw new ConflictingRegionsException("Conflicting Regions", cause, causes);
    }

    protected boolean isConflict(ITextSegment region1, ITextSegment region2) {
        int offset1 = region1.getOffset();
        int length1 = region1.getLength();
        int offset2 = region2.getOffset();
        int length2 = region2.getLength();
        if (offset1 < offset2) {
            return offset1 + length1 > offset2;
        }
        if (offset1 > offset2) {
            return offset2 + length2 > offset1;
        }
        return !(length1 == 0 ^ length2 == 0);
    }

    protected boolean isConflict(T t1, T t2) {
        return this.isConflict(this.getRegion(t1), this.getRegion(t2));
    }

    public String toString() {
        TextRegionsToString toString = new TextRegionsToString();
        toString.setTitle(this.getClass().getSimpleName());
        for (Object t : this) {
            toString.add(this.getRegion(t), this.getTitle(t));
        }
        return toString.toString();
    }
}

