/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@ImplementedBy(value=OnlyWithoutErrors.class)
@Beta
public interface IShouldGenerate {
    public boolean shouldGenerate(Resource var1, CancelIndicator var2);

    @Beta
    public static class Always
    implements IShouldGenerate {
        @Override
        public boolean shouldGenerate(Resource resource, CancelIndicator cancelIndicator) {
            return true;
        }
    }

    @Beta
    public static class OnlyWithoutErrors
    implements IShouldGenerate {
        @Inject
        private IResourceValidator resourceValidator;

        @Override
        public boolean shouldGenerate(Resource resource, CancelIndicator cancelIndicator) {
            Functions.Function1<Issue, Boolean> _function;
            boolean _not;
            EList _errors = resource.getErrors();
            boolean _isEmpty = _errors.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                return false;
            }
            List<Issue> issues = this.resourceValidator.validate(resource, CheckMode.NORMAL_AND_FAST, cancelIndicator);
            boolean _exists = IterableExtensions.exists(issues, (Functions.Function1)(_function = new Functions.Function1<Issue, Boolean>(){

                public Boolean apply(Issue it) {
                    Severity _severity = it.getSeverity();
                    return Objects.equal((Object)((Object)_severity), (Object)((Object)Severity.ERROR));
                }
            }));
            return !_exists;
        }
    }
}

