/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ObservableSet;

public class WritableSet<E>
extends ObservableSet<E> {
    public WritableSet() {
        this(Realm.getDefault());
    }

    public WritableSet(Collection<? extends E> c, Object elementType) {
        this(Realm.getDefault(), (Collection<? extends E>)new HashSet<E>(c), elementType);
    }

    public WritableSet(Realm realm) {
        this(realm, new HashSet(), (Object)null);
    }

    public WritableSet(Realm realm, Collection<? extends E> c, Object elementType) {
        super(realm, new HashSet<E>(c), elementType);
        this.elementType = elementType;
    }

    @Override
    public boolean add(E o) {
        this.getterCalled();
        boolean added = this.wrappedSet.add(o);
        if (added) {
            Set removals = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), removals));
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.getterCalled();
        HashSet<E> additions = new HashSet<E>();
        for (E element : c) {
            if (!this.wrappedSet.add(element)) continue;
            additions.add(element);
        }
        if (additions.size() > 0) {
            Set removals = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, removals));
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        this.getterCalled();
        boolean removed = this.wrappedSet.remove(o);
        if (removed) {
            Set additions = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, Collections.singleton(o)));
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.getterCalled();
        HashSet removes = new HashSet();
        for (Object element : c) {
            if (!this.wrappedSet.remove(element)) continue;
            removes.add(element);
        }
        if (removes.size() > 0) {
            Set additions = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, removes));
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.getterCalled();
        HashSet removes = new HashSet();
        Iterator it = this.wrappedSet.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (c.contains(element)) continue;
            it.remove();
            removes.add(element);
        }
        if (removes.size() > 0) {
            Set additions = Collections.emptySet();
            this.fireSetChange(Diffs.createSetDiff(additions, removes));
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.getterCalled();
        HashSet removes = new HashSet(this.wrappedSet);
        Set additions = Collections.emptySet();
        this.wrappedSet.clear();
        this.fireSetChange(Diffs.createSetDiff(additions, removes));
    }

    public static WritableSet<?> withElementType(Object elementType) {
        return new WritableSet(Realm.getDefault(), new HashSet(), elementType);
    }
}

