/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.NamedArgument;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.diagnostics.AbstractDiagnosticProducerDecorator;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.Linker;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.xtext.XtextMetamodelReferenceHelper;
import org.eclipse.xtext.xtext.ecoreInference.IXtext2EcorePostProcessor;
import org.eclipse.xtext.xtext.ecoreInference.TransformationDiagnosticsProducer;
import org.eclipse.xtext.xtext.ecoreInference.Xtext2EcoreTransformer;

public class XtextLinker
extends Linker {
    private static Logger log = Logger.getLogger(XtextLinker.class);
    @Inject
    private IScopeProvider scopeProvider;
    @Inject(optional=true)
    private IXtext2EcorePostProcessor postProcessor;
    @Inject(optional=true)
    private IReferableElementsUnloader unloader;
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    private PackageRemover packageRemover;

    public IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    public void setScopeProvider(IScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public IXtext2EcorePostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(IXtext2EcorePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    protected IDiagnosticProducer createDiagnosticProducer(IDiagnosticConsumer consumer) {
        return new AbstractDiagnosticProducerDecorator(super.createDiagnosticProducer(consumer)){
            private boolean filter;
            {
                this.filter = false;
            }

            @Override
            public void addDiagnostic(DiagnosticMessage message) {
                if (!this.filter) {
                    super.addDiagnostic(message);
                }
            }

            @Override
            public void setTarget(EObject object, EStructuralFeature feature) {
                super.setTarget(object, feature);
                this.filter = this.isTypeRef(object, feature) || this.isGeneratedPackage(object, feature) || this.isEnumLiteral(object, feature);
            }

            private boolean isEnumLiteral(EObject object, EStructuralFeature feature) {
                if (feature == XtextPackage.eINSTANCE.getEnumLiteralDeclaration_EnumLiteral()) {
                    EnumRule rule = GrammarUtil.containingEnumRule(object);
                    return rule.getType() == null || rule.getType().getClassifier() == null;
                }
                return false;
            }

            private boolean isGeneratedPackage(EObject object, EStructuralFeature feature) {
                return feature == XtextPackage.eINSTANCE.getAbstractMetamodelDeclaration_EPackage() && object instanceof GeneratedMetamodel;
            }

            private boolean isTypeRef(EObject object, EStructuralFeature feature) {
                return feature == XtextPackage.eINSTANCE.getTypeRef_Classifier() && ((TypeRef)object).getMetamodel() instanceof GeneratedMetamodel;
            }
        };
    }

    @Override
    protected boolean canSetDefaultValues(EReference ref) {
        return super.canSetDefaultValues(ref) || ref == XtextPackage.Literals.CROSS_REFERENCE__TERMINAL;
    }

    @Override
    protected void setDefaultValueImpl(EObject obj, EReference ref, IDiagnosticProducer producer) {
        if (XtextPackage.eINSTANCE.getTypeRef_Metamodel() == ref) {
            TypeRef typeRef = (TypeRef)obj;
            String typeRefName = GrammarUtil.getTypeRefName(typeRef);
            List<EObject> metamodels = XtextMetamodelReferenceHelper.findBestMetamodelForType(typeRef, "", typeRefName, this.scopeProvider.getScope(typeRef, ref));
            if (metamodels.isEmpty() || metamodels.size() > 1) {
                producer.addDiagnostic(new DiagnosticMessage("Cannot find meta model for type '" + typeRefName + "'", Severity.ERROR, null, new String[0]));
            } else {
                typeRef.setMetamodel((AbstractMetamodelDeclaration)metamodels.get(0));
            }
        } else if (XtextPackage.eINSTANCE.getCrossReference_Terminal() == ref) {
            AbstractRule rule = GrammarUtil.findRuleForName(GrammarUtil.getGrammar(obj), "ID");
            if (rule == null) {
                producer.addDiagnostic(new DiagnosticMessage("Cannot resolve implicit reference to rule 'ID'", Severity.ERROR, null, new String[0]));
            } else {
                RuleCall call = XtextFactory.eINSTANCE.createRuleCall();
                call.setRule(rule);
                ((CrossReference)obj).setTerminal(call);
            }
        } else if (XtextPackage.eINSTANCE.getNamedArgument_Parameter() == ref) {
            NamedArgument argument = (NamedArgument)obj;
            if (!argument.isCalledByName()) {
                RuleCall ruleCall = EcoreUtil2.getContainerOfType(argument, RuleCall.class);
                AbstractRule calledRule = ruleCall.getRule();
                if (!(calledRule instanceof ParserRule)) {
                    producer.addDiagnostic(new DiagnosticMessage("Arguments can only be used with parser rules.", Severity.ERROR, null, new String[0]));
                    return;
                }
                if (!calledRule.eIsProxy()) {
                    ParserRule casted = (ParserRule)calledRule;
                    int idx = ruleCall.getArguments().indexOf((Object)argument);
                    if (idx < casted.getParameters().size()) {
                        argument.setParameter((Parameter)casted.getParameters().get(idx));
                        return;
                    }
                    if (casted.getParameters().size() == 0) {
                        producer.addDiagnostic(new DiagnosticMessage("Rule " + calledRule.getName() + " has no arguments.", Severity.ERROR, null, new String[0]));
                    } else {
                        String message = "Invalid number of arguments for rule " + calledRule.getName() + ", expecting " + casted.getParameters().size() + " but was " + (idx + 1);
                        producer.addDiagnostic(new DiagnosticMessage(message, Severity.ERROR, null, new String[0]));
                    }
                }
            }
        } else {
            super.setDefaultValueImpl(obj, ref, producer);
        }
    }

    @Override
    protected void beforeEnsureIsLinked(EObject obj, EReference ref, IDiagnosticProducer producer) {
        if (XtextPackage.eINSTANCE.getTypeRef_Classifier() == ref) {
            TypeRef typeRef = (TypeRef)obj;
            if (typeRef.getMetamodel() == null) {
                this.setDefaultValue(obj, XtextPackage.eINSTANCE.getTypeRef_Metamodel(), producer);
            }
        } else {
            super.beforeEnsureIsLinked(obj, ref, producer);
        }
    }

    protected Xtext2EcoreTransformer createTransformer(Grammar grammar, IDiagnosticConsumer consumer) {
        Xtext2EcoreTransformer transformer = new Xtext2EcoreTransformer(grammar);
        transformer.setErrorAcceptor(new TransformationDiagnosticsProducer(consumer));
        transformer.setPostProcessor(this.postProcessor);
        return transformer;
    }

    @Override
    protected void beforeModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        this.discardGeneratedPackages(model);
        this.clearAllReferences(model);
        super.beforeModelLinked(model, diagnosticsConsumer);
        this.cache.getOrCreate(model.eResource()).ignoreNotifications();
    }

    @Override
    protected boolean isClearAllReferencesRequired(Resource resource) {
        return false;
    }

    void discardGeneratedPackages(EObject root) {
        if (root instanceof Grammar) {
            for (AbstractMetamodelDeclaration metamodelDeclaration : ((Grammar)root).getMetamodelDeclarations()) {
                Resource resource;
                EPackage ePackage;
                if (!(metamodelDeclaration instanceof GeneratedMetamodel) || (ePackage = (EPackage)metamodelDeclaration.eGet((EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, false)) == null || ePackage.eIsProxy() || (resource = ePackage.eResource()) == null || resource.getResourceSet() == null) continue;
                if (this.unloader != null) {
                    for (EObject content : resource.getContents()) {
                        this.unloader.unloadRoot(content);
                    }
                }
                resource.getResourceSet().getResources().remove((Object)resource);
            }
        }
    }

    @Override
    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        super.afterModelLinked(model, diagnosticsConsumer);
        this.cache.getOrCreate(model.eResource()).listenToNotifications();
    }

    @Override
    public void linkModel(EObject model, IDiagnosticConsumer consumer) {
        if (model instanceof Grammar) {
            Xtext2EcoreTransformer transformer = this.createTransformer((Grammar)model, consumer);
            transformer.removeGeneratedPackages();
            super.linkModel(model, consumer);
            this.updateOverriddenRules((Grammar)model);
            try {
                transformer.transform();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                consumer.consume(new ExceptionDiagnostic(e), Severity.ERROR);
            }
            if (!model.eResource().eAdapters().contains((Object)this.packageRemover)) {
                model.eResource().eAdapters().add((Object)this.packageRemover);
            }
        } else {
            super.linkModel(model, consumer);
        }
    }

    protected void updateOverriddenRules(Grammar grammar) {
        if (grammar.getUsedGrammars().isEmpty()) {
            return;
        }
        HashMap<String, AbstractRule> rulePerName = new HashMap<String, AbstractRule>(grammar.getRules().size());
        for (AbstractRule rule : grammar.getRules()) {
            rulePerName.put(rule.getName(), rule);
        }
        HashSet<Grammar> visitedGrammars = new HashSet<Grammar>();
        visitedGrammars.add(grammar);
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.updateOverriddenRules(usedGrammar, rulePerName, visitedGrammars);
        }
    }

    protected void updateOverriddenRules(Grammar grammar, Map<String, AbstractRule> rulePerName, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return;
        }
        this.updateOverriddenRules(grammar, rulePerName);
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.updateOverriddenRules(usedGrammar, rulePerName, visitedGrammars);
        }
    }

    protected void updateOverriddenRules(Grammar grammar, Map<String, AbstractRule> rulePerName) {
        if (grammar.isDefinesHiddenTokens()) {
            this.updateHiddenTokens((List<AbstractRule>)grammar.getHiddenTokens(), rulePerName);
        }
        for (AbstractRule rule : grammar.getRules()) {
            if (!(rule instanceof ParserRule) || !((ParserRule)rule).isDefinesHiddenTokens()) continue;
            this.updateHiddenTokens((List<AbstractRule>)((ParserRule)rule).getHiddenTokens(), rulePerName);
        }
        List<RuleCall> allRuleCalls = EcoreUtil2.getAllContentsOfType(grammar, RuleCall.class);
        for (RuleCall call : allRuleCalls) {
            AbstractRule rule;
            AbstractRule calledRule = call.getRule();
            if (calledRule == null || call.isExplicitlyCalled() || (rule = rulePerName.get(calledRule.getName())) == null) continue;
            call.setRule(rule);
            if (call.getArguments().isEmpty() || !(calledRule instanceof ParserRule) || !(rule instanceof ParserRule)) continue;
            this.updateNamedArguments(call, (List<Parameter>)((ParserRule)calledRule).getParameters(), (List<Parameter>)((ParserRule)rule).getParameters());
        }
    }

    private void updateNamedArguments(RuleCall call, List<Parameter> superParams, List<Parameter> overridingParameters) {
        for (NamedArgument argument : call.getArguments()) {
            Parameter superParameter = argument.getParameter();
            int max = Math.min(superParams.size(), overridingParameters.size());
            for (int i = 0; i < max; ++i) {
                if (superParams.get(i) != superParameter) continue;
                argument.setParameter(overridingParameters.get(i));
            }
        }
    }

    private void updateHiddenTokens(List<AbstractRule> hiddenTokens, Map<String, AbstractRule> rulePerName) {
        for (int i = 0; i < hiddenTokens.size(); ++i) {
            AbstractRule hidden = hiddenTokens.get(i);
            AbstractRule overridden = rulePerName.get(hidden.getName());
            if (overridden == null) continue;
            hiddenTokens.set(i, overridden);
        }
    }

    @Override
    protected void clearReference(EObject obj, EReference ref) {
        ICompositeNode node;
        super.clearReference(obj, ref);
        if (obj.eIsSet((EStructuralFeature)ref) && ref.getEType().equals(XtextPackage.Literals.TYPE_REF) && (node = NodeModelUtils.getNode((EObject)obj.eGet((EStructuralFeature)ref))) == null) {
            obj.eUnset((EStructuralFeature)ref);
        }
        if (obj.eIsSet((EStructuralFeature)ref) && ref == XtextPackage.Literals.CROSS_REFERENCE__TERMINAL && (node = NodeModelUtils.getNode((EObject)obj.eGet((EStructuralFeature)ref))) == null) {
            obj.eUnset((EStructuralFeature)ref);
        }
        if (ref == XtextPackage.Literals.RULE_CALL__RULE) {
            obj.eUnset((EStructuralFeature)XtextPackage.Literals.RULE_CALL__EXPLICITLY_CALLED);
        }
    }

    public void setPackageRemover(PackageRemover packageRemover) {
        this.packageRemover = packageRemover;
    }

    public PackageRemover getPackageRemover() {
        return this.packageRemover;
    }

    public void setCache(OnChangeEvictingCache cache) {
        this.cache = cache;
    }

    public OnChangeEvictingCache getCache() {
        return this.cache;
    }

    public static class PackageRemover
    extends EContentAdapter {
        @Inject
        private IReferableElementsUnloader unloader;

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (!msg.isTouch() && msg.getOldValue() != null) {
                Resource notifyingResource;
                if (!(msg.getNotifier() instanceof Resource)) {
                    Object feature = msg.getFeature();
                    if (!(feature instanceof EReference)) {
                        return;
                    }
                    EReference ref = (EReference)feature;
                    if (!ref.isContainment()) {
                        return;
                    }
                    notifyingResource = ((EObject)msg.getNotifier()).eResource();
                } else {
                    notifyingResource = (Resource)msg.getNotifier();
                }
                if (notifyingResource == null) {
                    return;
                }
                ResourceSet set = notifyingResource.getResourceSet();
                if (set == null) {
                    return;
                }
                switch (msg.getEventType()) {
                    case 1: 
                    case 4: 
                    case 6: {
                        Object oldValue = msg.getOldValue();
                        HashSet resourcesToRemove = Sets.newHashSet();
                        HashSet resourcesToUnload = Sets.newHashSet();
                        HashSet referencedResources = Sets.newHashSet((Object[])new Resource[]{notifyingResource});
                        if (oldValue instanceof Grammar) {
                            this.processMetamodelDeclarations((Collection<AbstractMetamodelDeclaration>)((Grammar)oldValue).getMetamodelDeclarations(), set, resourcesToRemove, resourcesToUnload, referencedResources);
                        } else if (oldValue instanceof AbstractMetamodelDeclaration) {
                            this.processMetamodelDeclarations(Collections.singletonList((AbstractMetamodelDeclaration)oldValue), set, resourcesToRemove, resourcesToUnload, referencedResources);
                        } else if (oldValue instanceof Collection && XtextPackage.Literals.GRAMMAR__METAMODEL_DECLARATIONS == msg.getFeature()) {
                            Collection metamodelDeclarations = (Collection)oldValue;
                            this.processMetamodelDeclarations(metamodelDeclarations, set, resourcesToRemove, resourcesToUnload, referencedResources);
                        }
                        resourcesToRemove.removeAll(referencedResources);
                        if (this.unloader != null) {
                            resourcesToUnload.removeAll(referencedResources);
                            for (Resource resource : resourcesToUnload) {
                                if (resource.getResourceSet() != set) continue;
                                for (EObject content : resource.getContents()) {
                                    this.unloader.unloadRoot(content);
                                }
                            }
                        }
                        set.getResources().removeAll((Collection)resourcesToRemove);
                        break;
                    }
                }
            }
        }

        private void processMetamodelDeclarations(Collection<AbstractMetamodelDeclaration> declarations, ResourceSet resourceSet, Collection<Resource> resourcesToRemove, Collection<Resource> resourcesToUnload, Collection<Resource> referencedResources) {
            for (AbstractMetamodelDeclaration declaration : declarations) {
                Resource packResource;
                EPackage pack = (EPackage)declaration.eGet((EStructuralFeature)XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE, false);
                if (pack == null || pack.eIsProxy() || (packResource = pack.eResource()) == null) continue;
                resourcesToRemove.add(packResource);
                if (declaration instanceof ReferencedMetamodel) {
                    resourcesToUnload.add(packResource);
                }
                if (!this.isPackageReferenced(resourceSet, pack, declarations)) continue;
                referencedResources.add(packResource);
            }
        }

        public boolean isPackageReferenced(ResourceSet set, EPackage pack, Collection<AbstractMetamodelDeclaration> knownReferences) {
            for (int i = 0; i < set.getResources().size(); ++i) {
                Resource resource = (Resource)set.getResources().get(i);
                if (resource == null) continue;
                for (EObject content : resource.getContents()) {
                    if (!(content instanceof Grammar)) continue;
                    for (AbstractMetamodelDeclaration decl : ((Grammar)content).getMetamodelDeclarations()) {
                        if (!pack.equals(decl.getEPackage()) || knownReferences.contains(decl)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public void setUnloader(IReferableElementsUnloader unloader) {
            this.unloader = unloader;
        }

        public IReferableElementsUnloader getUnloader() {
            return this.unloader;
        }
    }
}

