/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation.pagetransition.animation;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.PathTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import org.eclipse.fx.ui.animation.pagetransition.CenterSwitchAnimation;

public class PageChangeAnimation
extends CenterSwitchAnimation {
    @Override
    protected Animation createAndPrepareAnimation(Node curNode, Node newNode) {
        Bounds b = curNode.getBoundsInLocal();
        double cX = b.getMinX() + b.getWidth() / 2.0;
        double cY = b.getMinY() + b.getHeight() / 2.0;
        double val = 200.0;
        CubicCurve cIn = new CubicCurve(cX - val, cY, cX - val, cY - val, cX, cY - val, cX, cY);
        CubicCurve cOut = new CubicCurve(cX, cY, cX, cY + val, cX + val, cY + val, cX + val, cY + 0.0);
        ParallelTransition main = new ParallelTransition(new Animation[]{PageChangeAnimation.zoomOut(curNode), PageChangeAnimation.zoomIn(newNode), PageChangeAnimation.move(newNode, (Shape)cIn), PageChangeAnimation.move(curNode, (Shape)cOut), PageChangeAnimation.fadeOut(curNode), PageChangeAnimation.fadeIn(newNode)});
        return new SequentialTransition(new Animation[]{new ParallelTransition(new Animation[]{PageChangeAnimation.zoomOut1(curNode), PageChangeAnimation.zoomOut1(newNode)}), main, new ParallelTransition(new Animation[]{PageChangeAnimation.zoomIn1(curNode), PageChangeAnimation.zoomIn1(newNode)})});
    }

    private static final PathTransition move(Node n, Shape path) {
        return new PathTransition(Duration.millis((double)1000.0), path, n);
    }

    private static final ScaleTransition zoomIn(Node n) {
        ScaleTransition t = new ScaleTransition(Duration.millis((double)1000.0), n);
        t.setInterpolator(Interpolator.EASE_BOTH);
        t.setFromX(0.2);
        t.setFromY(0.2);
        t.setToX(0.7);
        t.setToY(0.7);
        return t;
    }

    private static final ScaleTransition zoomOut(Node n) {
        ScaleTransition t = new ScaleTransition(Duration.millis((double)1000.0), n);
        t.setInterpolator(Interpolator.EASE_BOTH);
        t.setToX(0.2);
        t.setToY(0.2);
        return t;
    }

    private static final FadeTransition fadeOut(Node n) {
        FadeTransition t = new FadeTransition(Duration.millis((double)1000.0), n);
        t.setFromValue(1.0);
        t.setToValue(0.0);
        return t;
    }

    private static final FadeTransition fadeIn(Node n) {
        FadeTransition t = new FadeTransition(Duration.millis((double)1000.0), n);
        t.setFromValue(0.0);
        t.setToValue(1.0);
        return t;
    }

    private static final ScaleTransition zoomOut1(Node n) {
        ScaleTransition s = new ScaleTransition(Duration.millis((double)300.0), n);
        s.setToX(0.7);
        s.setToY(0.7);
        s.setInterpolator(Interpolator.EASE_BOTH);
        return s;
    }

    private static final ScaleTransition zoomIn1(Node n) {
        ScaleTransition s = new ScaleTransition(Duration.millis((double)300.0), n);
        s.setToX(1.0);
        s.setToY(1.0);
        s.setInterpolator(Interpolator.EASE_BOTH);
        return s;
    }

    @Override
    protected void resetProperties(Node curNode, Node newNode) {
        newNode.setTranslateZ(0.0);
        curNode.setTranslateZ(0.0);
        newNode.setRotate(0.0);
        curNode.setRotate(0.0);
        curNode.setScaleX(1.0);
        curNode.setScaleY(1.0);
        curNode.setOpacity(1.0);
        curNode.setTranslateX(0.0);
        curNode.setTranslateY(0.0);
        newNode.setScaleX(1.0);
        newNode.setScaleY(1.0);
        newNode.setOpacity(1.0);
        newNode.setTranslateX(0.0);
        newNode.setTranslateY(0.0);
    }
}

