/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class MavenClasspathHelpers {
    public static boolean isMaven2ClasspathContainer(IPath containerPath) {
        return containerPath != null && containerPath.segmentCount() > 0 && "org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER".equals(containerPath.segment(0));
    }

    public static IClasspathEntry getDefaultContainerEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"));
    }

    public static IClasspathEntry getDefaultContainerEntry(boolean isExported) {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"), (boolean)isExported);
    }

    public static boolean isTestSource(IClasspathEntry entry) {
        return "true".equals(MavenClasspathHelpers.getAttribute(entry, "test"));
    }

    public static String getAttribute(IClasspathEntry entry, String key) {
        if (entry == null || entry.getExtraAttributes().length == 0 || key == null) {
            return null;
        }
        return Stream.of(entry.getExtraAttributes()).filter(a -> key.equals(a.getName())).findFirst().map(IClasspathAttribute::getValue).orElse(null);
    }

    public static boolean hasTestFlagDisabled(MavenProject mavenProject) {
        return mavenProject != null && Boolean.valueOf(mavenProject.getProperties().getProperty("m2e.disableTestClasspathFlag", "false")) != false;
    }
}

