/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.linking.LinkingScopeProviderBinding;
import org.eclipse.xtext.linking.impl.AbstractLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeDelegatingScopeProvider;
import org.eclipse.xtext.scoping.impl.IDelegatingScopeProvider;

public class DefaultLinkingService
extends AbstractLinkingService {
    private static final Logger logger = Logger.getLogger(DefaultLinkingService.class);
    @Inject
    @LinkingScopeProviderBinding
    private IScopeProvider scopeProvider;
    @Inject
    private Provider<ImportedNamesAdapter> importedNamesAdapterProvider;
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IScope getScope(EObject context, EReference reference) {
        if (this.getScopeProvider() == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        try {
            this.registerImportedNamesAdapter(context);
            IScope iScope = this.getScopeProvider().getScope(context, reference);
            return iScope;
        }
        finally {
            this.unRegisterImportedNamesAdapter();
        }
    }

    protected void unRegisterImportedNamesAdapter() {
        this.unRegisterImportedNamesAdapter(this.getScopeProvider());
    }

    protected void unRegisterImportedNamesAdapter(IScopeProvider scopeProvider) {
        if (scopeProvider instanceof AbstractGlobalScopeDelegatingScopeProvider) {
            AbstractGlobalScopeDelegatingScopeProvider provider = (AbstractGlobalScopeDelegatingScopeProvider)scopeProvider;
            provider.setWrapper(null);
        } else if (scopeProvider instanceof IDelegatingScopeProvider) {
            IDelegatingScopeProvider delegatingScopeProvider = (IDelegatingScopeProvider)scopeProvider;
            this.unRegisterImportedNamesAdapter(delegatingScopeProvider.getDelegate());
        }
    }

    protected void registerImportedNamesAdapter(EObject context) {
        this.registerImportedNamesAdapter(this.getScopeProvider(), context);
    }

    protected void registerImportedNamesAdapter(IScopeProvider scopeProvider, EObject context) {
        if (scopeProvider instanceof AbstractGlobalScopeDelegatingScopeProvider) {
            AbstractGlobalScopeDelegatingScopeProvider provider = (AbstractGlobalScopeDelegatingScopeProvider)scopeProvider;
            ImportedNamesAdapter adapter = this.getImportedNamesAdapter(context);
            provider.setWrapper(adapter);
        } else if (scopeProvider instanceof IDelegatingScopeProvider) {
            IDelegatingScopeProvider delegatingScopeProvider = (IDelegatingScopeProvider)scopeProvider;
            this.registerImportedNamesAdapter(delegatingScopeProvider.getDelegate(), context);
        }
    }

    protected ImportedNamesAdapter getImportedNamesAdapter(EObject context) {
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find(context.eResource());
        if (adapter != null) {
            return adapter;
        }
        ImportedNamesAdapter importedNamesAdapter = (ImportedNamesAdapter)this.importedNamesAdapterProvider.get();
        context.eResource().eAdapters().add((Object)importedNamesAdapter);
        return importedNamesAdapter;
    }

    @Override
    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        IScope scope;
        EClass requiredType = ref.getEReferenceType();
        if (requiredType == null) {
            return Collections.emptyList();
        }
        String crossRefString = this.getCrossRefNodeAsString(node);
        if (crossRefString == null || crossRefString.equals("")) {
            return Collections.emptyList();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("before getLinkedObjects: node: '" + crossRefString + "'"));
        }
        if ((scope = this.getScope(context, ref)) == null) {
            throw new AssertionError((Object)("Scope provider " + this.scopeProvider.getClass().getName() + " must not return null for context " + context + ", reference " + ref + "! Consider to return IScope.NULLSCOPE instead."));
        }
        QualifiedName qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
        IEObjectDescription eObjectDescription = scope.getSingleElement(qualifiedLinkName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after getLinkedObjects: node: '" + crossRefString + "' result: " + eObjectDescription));
        }
        if (eObjectDescription == null) {
            return Collections.emptyList();
        }
        EObject result = eObjectDescription.getEObjectOrProxy();
        return Collections.singletonList(result);
    }

    public String getCrossRefNodeAsString(INode node) throws IllegalNodeException {
        return this.linkingHelper.getCrossRefNodeAsString(node, true);
    }

    public void setScopeProvider(IScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    protected LinkingHelper getLinkingHelper() {
        return this.linkingHelper;
    }
}

