/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ApplicationToolkitType implements Enumerator
{
    FX(0, "fx", "fx"),
    SWING(1, "swing", "swing");

    public static final int FX_VALUE = 0;
    public static final int SWING_VALUE = 1;
    private static final ApplicationToolkitType[] VALUES_ARRAY;
    public static final List<ApplicationToolkitType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ApplicationToolkitType[]{FX, SWING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ApplicationToolkitType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApplicationToolkitType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApplicationToolkitType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApplicationToolkitType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApplicationToolkitType get(int value) {
        switch (value) {
            case 0: {
                return FX;
            }
            case 1: {
                return SWING;
            }
        }
        return null;
    }

    private ApplicationToolkitType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

