/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fx.ide.css.cssext.CssExtDslStandaloneSetupGenerated;
import org.eclipse.fx.ide.css.cssext.generator.HTMLDocGenerator;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class HTMLLaunch {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    private HTMLDocGenerator generator = new HTMLDocGenerator();

    public static void main(String[] args) {
        Injector injector = new CssExtDslStandaloneSetupGenerated().createInjectorAndDoEMFRegistration();
        HTMLLaunch main = (HTMLLaunch)injector.getInstance(HTMLLaunch.class);
        main.runGenerator("file:///Users/tomschindl/git/efxclipse/bundles/tooling/org.eclipse.fx.ide.css.jfx8/src/jfx8.cssext");
    }

    protected void runGenerator(String string) {
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        Resource resource = set.getResource(URI.createURI((String)string), true);
        List list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!list.isEmpty()) {
            for (Issue issue : list) {
                System.err.println(issue);
            }
            return;
        }
        String data = this.generator.generate(resource).toString();
        try {
            FileOutputStream out = new FileOutputStream(new File("/Users/tomschindl/git/efxclipse/bundles/tooling/org.eclipse.fx.ide.css.jfx8/jfx8.html"));
            out.write(data.getBytes());
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Code generation finished.");
    }
}

