/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.EGFResourceLoadedListener;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.pages.ImplementationPage;
import org.eclipse.egf.pattern.ui.editors.pages.OverviewPage;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.egf.pattern.ui.editors.pages.SpecificationPage;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class PatternEditor
extends FormEditor
implements EGFResourceLoadedListener.ResourceUser,
IEditingDomainProvider {
    public static final String ID = "org.eclipse.egf.pattern.ui.pattern.editor.id";
    protected ObjectUndoContext undoContext;
    private TransactionalEditingDomain editingDomain;
    protected boolean userHasSavedResource;
    protected boolean resourceHasBeenExternallyChanged;
    protected boolean resourceHasBeenRemoved;
    private Pattern pattern;
    private String partName;
    private final EGFResourceLoadedListener.ResourceListener resourceListener = new EGFResourceLoadedListener.ResourceListener(){

        public void resourceMoved(final Resource movedResource, URI oldURI) {
            if (movedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = false;
                PatternEditor.this.resourceHasBeenRemoved = false;
                PatternEditor.this.userHasSavedResource = false;
                PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternEditor.this.setInputWithNotify(new PatternEditorInput(movedResource, ((PatternEditorInput)PatternEditor.this.getEditorInput()).getID()));
                        PatternEditor.this.firePropertyChange(1);
                    }
                });
            }
        }

        public void resourceDeleted(Resource deletedResource) {
            if (deletedResource == PatternEditor.this.getResource()) {
                if (!PatternEditor.this.isDirty()) {
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternEditor.this, false);
                        }
                    });
                } else {
                    PatternEditor.this.resourceHasBeenRemoved = true;
                }
            }
        }

        public void resourceReloaded(Resource reloadedResource) {
            if (reloadedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = false;
                PatternEditor.this.resourceHasBeenRemoved = false;
                PatternEditor.this.userHasSavedResource = false;
                final PatternEditorInput newEditorInput = new PatternEditorInput(reloadedResource, ((PatternEditorInput)PatternEditor.this.getEditorInput()).getID());
                if (newEditorInput.getPattern() != null) {
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (PatternEditor.this.pattern != newEditorInput.getPattern()) {
                                PatternEditor.this.removePatternChangeAdapter();
                                PatternEditor.this.pattern = newEditorInput.getPattern();
                                PatternEditor.this.addPatternChangeAdapter();
                                PatternEditor.this.getOperationHistory().dispose((IUndoContext)(this).PatternEditor.this.undoContext, true, true, true);
                                PatternEditor.this.firePropertyChange(257);
                                PatternEditor.this.setInputWithNotify(newEditorInput);
                                for (PatternEditorPage page : PatternEditor.this.pages) {
                                    page.rebind(newEditorInput);
                                }
                                PatternEditor.this.firePropertyChange(1);
                            }
                        }
                    });
                } else {
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternEditor.this, false);
                        }
                    });
                }
            }
        }

        public void externalUpdate(Resource changedResource) {
            if (changedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = true;
            }
        }

        public void internalUpdate(Resource changedResource) {
            if (changedResource == PatternEditor.this.getResource()) {
                PatternEditor.this.resourceHasBeenExternallyChanged = false;
                PatternEditor.this.resourceHasBeenRemoved = false;
                PatternEditor.this.userHasSavedResource = false;
                PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternEditor.this.firePropertyChange(257);
                    }
                });
            }
        }
    };
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p == PatternEditor.this) {
                PatternEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    private final List<PatternEditorPage> pages = new ArrayList<PatternEditorPage>();
    protected EContentAdapter editorResourceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 1: {
                        PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                PatternEditor.this.firePropertyChange(257);
                            }
                        });
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource innerTarget) {
            this.basicSetTarget((Notifier)innerTarget);
        }

        protected void unsetTarget(Resource innerTarget) {
            this.basicUnsetTarget((Notifier)innerTarget);
        }
    };
    AdapterImpl patternAdapter = new AdapterImpl(){

        public void notifyChanged(final Notification msg) {
            if (FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME.equals(msg.getFeature())) {
                PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (PatternEditor.this.partName != null && !PatternEditor.this.partName.equals(msg.getNewValue())) {
                            PatternEditor.this.partName = (String)msg.getNewValue();
                            PatternEditor.this.setPartName(PatternEditor.this.partName);
                        }
                    }
                });
            } else if (PatternPackage.Literals.PATTERN__CONTAINER.equals(msg.getFeature()) && msg.getNewValue() == null) {
                PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PatternEditor.this.getSite().getPage().closeEditor((IEditorPart)PatternEditor.this, false);
                    }
                });
            }
        }
    };
    private final IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
            switch (event.getEventType()) {
                case 4: {
                    if (!affectedResources.contains(PatternEditor.this.getResource())) break;
                    IUndoableOperation operation = event.getOperation();
                    operation.removeContext(((IWorkspaceCommandStack)PatternEditor.this.getEditingDomain().getCommandStack()).getDefaultUndoContext());
                    operation.addContext((IUndoContext)PatternEditor.this.undoContext);
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.firePropertyChange(257);
                        }
                    });
                    break;
                }
                case 9: 
                case 10: {
                    if (!affectedResources.contains(PatternEditor.this.getResource())) break;
                    PatternEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PatternEditor.this.firePropertyChange(257);
                        }
                    });
                }
            }
        }
    };

    public PatternEditor() {
        this.initializeEditingDomain();
    }

    public boolean userHasSavedResource() {
        return this.userHasSavedResource;
    }

    public boolean resourceHasBeenExternallyChanged() {
        return this.resourceHasBeenExternallyChanged;
    }

    protected void handleActivate() {
        if (this.resourceHasBeenRemoved) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            }
        } else if (this.resourceHasBeenExternallyChanged) {
            this.handleChangedResource();
        }
    }

    protected void handleChangedResource() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            EGFResourceLoadedListener.getResourceManager().reloadResource(this.getResource());
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    PatternEditor.this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            Resource resourceToSave = PatternEditor.this.getResource();
                            try {
                                long timeStamp = resourceToSave.getTimeStamp();
                                resourceToSave.save(Collections.EMPTY_MAP);
                                if (resourceToSave.getTimeStamp() != timeStamp) {
                                    (this).PatternEditor.this.userHasSavedResource = true;
                                }
                            }
                            catch (Exception e) {
                                ThrowableHandler.handleThrowable((String)Activator.getDefault().getPluginID(), (Throwable)e);
                            }
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (InvocationTargetException ite) {
            ThrowableHandler.handleThrowable((String)Activator.getDefault().getPluginID(), (Throwable)ite);
        }
        catch (InterruptedException e) {
            Assert.isTrue((boolean)false, (String)"This operation can not be canceled.");
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public IOperationHistory getOperationHistory() {
        return ((IWorkspaceCommandStack)this.editingDomain.getCommandStack()).getOperationHistory();
    }

    public ObjectUndoContext getUndoContext() {
        return this.undoContext;
    }

    private void addPatternChangeAdapter() {
        if (this.pattern != null && !this.pattern.eAdapters().contains((Object)this.patternAdapter)) {
            this.pattern.eAdapters().add((Object)this.patternAdapter);
        }
    }

    private void removePatternChangeAdapter() {
        if (this.pattern != null && this.pattern.eAdapters().contains((Object)this.patternAdapter)) {
            this.pattern.eAdapters().remove((Object)this.patternAdapter);
        }
    }

    public String getTitleToolTip() {
        if (this.getEditorInput() == null) {
            return super.getTitleToolTip();
        }
        return EGFCorePlugin.getPlatformURIConverter().normalize(this.getResource().getURI()).toString();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        return super.getAdapter(key);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        if (this.getResource() == null) {
            return false;
        }
        return this.getResource().isModified();
    }

    protected void addPages() {
        try {
            this.addPage(new OverviewPage(this));
            this.addPage(new SpecificationPage(this));
            this.addPage(new ImplementationPage(this));
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
        }
    }

    public Resource getResource() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getResource();
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof PatternEditorInput)) {
            throw new PartInitException(Messages.Editor_wrong_input);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        site.getPage().addPartListener(this.partListener);
        this.pattern = ((PatternEditorInput)this.getEditorInput()).getPattern();
        this.partName = this.pattern.getName();
        this.resourceHasBeenExternallyChanged = EGFResourceLoadedListener.getResourceManager().resourceHasBeenExternallyChanged(this.getResource());
        EGFResourceLoadedListener.getResourceManager().addObserver((EGFResourceLoadedListener.ResourceUser)this);
        EGFResourceLoadedListener.getResourceManager().populateUndoContext(this.getOperationHistory(), this.undoContext, this.getResource());
        this.addPatternChangeAdapter();
        this.setPartName(this.pattern.getName());
    }

    protected void initializeEditingDomain() {
        this.editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        this.undoContext = new ObjectUndoContext((Object)this, "undoContext label");
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.editorResourceAdapter);
    }

    public void dispose() {
        if (this.getEditorInput() != null && this.getEditorInput() instanceof PatternEditorInput) {
            this.getSite().getPage().removePartListener(this.partListener);
            this.removePatternChangeAdapter();
        }
        EGFResourceLoadedListener.getResourceManager().removeObserver((EGFResourceLoadedListener.ResourceUser)this);
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        this.getOperationHistory().dispose((IUndoContext)this.undoContext, true, true, true);
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.editorResourceAdapter);
        super.dispose();
    }

    public void addPage(PatternEditorPage page) throws PartInitException {
        this.pages.add(page);
        this.addPage((IFormPage)page);
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)CoreUIMessages._UI_FileConflict_label, (String)CoreUIMessages._WARN_FileConflict);
    }

    public EGFResourceLoadedListener.ResourceListener getListener() {
        return this.resourceListener;
    }
}

