/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.egf.core.domain.EGFResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.ftask.tasks.ModelDrivenStrategyTask;
import org.eclipse.egf.portfolio.genchain.tools.utils.ActivityInvocationHelper;
import org.eclipse.egf.portfolio.genchain.tools.utils.FCMatcher;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class FcoreBuilderTask
extends ModelDrivenStrategyTask {
    protected void readContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        super.readContext(context, ctx);
        String name = (String)ctx.getValue("name");
        EGFResourceSet resourceSet = new EGFResourceSet();
        ArrayList<FactoryComponent> unusedFC = new ArrayList<FactoryComponent>();
        URI fcoreUri = URI.createPlatformResourceURI((String)((String)ctx.getValue("fcoreOutputPath")), (boolean)true);
        FactoryComponent mainFC = null;
        Resource resource = null;
        try {
            resource = resourceSet.getResource(fcoreUri, true);
            for (EObject obj : resource.getContents()) {
                if (!(obj instanceof FactoryComponent)) continue;
                FactoryComponent fc = (FactoryComponent)obj;
                if (FCMatcher.isLauncherFC(fc)) {
                    mainFC = fc;
                    ActivityInvocationHelper.clearOrchestration(fc);
                    continue;
                }
                unusedFC.add(fc);
            }
        }
        catch (Exception e) {
            resource = resourceSet.createResource(fcoreUri);
        }
        if (mainFC == null) {
            mainFC = ActivityInvocationHelper.createDefaultFC(String.valueOf(name) + " Launcher");
            resource.getContents().add((Object)mainFC);
        }
        HashMap<Object, FactoryComponent> fcs = new HashMap<Object, FactoryComponent>();
        fcs.put(null, mainFC);
        ctx.setValue("target.fcore", (Object)mainFC);
        ctx.setValue("current.fcore", fcs);
        ctx.setValue("genmodel.uris", new HashMap());
        ctx.setValue("unused.fcore", unusedFC);
        ctx.setValue("resource.set", (Object)resourceSet);
    }
}

