/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.templates;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.pattern.PatternPreferences;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.processor.IFcoreProcessor;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.fcore.util.FcoreResourceImpl;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.common.java.BaseJavaAssemblyHelper;
import org.eclipse.egf.pattern.engine.TranslationHelper;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.egf.pattern.utils.TemplateFileHelper;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessor
implements IFcoreProcessor {
    protected List<Pattern> getPatterns(List<? extends Object> objects) {
        UniqueEList patterns = new UniqueEList();
        for (Object object : objects) {
            if (object instanceof FactoryComponent) {
                patterns.addAll(this.getPatterns(Collections.singletonList(((FactoryComponent)object).getViewpointContainer())));
                continue;
            }
            if (object instanceof ViewpointContainer) {
                patterns.addAll(this.getPatterns((List<? extends Object>)((ViewpointContainer)object).getViewpoints()));
                continue;
            }
            if (object instanceof PatternViewpoint) {
                patterns.addAll(this.getPatterns((List<? extends Object>)((PatternViewpoint)object).getLibraries()));
                continue;
            }
            if (object instanceof PatternLibrary) {
                patterns.addAll(this.getPatterns((List<? extends Object>)((PatternLibrary)object).getElements()));
                continue;
            }
            if (!(object instanceof Pattern)) continue;
            patterns.addAll(Collections.singletonList((Pattern)object));
        }
        return patterns;
    }

    protected void excludeDeletedPatternsFromPatterns(EObject eObject, Map<Pattern, PatternLibrary> deletedPatterns, List<Pattern> patterns) {
        block0: for (Pattern pattern : this.getPatterns(Collections.singletonList(eObject))) {
            if (!deletedPatterns.containsKey(pattern)) continue;
            block1: for (Pattern innerPattern : patterns) {
                if (innerPattern == pattern) continue;
                UniqueEList deletedURIs = new UniqueEList();
                for (PatternMethod deletedMethod : innerPattern.getMethods()) {
                    if (deletedMethod.getPatternFilePath() == null) continue;
                    deletedURIs.add(deletedMethod.getPatternFilePath());
                }
                for (PatternMethod method : pattern.getMethods()) {
                    if (!deletedURIs.contains(method.getPatternFilePath())) continue block1;
                }
                deletedPatterns.remove(pattern);
                continue block0;
            }
        }
    }

    protected void processPatternToUpdate(EObject eObject, FeatureChange change, Map<Pattern, PatternLibrary> deletedPatterns, List<Pattern> patternsToUpdate) {
        if (eObject == null || change == null) {
            return;
        }
        BasicEList values = null;
        values = change.getFeature().isMany() ? new BasicEList((Collection)eObject.eGet(change.getFeature())) : Collections.singletonList(eObject.eGet(change.getFeature()));
        block0: for (Object object : values) {
            if (!change.getListChanges().isEmpty()) {
                for (ListChange listChange : change.getListChanges()) {
                    if (listChange.getKind() == ChangeKind.REMOVE_LITERAL) {
                        if (((List)change.getValue()).isEmpty() || ((List)change.getValue()).contains(object)) continue;
                        this.processPatternToUpdate(object, deletedPatterns, patternsToUpdate);
                        continue block0;
                    }
                    if (listChange.getKind() != ChangeKind.ADD_LITERAL) continue;
                    for (Object innerObject : listChange.getReferenceValues()) {
                        if (!(innerObject instanceof EObject) || values.contains(innerObject)) continue;
                        this.excludeDeletedPatternsFromPatterns((EObject)innerObject, deletedPatterns, patternsToUpdate);
                    }
                }
                continue;
            }
            this.processPatternToUpdate(object, deletedPatterns, patternsToUpdate);
        }
    }

    protected void processPatternToRestore(EObject eObject, FeatureChange change, Set<Pattern> deletedPatterns, List<PatternMethod> methodsToDelete, List<PatternMethod> methodsToRestore) {
        if (eObject == null || change == null) {
            return;
        }
        BasicEList values = null;
        values = change.getFeature().isMany() ? new BasicEList((Collection)eObject.eGet(change.getFeature())) : Collections.singletonList(eObject.eGet(change.getFeature()));
        block0: for (Object object : values) {
            if (!change.getListChanges().isEmpty()) {
                for (ListChange listChange : change.getListChanges()) {
                    if (listChange.getKind() != ChangeKind.ADD_LITERAL) continue;
                    if (!listChange.getReferenceValues().isEmpty()) {
                        for (Object innerObject : listChange.getReferenceValues()) {
                            this.processPatternMethodToRestore(innerObject, deletedPatterns, methodsToDelete, methodsToRestore);
                        }
                        continue;
                    }
                    this.processPatternMethodToRestore(object, deletedPatterns, methodsToDelete, methodsToRestore);
                    continue block0;
                }
                continue;
            }
            this.processPatternMethodToRestore(object, deletedPatterns, methodsToDelete, methodsToRestore);
        }
    }

    protected void processPatternToNotDelete(EObject eObject, FeatureChange change, Map<Pattern, PatternLibrary> deletedPatterns, List<Pattern> patternsToUpdate) {
        if (eObject == null || change == null) {
            return;
        }
        BasicEList values = null;
        values = change.getFeature().isMany() ? new BasicEList((Collection)eObject.eGet(change.getFeature())) : Collections.singletonList(eObject.eGet(change.getFeature()));
        for (ListChange listChange : change.getListChanges()) {
            if (listChange.getKind() != ChangeKind.ADD_LITERAL) continue;
            for (Object innerObject : listChange.getReferenceValues()) {
                if (!(innerObject instanceof EObject) || values.contains(innerObject)) continue;
                this.excludeDeletedPatternsFromPatterns((EObject)innerObject, deletedPatterns, patternsToUpdate);
            }
        }
    }

    protected void processPatternToUpdate(Object object, Map<Pattern, PatternLibrary> deletedPatterns, List<Pattern> patternsToUpdate) {
        if (object instanceof PatternMethod) {
            this.processPatternToUpdateConstraint(((PatternMethod)object).getPattern(), deletedPatterns, patternsToUpdate);
        } else {
            for (Pattern pattern : this.getPatterns(Collections.singletonList(object))) {
                this.processPatternToUpdateConstraint(pattern, deletedPatterns, patternsToUpdate);
            }
        }
    }

    protected void processPatternMethodToRestore(Object object, Set<Pattern> deletedPatterns, List<PatternMethod> methodsToDelete, List<PatternMethod> methodsToRestore) {
        if (object instanceof PatternMethod) {
            this.processPatternMethodToRestoreConstraint((PatternMethod)object, methodsToDelete, methodsToRestore);
        } else {
            for (Pattern pattern : this.getPatterns(Collections.singletonList(object))) {
                if (deletedPatterns.contains(pattern)) continue;
                for (PatternMethod method : pattern.getMethods()) {
                    this.processPatternMethodToRestoreConstraint(method, methodsToDelete, methodsToRestore);
                }
            }
        }
    }

    protected boolean processPatternToUpdateConstraint(Pattern pattern, Map<Pattern, PatternLibrary> deletedPatterns, List<Pattern> patternsToUpdate) {
        if (pattern == null) {
            return false;
        }
        if (deletedPatterns.keySet().contains(pattern)) {
            return false;
        }
        patternsToUpdate.add(pattern);
        return true;
    }

    protected boolean processPatternMethodToRestoreConstraint(PatternMethod method, List<PatternMethod> methodsToDelete, List<PatternMethod> methodsToRestore) {
        if (method == null) {
            return false;
        }
        if (methodsToDelete.contains(method)) {
            return false;
        }
        methodsToRestore.add(method);
        return true;
    }

    public void processPreUnload(Resource resource, ChangeDescription changeDescription) {
        if (changeDescription == null || !(resource instanceof FcoreResourceImpl)) {
            return;
        }
        IPlatformFcore fcore = ((FcoreResourceImpl)resource).getIPlatformFcore();
        if (fcore == null || fcore.getPlatformBundle().getProject() == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        HashSet<Pattern> deletedPatterns = new HashSet<Pattern>();
        UniqueEList methodsToDelete = new UniqueEList();
        UniqueEList methodsToRestore = new UniqueEList();
        for (EObject eObject : changeDescription.getObjectsToDetach()) {
            if (eObject instanceof PatternMethod) {
                methodsToDelete.add((PatternMethod)eObject);
                continue;
            }
            for (Pattern pattern : this.getPatterns(Collections.singletonList(eObject))) {
                deletedPatterns.add(pattern);
            }
        }
        block2: for (Map.Entry entry : changeDescription.getObjectChanges().entrySet()) {
            PatternMethod method;
            if (changeDescription.getObjectsToAttach().contains(entry.getKey())) continue;
            if (entry.getKey() instanceof FactoryComponent) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != FcorePackage.Literals.FACTORY_COMPONENT__VIEWPOINT_CONTAINER) continue;
                    this.processPatternToRestore((EObject)entry.getKey(), change, deletedPatterns, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
                    continue block2;
                }
                continue;
            }
            if (entry.getKey() instanceof ViewpointContainer) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != FcorePackage.Literals.VIEWPOINT_CONTAINER__VIEWPOINTS) continue;
                    this.processPatternToRestore((EObject)entry.getKey(), change, deletedPatterns, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
                    continue block2;
                }
                continue;
            }
            if (entry.getKey() instanceof PatternViewpoint) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != PatternPackage.Literals.PATTERN_VIEWPOINT__LIBRARIES) continue;
                    this.processPatternToRestore((EObject)entry.getKey(), change, deletedPatterns, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
                    continue block2;
                }
                continue;
            }
            if (entry.getKey() instanceof PatternLibrary) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS) continue;
                    this.processPatternToRestore((EObject)entry.getKey(), change, deletedPatterns, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
                    continue block2;
                }
                continue;
            }
            if (entry.getKey() instanceof Pattern) {
                Pattern pattern;
                pattern = (Pattern)entry.getKey();
                if (deletedPatterns.contains(pattern)) continue;
                for (PatternMethod method2 : pattern.getMethods()) {
                    this.processPatternMethodToRestoreConstraint(method2, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
                }
                continue;
            }
            if (!(entry.getKey() instanceof PatternMethod) || (method = (PatternMethod)entry.getKey()).getPattern() != null && deletedPatterns.contains(method.getPattern())) continue;
            this.processPatternMethodToRestoreConstraint(method, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
        }
        for (ResourceChange change : changeDescription.getResourceChanges()) {
            for (ListChange listChange : change.getListChanges()) {
                if (listChange.getKind() != ChangeKind.ADD_LITERAL) continue;
                if (!listChange.getReferenceValues().isEmpty()) {
                    for (Object object : listChange.getReferenceValues()) {
                        for (Pattern pattern : this.getPatterns(Collections.singletonList(object))) {
                            for (PatternMethod method : pattern.getMethods()) {
                                this.processPatternMethodToRestoreConstraint(method, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
                            }
                        }
                    }
                    continue;
                }
                for (Object object : change.getValue()) {
                    for (Pattern pattern : this.getPatterns(Collections.singletonList(object))) {
                        for (PatternMethod method : pattern.getMethods()) {
                            this.processPatternMethodToRestoreConstraint(method, (List<PatternMethod>)methodsToDelete, (List<PatternMethod>)methodsToRestore);
                        }
                    }
                }
            }
        }
        if (methodsToDelete.isEmpty() && methodsToRestore.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(EGFPatternMessages.Template_processor, (List)methodsToDelete, (List)methodsToRestore, fcore, startTime){
            private final /* synthetic */ List val$methodsToDelete;
            private final /* synthetic */ List val$methodsToRestore;
            private final /* synthetic */ IPlatformFcore val$fcore;
            private final /* synthetic */ long val$startTime;
            {
                this.val$methodsToDelete = list;
                this.val$methodsToRestore = list2;
                this.val$fcore = iPlatformFcore;
                this.val$startTime = l;
                super($anonymous0);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int ticks = this.val$methodsToDelete.size() * 100 + this.val$methodsToRestore.size() * 100;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
                subMonitor.beginTask(null, ticks);
                try {
                    try {
                        TemplateModelFileHelper.removeTemplates((IProgressMonitor)subMonitor.newChild(100, 0), (List)this.val$methodsToDelete);
                        if (!this.val$methodsToRestore.isEmpty()) {
                            TemplateModelFileHelper.restoreTemplates((IProgressMonitor)subMonitor.newChild(100, 0), (IPlatformFcore)this.val$fcore, (List)this.val$methodsToRestore);
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof CoreException) {
                            IStatus iStatus = ((CoreException)t).getStatus();
                            monitor.done();
                            return iStatus;
                        }
                        IStatus iStatus = EGFModelPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFPatternMessages.Template_processor_fcore_execute_exception, (Object)this.val$fcore.getURI()), t);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                long endTime = System.currentTimeMillis();
                long time = endTime - this.val$startTime;
                if (EGFPatternPlugin.getDefault().isDebugging()) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TemplateProcessor.processPreUnload(...) _ in ''{0}'' ms", (Object)time));
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)EMFHelper.getProject((Resource)resource));
        job.schedule();
    }

    public void processPostSave(Resource resource, ChangeDescription changeDescription) {
        PatternMethod method;
        Pattern pattern2;
        if (changeDescription == null || !(resource instanceof FcoreResourceImpl)) {
            return;
        }
        IPlatformFcore fcore = ((FcoreResourceImpl)resource).getIPlatformFcore();
        if (fcore == null || fcore.getPlatformBundle().getProject() == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        UniqueEList patternsToUpdate = new UniqueEList();
        UniqueEList methodsToDelete = new UniqueEList();
        final HashMap<Pattern, PatternLibrary> deletedPatterns = new HashMap<Pattern, PatternLibrary>();
        HashMap<PatternLibrary, Iterator> updatedLibraries = new HashMap<PatternLibrary, Iterator>();
        HashMap<Pattern, Iterator> updatedPatterns = new HashMap<Pattern, Iterator>();
        for (Object object : changeDescription.getObjectsToAttach()) {
            if (object instanceof PatternMethod) {
                methodsToDelete.add((PatternMethod)object);
                continue;
            }
            block1: for (Pattern pattern2 : this.getPatterns(Collections.singletonList(object))) {
                if (changeDescription.getObjectChanges().get((Object)pattern2) != null) {
                    for (FeatureChange change : (EList)changeDescription.getObjectChanges().get((Object)pattern2)) {
                        Object innerObject;
                        if (change.getFeature() != PatternPackage.Literals.PATTERN__CONTAINER || (innerObject = change.getValue()) == null || !(innerObject instanceof PatternLibrary)) continue;
                        deletedPatterns.put(pattern2, (PatternLibrary)innerObject);
                        continue block1;
                    }
                    continue;
                }
                PatternLibrary library = pattern2.getContainer();
                if (library == null) continue;
                deletedPatterns.put(pattern2, library);
            }
        }
        block3: for (Map.Entry entry : changeDescription.getObjectChanges().entrySet()) {
            if (entry.getKey() instanceof FactoryComponent) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != FcorePackage.Literals.FACTORY_COMPONENT__VIEWPOINT_CONTAINER) continue;
                    this.processPatternToUpdate((EObject)entry.getKey(), change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                    continue block3;
                }
                continue;
            }
            if (entry.getKey() instanceof ViewpointContainer) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != FcorePackage.Literals.VIEWPOINT_CONTAINER__VIEWPOINTS) continue;
                    this.processPatternToUpdate((EObject)entry.getKey(), change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                    continue block3;
                }
                continue;
            }
            if (entry.getKey() instanceof PatternViewpoint) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != PatternPackage.Literals.PATTERN_VIEWPOINT__LIBRARIES) continue;
                    this.processPatternToUpdate((EObject)entry.getKey(), change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                    continue block3;
                }
                continue;
            }
            if (entry.getKey() instanceof PatternLibrary) {
                PatternLibrary library = (PatternLibrary)entry.getKey();
                for (Iterator change : (EList)entry.getValue()) {
                    if (change.getFeature() == FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME) {
                        updatedLibraries.put(library, change);
                        for (Pattern pattern3 : library.getElements()) {
                            this.processPatternToUpdateConstraint(pattern3, deletedPatterns, (List<Pattern>)patternsToUpdate);
                        }
                        continue;
                    }
                    if (change.getFeature() != PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS) continue;
                    this.processPatternToUpdate((EObject)library, (FeatureChange)change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                }
                continue;
            }
            if (entry.getKey() instanceof Pattern) {
                pattern2 = (Pattern)entry.getKey();
                if (!this.processPatternToUpdateConstraint(pattern2, deletedPatterns, (List<Pattern>)patternsToUpdate)) continue;
                for (Iterator change : (EList)entry.getValue()) {
                    if (change.getFeature() == FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME) {
                        updatedPatterns.put(pattern2, change);
                        continue;
                    }
                    if (change.getFeature() != PatternPackage.Literals.PATTERN__CONTAINER) continue;
                    updatedPatterns.put(pattern2, change);
                }
                continue;
            }
            if (!(entry.getKey() instanceof PatternMethod) || methodsToDelete.contains(method = (PatternMethod)entry.getKey()) || method.getPattern() == null) continue;
            patternsToUpdate.add(method.getPattern());
        }
        block10: for (Map.Entry entry : changeDescription.getObjectChanges().entrySet()) {
            if (entry.getKey() instanceof FactoryComponent) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != FcorePackage.Literals.FACTORY_COMPONENT__VIEWPOINT_CONTAINER) continue;
                    this.processPatternToNotDelete((EObject)entry.getKey(), change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                    continue block10;
                }
                continue;
            }
            if (entry.getKey() instanceof ViewpointContainer) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != FcorePackage.Literals.VIEWPOINT_CONTAINER__VIEWPOINTS) continue;
                    this.processPatternToNotDelete((EObject)entry.getKey(), change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                    continue block10;
                }
                continue;
            }
            if (entry.getKey() instanceof PatternViewpoint) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != PatternPackage.Literals.PATTERN_VIEWPOINT__LIBRARIES) continue;
                    this.processPatternToNotDelete((EObject)entry.getKey(), change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                    continue block10;
                }
                continue;
            }
            if (entry.getKey() instanceof PatternLibrary) {
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (change.getFeature() != PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS) continue;
                    this.processPatternToNotDelete((EObject)entry.getKey(), change, deletedPatterns, (List<Pattern>)patternsToUpdate);
                }
                continue;
            }
            if (entry.getKey() instanceof Pattern) {
                pattern2 = (Pattern)entry.getKey();
                if (!this.processPatternToUpdateConstraint(pattern2, deletedPatterns, (List<Pattern>)patternsToUpdate)) continue;
                for (Iterator change : (EList)entry.getValue()) {
                    if (change.getFeature() != PatternPackage.Literals.PATTERN__CONTAINER) continue;
                    this.excludeDeletedPatternsFromPatterns((EObject)pattern2, deletedPatterns, (List<Pattern>)patternsToUpdate);
                }
                continue;
            }
            if (!(entry.getKey() instanceof PatternMethod) || (method = (PatternMethod)entry.getKey()).getPattern() == null) continue;
            Iterator it = methodsToDelete.iterator();
            while (it.hasNext()) {
                PatternMethod deletedMethod = (PatternMethod)it.next();
                if (!deletedMethod.getPatternFilePath().equals((Object)method.getPatternFilePath())) continue;
                it.remove();
                continue block10;
            }
        }
        for (ResourceChange change : changeDescription.getResourceChanges()) {
            for (ListChange listChange : change.getListChanges()) {
                if (listChange.getKind() == ChangeKind.REMOVE_LITERAL) {
                    for (EObject eObject : change.getResource().getContents()) {
                        if (!(eObject instanceof FactoryComponent) || change.getValue().contains((Object)eObject)) continue;
                        for (Pattern pattern4 : this.getPatterns(Collections.singletonList(eObject))) {
                            this.processPatternToUpdateConstraint(pattern4, deletedPatterns, (List<Pattern>)patternsToUpdate);
                        }
                    }
                    continue;
                }
                if (listChange.getKind() != ChangeKind.ADD_LITERAL) continue;
                for (Object object : listChange.getReferenceValues()) {
                    if (!(object instanceof FactoryComponent) || change.getResource().getContents().contains(object)) continue;
                    this.excludeDeletedPatternsFromPatterns((EObject)object, deletedPatterns, (List<Pattern>)patternsToUpdate);
                }
            }
        }
        if (deletedPatterns.isEmpty() && methodsToDelete.isEmpty() && updatedLibraries.isEmpty() && updatedPatterns.isEmpty() && patternsToUpdate.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(EGFPatternMessages.Template_processor, (List)methodsToDelete, updatedLibraries, updatedPatterns, (List)patternsToUpdate, fcore, startTime){
            private final /* synthetic */ List val$methodsToDelete;
            private final /* synthetic */ Map val$updatedLibraries;
            private final /* synthetic */ Map val$updatedPatterns;
            private final /* synthetic */ List val$patternsToUpdate;
            private final /* synthetic */ IPlatformFcore val$fcore;
            private final /* synthetic */ long val$startTime;
            {
                this.val$methodsToDelete = list;
                this.val$updatedLibraries = map2;
                this.val$updatedPatterns = map3;
                this.val$patternsToUpdate = list2;
                this.val$fcore = iPlatformFcore;
                this.val$startTime = l;
                super($anonymous0);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        int ticks = deletedPatterns.size() * 200 + this.val$methodsToDelete.size() * 100 + this.val$updatedLibraries.size() * 100 + this.val$updatedPatterns.size() * 100 + this.val$patternsToUpdate.size() * 100;
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
                        subMonitor.beginTask(null, ticks);
                        for (Map.Entry entry : deletedPatterns.entrySet()) {
                            JavaHelper.deleteJavaResource((IProgressMonitor)subMonitor.newChild(100, 0), (IProject)this.val$fcore.getPlatformBundle().getProject(), (String)PatternPreferences.getGenerationFolderName(), (String)BaseJavaAssemblyHelper.getPackageName((PatternLibrary)entry.getValue()), (String)BaseJavaAssemblyHelper.getClassName((Pattern)entry.getKey()), (boolean)true);
                            TemplateModelFileHelper.removeTemplates((IProgressMonitor)subMonitor.newChild(100, 0), (List)((Pattern)entry.getKey()).getMethods());
                        }
                        TemplateModelFileHelper.removeTemplates((IProgressMonitor)subMonitor.newChild(100, 0), (List)this.val$methodsToDelete);
                        for (Map.Entry entry : this.val$updatedLibraries.entrySet()) {
                            JavaHelper.moveJavaResource((IProgressMonitor)subMonitor.newChild(100, 0), (IProject)this.val$fcore.getPlatformBundle().getProject(), (String)PatternPreferences.getGenerationFolderName(), (String)BaseJavaAssemblyHelper.getPackageName(((FeatureChange)entry.getValue()).getDataValue()), null, (String)BaseJavaAssemblyHelper.getPackageName((PatternLibrary)entry.getKey()), null, (boolean)true);
                        }
                        for (Map.Entry entry : this.val$updatedPatterns.entrySet()) {
                            if (((FeatureChange)entry.getValue()).getFeature() == FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME) {
                                JavaHelper.moveJavaResource((IProgressMonitor)subMonitor.newChild(100, 0), (IProject)this.val$fcore.getPlatformBundle().getProject(), (String)PatternPreferences.getGenerationFolderName(), (String)BaseJavaAssemblyHelper.getPackageName(((Pattern)entry.getKey()).getContainer()), (String)BaseJavaAssemblyHelper.getClassName(((FeatureChange)entry.getValue()).getDataValue()), (String)BaseJavaAssemblyHelper.getPackageName(((Pattern)entry.getKey()).getContainer()), (String)BaseJavaAssemblyHelper.getClassName((Pattern)entry.getKey()), (boolean)true);
                                continue;
                            }
                            if (((FeatureChange)entry.getValue()).getFeature() != PatternPackage.Literals.PATTERN__CONTAINER) continue;
                            JavaHelper.moveJavaResource((IProgressMonitor)subMonitor.newChild(100, 0), (IProject)this.val$fcore.getPlatformBundle().getProject(), (String)PatternPreferences.getGenerationFolderName(), (String)BaseJavaAssemblyHelper.getPackageName((PatternLibrary)((FeatureChange)entry.getValue()).getValue()), (String)BaseJavaAssemblyHelper.getClassName((Pattern)entry.getKey()), (String)BaseJavaAssemblyHelper.getPackageName(((Pattern)entry.getKey()).getContainer()), (String)BaseJavaAssemblyHelper.getClassName((Pattern)entry.getKey()), (boolean)true);
                        }
                        if (!this.val$patternsToUpdate.isEmpty()) {
                            TemplateFileHelper.touchHeaderTemplates((IProgressMonitor)subMonitor.newChild(100, 0), this.val$fcore, TranslationHelper.getOrderedList(new HashSet<Pattern>(this.val$patternsToUpdate)));
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof CoreException) {
                            IStatus iStatus = ((CoreException)t).getStatus();
                            monitor.done();
                            return iStatus;
                        }
                        IStatus iStatus = EGFModelPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFPatternMessages.Template_processor_fcore_execute_exception, (Object)this.val$fcore.getURI()), t);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                long endTime = System.currentTimeMillis();
                long time = endTime - this.val$startTime;
                if (EGFPatternPlugin.getDefault().isDebugging()) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TemplateProcessor.processPostSave(...) _ in ''{0}'' ms", (Object)time));
                    for (Pattern pattern : this.val$patternsToUpdate) {
                        EGFPatternPlugin.getDefault().logInfo(NLS.bind((String)"Touched Pattern {0}", (Object)EcoreUtil.getURI((EObject)pattern)), 1);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)EMFHelper.getProject((Resource)resource));
        job.schedule();
    }
}

