/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.commands.PatternLibraryAddPatternCommand;
import org.eclipse.egf.model.pattern.commands.PatternLibraryRemovePatternCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewpointContainerAddCommand
extends AddCommand {
    protected Resource _resource;
    protected Map<PatternLibrary, List<Pattern>> _patterns;
    protected Map<PatternMethod, URI[]> _methods;
    protected boolean _copy;

    public ViewpointContainerAddCommand(EditingDomain domain, ViewpointContainer viewpointContainer, Collection<?> collection, int index) {
        super(domain, (EObject)viewpointContainer, (EStructuralFeature)FcorePackage.Literals.VIEWPOINT_CONTAINER__VIEWPOINTS, collection, index);
    }

    protected boolean prepare() {
        boolean result = super.prepare();
        if (!result) {
            return false;
        }
        if (!(this.owner instanceof ViewpointContainer)) {
            return false;
        }
        if (this.feature != FcorePackage.Literals.VIEWPOINT_CONTAINER__VIEWPOINTS) {
            return false;
        }
        ViewpointContainer viewpointContainer = (ViewpointContainer)this.owner;
        if (viewpointContainer.eResource() == null || EMFHelper.getProject((Resource)viewpointContainer.eResource()) == null) {
            return false;
        }
        this._patterns = new HashMap<PatternLibrary, List<Pattern>>();
        this._methods = new HashMap<PatternMethod, URI[]>();
        for (Object object : this.collection) {
            if (!(object instanceof EObject)) continue;
            Collection eObjects = EMFHelper.getAllProperContents((EClassifier)PatternPackage.eINSTANCE.getPattern(), (EObject)((EObject)object));
            for (EObject eObject : eObjects) {
                Pattern pattern = (Pattern)eObject;
                UniqueEList patterns = this._patterns.get(pattern.getContainer());
                if (patterns == null) {
                    patterns = new UniqueEList();
                    this._patterns.put(pattern.getContainer(), (List<Pattern>)patterns);
                }
                patterns.add((Pattern)pattern);
                try {
                    for (PatternMethod method : pattern.getMethods()) {
                        URI[] uRIArray = new URI[2];
                        uRIArray[0] = method.getPatternFilePath();
                        this._methods.put(method, uRIArray);
                    }
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }
        this._resource = viewpointContainer.eResource();
        return true;
    }

    public void doExecute() {
        super.doExecute();
        this._copy = PatternLibraryAddPatternCommand.performCreatePatternTemplates(this._resource, this._methods);
    }

    public void doUndo() {
        if (this._copy) {
            for (Map.Entry<PatternLibrary, List<Pattern>> entry : this._patterns.entrySet()) {
                PatternLibraryRemovePatternCommand.performDeletePatterns(this._resource, (Collection<Pattern>)entry.getValue());
            }
        }
        super.doUndo();
    }

    public void doRedo() {
        if (this._copy) {
            for (List<Pattern> patterns : this._patterns.values()) {
                PatternLibraryRemovePatternCommand.performRestorePatterns(this._resource, patterns);
            }
        }
        super.doRedo();
    }
}

