/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.commands.PatternRemovePatternMethodCommand;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternAddPatternMethodCommand
extends AddCommand {
    protected List<PatternMethod> _methods;
    protected Resource _resource;

    public PatternAddPatternMethodCommand(EditingDomain domain, Pattern pattern, Collection<?> collection, int index) {
        super(domain, (EObject)pattern, (EStructuralFeature)PatternPackage.Literals.PATTERN__METHODS, collection, index);
    }

    protected boolean prepare() {
        boolean result = super.prepare();
        if (!result) {
            return false;
        }
        if (!(this.owner instanceof Pattern)) {
            return false;
        }
        if (this.feature != PatternPackage.Literals.PATTERN__METHODS) {
            return false;
        }
        Pattern pattern = (Pattern)this.owner;
        if (pattern.eResource() == null || EMFHelper.getProject((Resource)pattern.eResource()) == null) {
            return false;
        }
        this._methods = new UniqueEList();
        for (Object object : this.collection) {
            if (!(object instanceof PatternMethod)) continue;
            this._methods.add((PatternMethod)object);
        }
        this._resource = pattern.eResource();
        return true;
    }

    public void doExecute() {
        super.doExecute();
        for (PatternMethod method : this._methods) {
            method.setPatternFilePath(TemplateModelFileHelper.computeFileURI((IPlatformFcore)((IPlatformFcoreProvider)this._resource).getIPlatformFcore(), (PatternMethod)method));
        }
    }

    public void doUndo() {
        super.doUndo();
        PatternRemovePatternMethodCommand.performDeletePatternMethods(this._resource, this._methods);
    }

    public void doRedo() {
        super.doRedo();
        PatternRemovePatternMethodCommand.performRestorePatternMethods(this._resource, this._methods);
    }
}

