/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.model.edit.EGFModelEditPlugin;
import org.eclipse.egf.model.edit.l10n.EGFModelEditMessages;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternLibraryRemovePatternCommand
extends RemoveCommand {
    protected List<Pattern> _patterns;
    protected Resource _resource;

    public PatternLibraryRemovePatternCommand(EditingDomain domain, EObject owner, Collection<?> collection) {
        super(domain, owner, (EStructuralFeature)PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS, collection);
    }

    protected boolean prepare() {
        boolean result = super.prepare();
        if (!result) {
            return false;
        }
        if (!(this.owner instanceof PatternLibrary)) {
            return false;
        }
        if (this.feature != PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS) {
            return false;
        }
        PatternLibrary library = (PatternLibrary)this.owner;
        if (library.eResource() == null) {
            return false;
        }
        this._patterns = new UniqueEList();
        for (Object object : this.collection) {
            if (!(object instanceof Pattern)) continue;
            this._patterns.add((Pattern)object);
        }
        this._resource = library.eResource();
        return true;
    }

    public void doUndo() {
        PatternLibraryRemovePatternCommand.performRestorePatterns(this._resource, this._patterns);
        super.doUndo();
    }

    public static void performDeletePatterns(final Resource resource, final Collection<Pattern> patterns) {
        if (resource == null || patterns == null || patterns.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(EGFModelEditMessages.RemovePatternCommand_execute){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * patterns.size()));
                    subMonitor.beginTask(null, 100);
                    MultiStatus statii = new MultiStatus(EGFModelEditPlugin.getPlugin().getSymbolicName(), 4, NLS.bind((String)EGFModelEditMessages.PatternLibraryRemovePatternCommand_execute_exception, (Object)resource.getURI()), null);
                    for (Pattern pattern : patterns) {
                        try {
                            TemplateModelFileHelper.removeTemplates((IProgressMonitor)subMonitor.newChild(100, 0), (List)pattern.getMethods());
                        }
                        catch (Throwable t) {
                            if (t instanceof CoreException) {
                                statii.add(((CoreException)t).getStatus());
                                continue;
                            }
                            statii.add(EGFModelEditPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFModelEditMessages.RemovePatternCommand_execute_exception, (Object)EcoreUtil.getURI((EObject)pattern)), t));
                        }
                    }
                    MultiStatus multiStatus = statii.getChildren().length != 0 ? statii : Status.OK_STATUS;
                    return multiStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setRule((ISchedulingRule)EMFHelper.getProject((Resource)resource));
        job.schedule();
    }

    public static void performRestorePatterns(final Resource resource, final Collection<Pattern> patterns) {
        if (resource == null || patterns == null || patterns.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(EGFModelEditMessages.RestorePatternCommand_execute){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * patterns.size()));
                    MultiStatus statii = new MultiStatus(EGFModelEditPlugin.getPlugin().getSymbolicName(), 4, NLS.bind((String)EGFModelEditMessages.PatternLibraryRestorePatternCommand_execute_exception, (Object)resource.getURI()), null);
                    for (Pattern pattern : patterns) {
                        try {
                            TemplateModelFileHelper.restoreTemplates((IProgressMonitor)subMonitor.newChild(100, 0), (IPlatformFcore)((IPlatformFcoreProvider)resource).getIPlatformFcore(), (List)pattern.getMethods());
                        }
                        catch (Throwable t) {
                            if (t instanceof CoreException) {
                                statii.add(((CoreException)t).getStatus());
                                continue;
                            }
                            statii.add(EGFModelEditPlugin.getPlugin().newStatus(4, NLS.bind((String)EGFModelEditMessages.RestorePatternCommand_execute_exception, (Object)EcoreUtil.getURI((EObject)pattern)), t));
                        }
                    }
                    MultiStatus multiStatus = statii.getChildren().length != 0 ? statii : Status.OK_STATUS;
                    return multiStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setRule((ISchedulingRule)EMFHelper.getProject((Resource)resource));
        job.schedule();
    }
}

