/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.domain.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.DomainHelper;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.FilesystemDomain;

public class FilesystemDomainHelper
implements DomainHelper {
    public boolean loadDomain(Domain domain) throws DomainException {
        if (domain instanceof FilesystemDomain) {
            FilesystemDomain myDomain = (FilesystemDomain)domain;
            if (myDomain.isLoaded()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            myDomain.setLoaded(true);
            File file = new File(myDomain.getPath());
            if (!file.exists()) {
                throw new DomainException(Messages.bind((String)Messages.Load_FilesystemDomain_error1, (Object)myDomain.getPath()));
            }
            if (!myDomain.getContent().isEmpty()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            List<File> children = Arrays.asList(file.listFiles());
            myDomain.getContent().addAll(children);
            return true;
        }
        return false;
    }

    public boolean unLoadDomain(Domain domain) throws DomainException {
        if (domain instanceof FilesystemDomain) {
            FilesystemDomain myDomain = (FilesystemDomain)domain;
            myDomain.getContent().clear();
            myDomain.setLoaded(false);
            return true;
        }
        return false;
    }
}

