/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.ftask.FtaskPackage;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.types.TypesPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class ModelElementBundleAdapter
extends EContentAdapter {
    private Resource _resource;
    private IWorkbenchWindow _window;

    public ModelElementBundleAdapter(Resource resource) {
        this._window = EGFModelEditorPlugin.getActiveWorkbenchWindow();
        this._resource = resource;
    }

    public ModelElementBundleAdapter(Resource resource, IWorkbenchPartSite site) {
        this._window = site != null ? site.getWorkbenchWindow() : EGFModelEditorPlugin.getActiveWorkbenchWindow();
        this._resource = resource;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNewValue() != null && notification.getNewValue() instanceof ModelElement) {
            this.handleNotification(notification);
        }
    }

    private void handleNotification(Notification notification) {
        if (notification.getEventType() == 3 || notification.getEventType() == 1 || notification.getEventType() == 5) {
            ModelElement modelElement = (ModelElement)notification.getNewValue();
            Resource resource = modelElement.eResource();
            if (resource != this._resource || ((ResourceImpl)resource).isLoading()) {
                return;
            }
            IProject project = EMFHelper.getProject((Resource)resource);
            if (project == null) {
                return;
            }
            Collection patterns = EMFHelper.getAllProperContents((EClassifier)PatternPackage.eINSTANCE.getPattern(), (EObject)EcoreUtil.getRootContainer((EObject)modelElement, (boolean)true));
            Collection tasks = EMFHelper.getAllProperContents((EClassifier)FtaskPackage.eINSTANCE.getTask(), (EObject)EcoreUtil.getRootContainer((EObject)modelElement, (boolean)true));
            Collection typeClasses = EMFHelper.getAllProperContents((EClassifier)TypesPackage.eINSTANCE.getTypeClass(), (EObject)EcoreUtil.getRootContainer((EObject)modelElement, (boolean)true));
            ConvertProjectOperation operation = null;
            if (patterns.isEmpty() && tasks.isEmpty()) {
                if (!typeClasses.isEmpty()) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (javaProject != null && javaProject.exists()) {
                        try {
                            javaProject.close();
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                        return;
                    }
                    operation = new ConvertProjectOperation(project, true, true){

                        public List<String> addDependencies() {
                            ArrayList<String> dependencies = new ArrayList<String>(1);
                            dependencies.add("org.eclipse.egf.model.ftask");
                            return dependencies;
                        }

                        public List<String> addSourceFolders() {
                            ArrayList<String> sourceFolders = new ArrayList<String>(1);
                            sourceFolders.add("src");
                            return sourceFolders;
                        }
                    };
                }
            } else {
                operation = patterns.isEmpty() && !tasks.isEmpty() ? new ConvertProjectOperation(project, true, true){

                    public List<String> addDependencies() {
                        ArrayList<String> dependencies = new ArrayList<String>(1);
                        dependencies.add("org.eclipse.egf.model.ftask");
                        return dependencies;
                    }

                    public List<String> addSourceFolders() {
                        ArrayList<String> sourceFolders = new ArrayList<String>(1);
                        sourceFolders.add("src");
                        return sourceFolders;
                    }
                } : new ConvertProjectOperation(project, true, true){

                    public List<String> addDependencies() {
                        ArrayList<String> dependencies = new ArrayList<String>(2);
                        dependencies.add("org.eclipse.egf.pattern");
                        dependencies.add("org.eclipse.egf.pattern.ftask");
                        return dependencies;
                    }

                    public List<String> addSourceFolders() {
                        ArrayList<String> sourceFolders = new ArrayList<String>(1);
                        sourceFolders.add("generated");
                        return sourceFolders;
                    }
                };
            }
            try {
                if (operation != null) {
                    this._window.run(false, false, (IRunnableWithProgress)operation);
                    this._window.getWorkbench().getDisplay().readAndDispatch();
                }
            }
            catch (InterruptedException javaProject) {
            }
            catch (Exception e) {
                ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)e);
            }
        }
    }
}

