/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.helper;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.core.l10n.EGFCoreMessages;

public class EclipseBuilderHelper {
    private EclipseBuilderHelper() {
    }

    public static void addNature(IProjectDescription description, String nature, IProgressMonitor monitor) {
        SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.EclipseBuilderHelper_addNature, (int)100);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)nature);
        Assert.isLegal((nature.trim().length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)monitor);
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = nature.trim();
        description.setNatureIds(newNatures);
    }

    public static void addToFrontOfBuildSpec(IProjectDescription description, String builder, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.EclipseBuilderHelper_addBuilder, (int)300);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)builder);
        Assert.isLegal((builder.trim().length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)monitor);
        ICommand builderCommand = EclipseBuilderHelper.getBuilderCommand(description, builder, (IProgressMonitor)subMonitor.newChild(100, 0));
        if (builderCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builder.trim());
            EclipseBuilderHelper.setFrontBuilderCommand(description, command, (IProgressMonitor)subMonitor.newChild(100, 0));
        }
    }

    public static void addToBuildSpec(IProjectDescription description, String builder, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.EclipseBuilderHelper_addBuilder, (int)300);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)builder);
        Assert.isLegal((builder.trim().length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)monitor);
        ICommand builderCommand = EclipseBuilderHelper.getBuilderCommand(description, builder, (IProgressMonitor)subMonitor.newChild(100, 0));
        if (builderCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builder.trim());
            EclipseBuilderHelper.setBuilderCommand(description, command, (IProgressMonitor)subMonitor.newChild(100, 0));
        }
    }

    public static ICommand getBuilderCommand(IProjectDescription description, String builder, IProgressMonitor monitor) {
        SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.EclipseBuilderHelper_getBuilder, (int)100);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)builder);
        Assert.isLegal((builder.trim().length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)monitor);
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builder)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static void removeFromBuildSpec(IProjectDescription description, String builder, IProgressMonitor monitor) {
        SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.EclipseBuilderHelper_removeBuilder, (int)100);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)builder);
        Assert.isLegal((builder.trim().length() > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)monitor);
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builder.trim())) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                break;
            }
            ++i;
        }
    }

    public static void setBuilderCommand(IProjectDescription description, ICommand command, IProgressMonitor monitor) {
        ICommand[] newCommands;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.EclipseBuilderHelper_setBuilder, (int)200);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)command);
        Assert.isNotNull((Object)monitor);
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldBuilderCommand = EclipseBuilderHelper.getBuilderCommand(description, command.getBuilderName(), (IProgressMonitor)subMonitor.newChild(100, 0));
        if (oldBuilderCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldBuilderCommand) {
                    oldCommands[i] = command;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
    }

    public static void setFrontBuilderCommand(IProjectDescription description, ICommand command, IProgressMonitor monitor) {
        ICommand[] newCommands;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.EclipseBuilderHelper_setBuilder, (int)200);
        Assert.isNotNull((Object)description);
        Assert.isNotNull((Object)command);
        Assert.isNotNull((Object)monitor);
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldBuilderCommand = EclipseBuilderHelper.getBuilderCommand(description, command.getBuilderName(), (IProgressMonitor)subMonitor.newChild(100, 0));
        if (oldBuilderCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = command;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldBuilderCommand) {
                    oldCommands[i] = command;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
    }
}

