/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.tools;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.core.helper.EclipseBuilderHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifest;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertProjectOperation
extends WorkspaceModifyOperation {
    private static final String __defaultLibrary = ".";
    private IProject _project;
    private boolean _createJavaProject;
    private boolean _createEGFNature;
    private List<String> _sourceFolders;
    private List<String> _outputFolders;
    private List<String> _libraries;
    private List<String> _directories;
    private List<IClasspathEntry> _classpathEntries;
    private boolean _hasEGFNature;
    private boolean _hasPluginNature;
    private boolean _hasJavaNature;
    private boolean _hasPatternBuilder;
    private boolean _hasManifestBuilder;
    private boolean _hasSchemaBuilder;
    private boolean _hasJavaBuilder;

    public ConvertProjectOperation(IProject project, boolean createJavaProject, boolean createEGFNature) {
        this._project = project;
        this._createJavaProject = createJavaProject;
        this._createEGFNature = createEGFNature;
    }

    public static String getValidId(String projectName) {
        String name = projectName.replaceAll("[^a-zA-Z0-9\\._]", "_");
        if (name != null && name.startsWith(__defaultLibrary)) {
            return name.substring(1, name.length());
        }
        return name;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String[] natureIds;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.ConvertProjectOperation_converter, (int)1000);
        this._hasEGFNature = false;
        this._hasPluginNature = false;
        this._hasJavaNature = false;
        this._hasPatternBuilder = false;
        this._hasManifestBuilder = false;
        this._hasSchemaBuilder = false;
        this._hasJavaBuilder = false;
        this._outputFolders = new UniqueEList();
        this._classpathEntries = new UniqueEList();
        if (this._project == null || !this._project.exists()) {
            return;
        }
        URI projectLocationURI = URI.createFileURI((String)this._project.getFullPath().toOSString());
        if (this._project.hasNature("org.eclipse.egf.core.EGFNature")) {
            this._hasEGFNature = true;
        }
        if (this._project.hasNature("org.eclipse.pde.PluginNature")) {
            this._hasPluginNature = true;
        }
        if (this._project.hasNature("org.eclipse.jdt.core.javanature")) {
            this._hasJavaNature = true;
            IJavaProject javaProject = null;
            try {
                javaProject = JavaCore.create((IProject)this._project);
                this._classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
                for (String outputFolder : JavaHelper.getStringOutputFolders((IJavaProject)javaProject)) {
                    this._outputFolders.add(String.valueOf(outputFolder) + '/');
                }
            }
            finally {
                if (javaProject != null) {
                    javaProject.close();
                }
            }
        }
        IProjectDescription projectDescription = null;
        if (!this._project.exists()) {
            projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(this._project.getName());
            if (projectLocationURI != null) {
                try {
                    projectDescription.setLocationURI(new java.net.URI(projectLocationURI.toString()));
                }
                catch (URISyntaxException use) {
                    throw new CoreException(EGFPDEPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, use));
                }
            }
            this._project.create(projectDescription, (IProgressMonitor)subMonitor.newChild(100, 0));
        } else {
            projectDescription = this._project.getDescription();
            subMonitor.worked(100);
        }
        ICommand[] builders = projectDescription.getBuildSpec();
        if (builders != null) {
            int i = 0;
            while (i < builders.length) {
                if ("org.eclipse.pde.ManifestBuilder".equals(builders[i].getBuilderName())) {
                    this._hasManifestBuilder = true;
                } else if ("org.eclipse.pde.SchemaBuilder".equals(builders[i].getBuilderName())) {
                    this._hasSchemaBuilder = true;
                } else if ("org.eclipse.jdt.core.javabuilder".equals(builders[i].getBuilderName())) {
                    this._hasJavaBuilder = true;
                } else if ("org.eclipse.egf.pattern.ui.PatternBuilder".equals(builders[i].getBuilderName())) {
                    this._hasPatternBuilder = true;
                }
                ++i;
            }
        }
        if ((natureIds = projectDescription.getNatureIds()) == null) {
            natureIds = this._createJavaProject ? new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.eclipse.egf.core.EGFNature"} : new String[]{"org.eclipse.pde.PluginNature"};
            projectDescription.setNatureIds(natureIds);
            subMonitor.worked(200);
        } else {
            if (!this._hasEGFNature && this._createEGFNature) {
                EclipseBuilderHelper.addNature((IProjectDescription)projectDescription, (String)"org.eclipse.egf.core.EGFNature", (IProgressMonitor)subMonitor.newChild(100, 0));
            } else {
                subMonitor.worked(100);
            }
            if (!this._hasJavaNature && this._createJavaProject) {
                EclipseBuilderHelper.addNature((IProjectDescription)projectDescription, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)subMonitor.newChild(100, 0));
            } else {
                subMonitor.worked(100);
            }
            if (!this._hasPluginNature) {
                EclipseBuilderHelper.addNature((IProjectDescription)projectDescription, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)subMonitor.newChild(100, 0));
            } else {
                subMonitor.worked(100);
            }
        }
        if (!this._hasPatternBuilder && this._createEGFNature) {
            EclipseBuilderHelper.addToFrontOfBuildSpec((IProjectDescription)projectDescription, (String)"org.eclipse.egf.pattern.ui.PatternBuilder", (IProgressMonitor)subMonitor.newChild(100, 0));
        } else {
            subMonitor.worked(100);
        }
        if (!this._hasJavaBuilder && this._createJavaProject) {
            EclipseBuilderHelper.addToBuildSpec((IProjectDescription)projectDescription, (String)"org.eclipse.jdt.core.javabuilder", (IProgressMonitor)subMonitor.newChild(100, 0));
        } else {
            subMonitor.worked(100);
        }
        if (!this._hasManifestBuilder) {
            EclipseBuilderHelper.addToBuildSpec((IProjectDescription)projectDescription, (String)"org.eclipse.pde.ManifestBuilder", (IProgressMonitor)subMonitor.newChild(100, 0));
        } else {
            subMonitor.worked(100);
        }
        if (!this._hasSchemaBuilder) {
            EclipseBuilderHelper.addToBuildSpec((IProjectDescription)projectDescription, (String)"org.eclipse.pde.SchemaBuilder", (IProgressMonitor)subMonitor.newChild(100, 0));
        } else {
            subMonitor.worked(100);
        }
        this._project.setDescription(projectDescription, (IProgressMonitor)subMonitor.newChild(100, 0));
        this.setupEntries(monitor);
        if (this._hasPluginNature && this._project.getFile("META-INF/MANIFEST.MF").exists()) {
            this.updateManifestFile((IProgressMonitor)subMonitor.newChild(100, 0));
        } else {
            this.createManifestFile(this._project.getFile("META-INF/MANIFEST.MF"), (IProgressMonitor)subMonitor.newChild(100, 0));
        }
        if (this._hasPluginNature && this._project.getFile("build.properties").exists()) {
            this.updateBuildFile((IProgressMonitor)subMonitor.newChild(100, 0));
        } else {
            this.createBuildFile(this._project.getFile("build.properties"), (IProgressMonitor)subMonitor.newChild(100, 0));
        }
    }

    private void setupEntries(IProgressMonitor monitor) throws CoreException {
        block29: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.ConvertProjectOperation_setupClasspath, (int)400);
            boolean isInitiallyEmpty = this._classpathEntries.isEmpty();
            boolean hasRequiredPluginsContainer = false;
            UniqueEList sources = new UniqueEList();
            UniqueEList libraries = new UniqueEList();
            UniqueEList directories = new UniqueEList();
            for (IClasspathEntry currentClassPath : this._classpathEntries) {
                int contentType = currentClassPath.getEntryKind();
                if (contentType == 3) {
                    String relativePath = this.getRelativePath(currentClassPath, this._project);
                    if ("".equals(relativePath)) {
                        Path src = new Path("src");
                        IFolder sourceContainer = this._project.getFolder((IPath)src);
                        if (!sourceContainer.exists()) {
                            sourceContainer.create(false, true, (IProgressMonitor)subMonitor.newChild(100, 0));
                        }
                        sources.add(String.valueOf(src.toString()) + '/');
                        IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)sourceContainer.getFullPath());
                        Iterator<IClasspathEntry> i = this._classpathEntries.iterator();
                        while (i.hasNext()) {
                            IClasspathEntry classpathEntry = i.next();
                            if (!classpathEntry.getPath().isPrefixOf(sourceContainer.getFullPath())) continue;
                            i.remove();
                        }
                        this._classpathEntries.add(0, sourceClasspathEntry);
                        continue;
                    }
                    sources.add(String.valueOf(relativePath) + '/');
                    continue;
                }
                if (contentType == 1) {
                    String path = this.getRelativePath(currentClassPath, this._project);
                    if (path.length() > 0) {
                        libraries.add(path);
                        continue;
                    }
                    libraries.add(__defaultLibrary);
                    continue;
                }
                if (contentType != 5 || !"org.eclipse.pde.core.requiredPlugins".equals(currentClassPath.getPath().toString())) continue;
                hasRequiredPluginsContainer = true;
            }
            subMonitor.worked(100);
            if ((this._hasJavaNature || this._createJavaProject) && this.addSourceFolders() != null) {
                for (String sourceFolder : this.addSourceFolders()) {
                    Path src = new Path(sourceFolder);
                    IFolder sourceContainer = this._project.getFolder((IPath)src);
                    if (!sourceContainer.exists()) {
                        sourceContainer.create(false, true, (IProgressMonitor)subMonitor.newChild(100, 0));
                    }
                    sources.add(String.valueOf(src.toString()) + '/');
                    IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)sourceContainer.getFullPath());
                    Iterator<IClasspathEntry> i = this._classpathEntries.iterator();
                    while (i.hasNext()) {
                        IClasspathEntry classpathEntry = i.next();
                        if (!classpathEntry.getPath().isPrefixOf(sourceContainer.getFullPath())) continue;
                        i.remove();
                    }
                    this._classpathEntries.add(0, sourceClasspathEntry);
                }
            } else {
                subMonitor.worked(100);
            }
            IResource[] iResourceArray = this._project.members();
            int src = iResourceArray.length;
            int n = 0;
            while (n < src) {
                String path;
                IResource resource = iResourceArray[n];
                if (resource instanceof IContainer && !sources.contains(path = String.valueOf(resource.getFullPath().removeFirstSegments(1).toString()) + '/') && !this._outputFolders.contains(path) && !path.startsWith(__defaultLibrary)) {
                    directories.add(path);
                }
                ++n;
            }
            this._sourceFolders = sources;
            this._libraries = libraries;
            this._directories = directories;
            if (this._hasJavaNature || this._createJavaProject) {
                try {
                    if (isInitiallyEmpty) {
                        IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                        Iterator<IClasspathEntry> i = this._classpathEntries.iterator();
                        while (i.hasNext()) {
                            IClasspathEntry classpathEntry = i.next();
                            if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                            i.remove();
                        }
                        String jreContainer = JavaRuntime.JRE_CONTAINER;
                        String complianceLevel = CodeGenUtil.EclipseUtil.getJavaComplianceLevel((IProject)this._project);
                        if ("1.5".equals(complianceLevel)) {
                            jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5";
                        } else if ("1.6".equals(complianceLevel)) {
                            jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6";
                        } else if ("1.7".equals(complianceLevel)) {
                            jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.7";
                        }
                        this._classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(jreContainer)));
                    }
                    if (!hasRequiredPluginsContainer) {
                        this._classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                    }
                    IJavaProject javaProject = null;
                    try {
                        javaProject = JavaCore.create((IProject)this._project);
                        javaProject.setRawClasspath(this._classpathEntries.toArray(new IClasspathEntry[this._classpathEntries.size()]), (IProgressMonitor)subMonitor.newChild(100, 0));
                        break block29;
                    }
                    finally {
                        if (javaProject != null) {
                            javaProject.close();
                        }
                    }
                }
                catch (JavaModelException jme) {
                    throw new CoreException(EGFPDEPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, jme));
                }
            }
            subMonitor.worked(100);
        }
    }

    private String getRelativePath(IClasspathEntry classpathEntry, IProject project) {
        return project.getFile(classpathEntry.getPath()).getProjectRelativePath().removeFirstSegments(1).toString();
    }

    private void organizeExports(IProgressMonitor monitor) {
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(this._project.getFile("META-INF/MANIFEST.MF")){

            protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                SubMonitor.convert((IProgressMonitor)innerMonitor, (String)EGFCoreMessages.ConvertProjectOperation_organizeExport, (int)100);
                if (!(model instanceof IBundlePluginModelBase)) {
                    return;
                }
                OrganizeManifest.organizeExportPackages((IBundle)((IBundlePluginModelBase)model).getBundleModel().getBundle(), (IProject)ConvertProjectOperation.this._project, (boolean)true, (boolean)true);
            }
        }, (IProgressMonitor)monitor);
    }

    protected String createInitialName(String id) {
        int loc = id.lastIndexOf(__defaultLibrary);
        if (loc == -1) {
            return id;
        }
        StringBuffer buf = new StringBuffer(id.substring(loc + 1));
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        return buf.toString();
    }

    private void createBuildFile(IFile file, IProgressMonitor monitor) throws CoreException {
        SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.ConvertProjectOperation_setupBuildfile, (int)100);
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            this.manageBuildFile((IBuildModel)model);
            model.save();
        }
    }

    private void updateBuildFile(IProgressMonitor monitor) {
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(this._project.getFile("build.properties")){

            protected void modifyModel(IBaseModel base, IProgressMonitor innerMonitor) throws CoreException {
                SubMonitor.convert((IProgressMonitor)innerMonitor, (String)EGFCoreMessages.ConvertProjectOperation_setupBuildfile, (int)100);
                if (!(base instanceof IBuildModel)) {
                    return;
                }
                ConvertProjectOperation.this.manageBuildFile((IBuildModel)base);
            }
        }, (IProgressMonitor)monitor);
    }

    protected void processFolders(IBuildModel model, String prefix, List<String> folders) throws CoreException {
        IBuildEntry entry;
        IBuild build = model.getBuild();
        UniqueEList defaultFolders = new UniqueEList(folders);
        IBuildEntry[] iBuildEntryArray = build.getBuildEntries();
        int n = iBuildEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            entry = iBuildEntryArray[n2];
            if (entry.getName().startsWith(prefix) && !entry.getName().equals(String.valueOf(prefix) + __defaultLibrary)) {
                boolean hasFolders = false;
                String[] stringArray = entry.getTokens();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String token = stringArray[n4];
                    hasFolders = defaultFolders.remove(token);
                    ++n4;
                }
                if (!hasFolders) {
                    build.remove(entry);
                }
            }
            ++n2;
        }
        entry = build.getEntry(String.valueOf(prefix) + __defaultLibrary);
        if (defaultFolders.size() > 0) {
            if (entry == null) {
                entry = model.getFactory().createEntry(String.valueOf(prefix) + __defaultLibrary);
                build.add(entry);
            }
            for (String folder : defaultFolders) {
                this.addToken(entry, folder);
            }
        } else if (entry != null) {
            build.remove(entry);
        }
    }

    protected void manageBuildFile(IBuildModel model) throws CoreException {
        IBuild build = model.getBuild();
        this.processFolders(model, "source.", this._sourceFolders);
        this.processFolders(model, "output.", this._outputFolders);
        IBuildEntry binIncludesEntry = build.getEntry("bin.includes");
        boolean newBinIncludesEntry = false;
        if (binIncludesEntry == null) {
            newBinIncludesEntry = true;
            binIncludesEntry = model.getFactory().createEntry("bin.includes");
        }
        if (this._project.getFile("plugin.xml").exists()) {
            this.addToken(binIncludesEntry, "plugin.xml");
        }
        if (this._project.getFile("plugin.properties").exists()) {
            this.addToken(binIncludesEntry, "plugin.properties");
        }
        if (this._project.getFile("META-INF/MANIFEST.MF").exists()) {
            this.addToken(binIncludesEntry, "META-INF/");
        }
        if (this._project.getFile("about.html").exists()) {
            this.addToken(binIncludesEntry, "about.html");
        }
        for (String directory : this._directories) {
            this.addToken(binIncludesEntry, directory);
        }
        for (String library : this._libraries) {
            this.addToken(binIncludesEntry, library);
        }
        if (this._sourceFolders.size() > 0) {
            this.addToken(binIncludesEntry, __defaultLibrary);
        }
        if (newBinIncludesEntry && binIncludesEntry.getTokens().length > 0) {
            build.add(binIncludesEntry);
        } else if (binIncludesEntry.getTokens().length == 0) {
            build.remove(binIncludesEntry);
        }
        IBuildEntry srcIncludesEntry = build.getEntry("src.includes");
        boolean newSrcIncludesEntry = false;
        if (srcIncludesEntry == null) {
            newSrcIncludesEntry = true;
            srcIncludesEntry = model.getFactory().createEntry("src.includes");
        }
        if (this._project.getFile("about.html").exists()) {
            this.addToken(srcIncludesEntry, "about.html");
        }
        if (newSrcIncludesEntry && srcIncludesEntry.getTokens().length > 0) {
            build.add(srcIncludesEntry);
        } else if (srcIncludesEntry.getTokens().length == 0) {
            build.remove(srcIncludesEntry);
        }
    }

    protected void addToken(IBuildEntry entry, String descriptor) throws CoreException {
        boolean found = false;
        String[] stringArray = entry.getTokens();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.equals(descriptor)) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            entry.addToken(descriptor);
        }
    }

    private void createManifestFile(IFile file, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFCoreMessages.ConvertProjectOperation_setupManifestfile, (int)200);
        WorkspaceBundlePluginModel model = new WorkspaceBundlePluginModel(file, null);
        model.load();
        this.manageManifestFile((IBundlePluginModelBase)model);
        model.save();
        subMonitor.worked(100);
        this.organizeExports((IProgressMonitor)subMonitor.newChild(100, 0));
    }

    private void updateManifestFile(IProgressMonitor monitor) {
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(this._project.getFile("META-INF/MANIFEST.MF")){

            protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)innerMonitor, (String)EGFCoreMessages.ConvertProjectOperation_setupManifestfile, (int)200);
                if (!(model instanceof IBundlePluginModelBase)) {
                    return;
                }
                ConvertProjectOperation.this.manageManifestFile((IBundlePluginModelBase)model);
                subMonitor.worked(100);
                OrganizeManifest.organizeExportPackages((IBundle)((IBundlePluginModelBase)model).getBundleModel().getBundle(), (IProject)ConvertProjectOperation.this._project, (boolean)true, (boolean)true);
            }
        }, (IProgressMonitor)monitor);
    }

    protected void manageManifestFile(IBundlePluginModelBase model) throws CoreException {
        boolean missingInfo;
        IBundle bundle = model.getBundleModel().getBundle();
        String pluginId = bundle.getHeader("Bundle-SymbolicName");
        String pluginName = bundle.getHeader("Bundle-Name");
        String pluginVersion = bundle.getHeader("Bundle-Version");
        String complianceLevel = bundle.getHeader("Bundle-RequiredExecutionEnvironment");
        if (pluginId != null && pluginId.indexOf(59) != -1) {
            pluginId = pluginId.substring(0, pluginId.indexOf(59));
        }
        if (pluginId != null && pluginId.trim().length() == 0) {
            pluginId = null;
        }
        boolean bl = missingInfo = pluginId == null || pluginName == null || pluginVersion == null;
        if (pluginId == null) {
            pluginId = ConvertProjectOperation.getValidId(this._project.getName());
        }
        this.processManifestVersion(model);
        if (pluginName == null) {
            pluginName = this.createInitialName(pluginId);
        }
        bundle.setHeader("Bundle-Name", pluginName);
        IManifestHeader header = bundle.getManifestHeader("Bundle-SymbolicName");
        if (header != null && header instanceof BundleSymbolicNameHeader) {
            BundleSymbolicNameHeader symbolic = (BundleSymbolicNameHeader)header;
            if (symbolic.getId() == null || symbolic.getId().trim().length() == 0) {
                symbolic.setId(pluginId);
            }
            bundle.setHeader("Bundle-SymbolicName", String.valueOf(pluginId) + ";singleton:=true");
        } else {
            bundle.setHeader("Bundle-SymbolicName", String.valueOf(pluginId) + ";singleton:=true");
        }
        if (complianceLevel == null && this._createJavaProject) {
            complianceLevel = CodeGenUtil.EclipseUtil.getJavaComplianceLevel((IProject)this._project);
            if ("1.5".equals(complianceLevel)) {
                bundle.setHeader("Bundle-RequiredExecutionEnvironment", "J2SE-1.5");
            } else if ("1.6".equals(complianceLevel)) {
                bundle.setHeader("Bundle-RequiredExecutionEnvironment", "JavaSE-1.6");
            } else if ("1.7".equals(complianceLevel)) {
                bundle.setHeader("Bundle-RequiredExecutionEnvironment", "JavaSE-1.7");
            }
        }
        IPluginModelFactory factory = model.getPluginFactory();
        IPluginBase base = model.getPluginBase();
        if (missingInfo) {
            for (String library : this._libraries) {
                IPluginLibrary pluginLibrary = factory.createLibrary();
                pluginLibrary.setName(library);
                pluginLibrary.setExported(true);
                base.add(pluginLibrary);
            }
            bundle.setHeader("Bundle-ManifestVersion", "2");
        }
        if (this._createJavaProject) {
            block1: for (String dependency : this.addDependencies()) {
                IPluginImport plugin;
                if (base.getImports() != null) {
                    IPluginImport[] iPluginImportArray = base.getImports();
                    int n = iPluginImportArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        plugin = iPluginImportArray[n2];
                        if (plugin.getId().equals(dependency)) continue block1;
                        ++n2;
                    }
                }
                plugin = factory.createImport();
                plugin.setId(dependency);
                plugin.setName(dependency);
                plugin.setReexported(true);
                base.add(plugin);
            }
        }
    }

    protected void processManifestVersion(IBundlePluginModelBase model) {
        IBundle bundle = model.getBundleModel().getBundle();
        String pluginVersion = bundle.getHeader("Bundle-Version");
        if (pluginVersion == null) {
            pluginVersion = "0.1.0.qualifier";
        } else {
            Version version = Version.parseVersion((String)pluginVersion);
            String major = version.getMajor() != 0 ? Integer.toString(version.getMajor()) : "0";
            String minor = version.getMinor() != 0 ? Integer.toString(version.getMinor()) : "1";
            String micro = version.getMicro() != 0 ? Integer.toString(version.getMicro()) : "0";
            String qualifier = version.getQualifier() != null && version.getQualifier().trim().length() != 0 ? version.getQualifier() : "qualifier";
            pluginVersion = String.valueOf(major) + __defaultLibrary + minor + __defaultLibrary + micro + __defaultLibrary + qualifier;
        }
        bundle.setHeader("Bundle-Version", pluginVersion);
    }

    public List<String> addDependencies() {
        return Collections.emptyList();
    }

    public List<String> addSourceFolders() {
        return Collections.emptyList();
    }
}

