/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.extension;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.extension.PatternFactory;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.osgi.util.NLS;

public abstract class PatternExtension {
    public static final String EXTENSION_ID = "org.eclipse.egf.pattern.extension";

    public abstract PatternNature getNature();

    public abstract PatternFactory getFactory();

    protected abstract AdapterFactory getAdapterFactory();

    protected abstract PatternEngine doCreateRunner(Pattern var1) throws PatternException;

    public PatternEngine createEngine(Pattern pattern) throws PatternException {
        if (!this.matchNature(pattern)) {
            throw new PatternException(NLS.bind((String)EGFPatternMessages.extension_error2, (Object)this.getNature().eClass().getName(), (Object)pattern.getNature().eClass().getName()));
        }
        return this.doCreateRunner(pattern);
    }

    protected abstract PatternInitializer doCreateInitializer(IProject var1, Pattern var2);

    public PatternInitializer createInitializer(IProject project, Pattern pattern) throws PatternException {
        if (!this.matchNature(pattern)) {
            throw new PatternException(NLS.bind((String)EGFPatternMessages.extension_error2, (Object)this.getNature().eClass().getName(), (Object)pattern.getNature().eClass().getName()));
        }
        return this.doCreateInitializer(project, pattern);
    }

    public boolean matchNature(Pattern pattern) {
        if (pattern == null || pattern.getNature() == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNature() == null) {
            throw new IllegalStateException();
        }
        return this.getNature().eClass().equals(pattern.getNature().eClass());
    }

    public final URL getImageURL() {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)this.getNature(), IItemLabelProvider.class);
        return (URL)itemLabelProvider.getImage((Object)this.getNature());
    }

    public String canTranslate(Pattern pattern) {
        if (pattern.getSuperPattern() != null && pattern.getSuperPattern().eIsProxy()) {
            return NLS.bind((String)EGFPatternMessages.Super_Pattern_Not_Found, (Object)pattern.getSuperPattern().toString());
        }
        IProject project = EMFHelper.getProject((Resource)pattern.eResource());
        if (project == null) {
            return NLS.bind((String)EGFCommonMessages.No_associated_project, (Object)EcoreUtil.getURI((EObject)pattern).trimFragment());
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(pattern.getHeaderMethod().getPatternFilePath().toPlatformString(true));
        if (resource == null) {
            return EGFPatternMessages.assembly_error5;
        }
        return null;
    }

    public String canExecute(Pattern pattern) {
        return null;
    }
}

