/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;

public class RuntimeParameterTypeHelper {
    public static final RuntimeParameterTypeHelper INSTANCE = new RuntimeParameterTypeHelper();

    public Object loadClass(String type) {
        if (type == null || type.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        int index = type.indexOf(35);
        if (index == -1) {
            try {
                return this.getClass().getClassLoader().loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.loadEClass(type);
    }

    private Object loadEClass(String type) {
        String instanceClassName = EMFHelper.getInstanceClassName((EPackage)this.getEPackage(type), (URI)URI.createURI((String)type));
        if (instanceClassName == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(instanceClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            throw new IllegalStateException(NLS.bind((String)EGFPatternMessages.classloader_error3, (Object)instanceClassName, (Object)type));
        }
        return clazz;
    }

    private EPackage getEPackage(String type) {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        EObject eObject = editingDomain.getResourceSet().getEObject(URI.createURI((String)type), true);
        if (eObject == null) {
            throw new IllegalStateException(NLS.bind((String)EGFPatternMessages.assembly_error7, (Object)type));
        }
        return EMFHelper.getEPackage((EObject)eObject);
    }

    private RuntimeParameterTypeHelper() {
    }
}

