/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.spreadsheet;

import com.google.gdata.client.Query;
import java.net.URL;

public class ListQuery
extends Query {
    public static final String SPREADSHEET_QUERY = "sq";
    public static final String ORDERBY = "orderby";
    public static final String ORDERBY_COLUMN = "column";
    public static final String ORDERBY_POSITION = "position";
    public static final String REVERSE = "reverse";

    public ListQuery(URL feedUrl) {
        super(feedUrl);
    }

    public void setSpreadsheetQuery(String query) {
        this.setStringCustomParameter(SPREADSHEET_QUERY, query);
    }

    public String getSpreadsheetQuery() {
        return this.getStringCustomParameter(SPREADSHEET_QUERY);
    }

    public void setFullTextQuery(String query) {
        super.setFullTextQuery(query);
    }

    public void setSortColumn(String column) {
        if (column == null || column.split("\\s").length > 1) {
            this.setOrderBy(null);
        } else {
            this.setOrderBy("column:" + column);
        }
    }

    public void setOrderBy(String orderby) {
        if (orderby == null || orderby.equals(ORDERBY_POSITION) || orderby.startsWith(ORDERBY_COLUMN) && orderby.split("\\s").length == 1) {
            this.setStringCustomParameter(ORDERBY, orderby);
        }
    }

    public String getOrderBy() {
        return this.getStringCustomParameter(ORDERBY);
    }

    public void setReverse(boolean reverse) {
        this.setStringCustomParameter(REVERSE, reverse ? "true" : null);
    }

    public boolean isReverse() {
        return this.getStringCustomParameter(REVERSE) != null;
    }
}

