/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.box;

import java.util.List;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class VBox
extends Box {
    private final List<Box> subBoxes = Lists.list();
    private final int indent;

    public VBox() {
        this(0);
    }

    public VBox(int indent) {
        this.indent = indent;
    }

    public VBox(Object ... items) {
        this(0);
        Assert.check((items.length > 0 ? 1 : 0) != 0);
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Assert.notNull((Object)item);
            if (item instanceof Box) {
                this.add((Box)item);
            } else {
                this.add(new TextBox(item.toString()));
            }
            ++n2;
        }
    }

    public void add() {
        this.add("", false);
    }

    public void add(Box box) {
        Assert.notNull((Object)box);
        this.add(box, false);
    }

    public void add(Box box, boolean addEmptyLine) {
        Assert.notNull((Object)box);
        if (addEmptyLine && !this.subBoxes.isEmpty()) {
            this.add("");
        }
        this.subBoxes.add(box);
    }

    public void add(String line) {
        Assert.notNull((Object)line);
        this.add(line, false);
    }

    public void add(String line, boolean addEmptyLine) {
        Assert.notNull((Object)line);
        if (addEmptyLine && !this.subBoxes.isEmpty()) {
            this.add("");
        }
        this.subBoxes.add(new TextBox(line));
    }

    public void add(List<String> lines) {
        Assert.notNull(lines);
        this.add(lines, false);
    }

    public void add(List<String> lines, boolean addEmptyLine) {
        Assert.notNull(lines);
        if (addEmptyLine && !this.subBoxes.isEmpty()) {
            this.add("");
        }
        for (String line : lines) {
            this.add(line);
        }
    }

    public void add(Object ... items) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Assert.notNull((Object)item);
            if (item instanceof Box) {
                this.add((Box)item);
            } else {
                this.add(new TextBox(item.toString()));
            }
            ++n2;
        }
    }

    @Override
    public List<String> getLines() {
        String prefix = Strings.spaces((int)this.indent);
        List rslt = Lists.list();
        for (Box b : this.subBoxes) {
            for (String line : b.getLines()) {
                rslt.add(prefix + line);
            }
        }
        return rslt;
    }
}

