/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTuple;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.ExplorationTerminatedException;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.FunctionState;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExpressionEval {
    private Map<Constant, Object> constValues = Maps.map();

    public Object eval(Expression expr, BaseState state, Object commVal) throws CifEvalException {
        if (expr instanceof CastExpression) {
            return this.evalCast((CastExpression)expr, state, commVal);
        }
        if (expr instanceof TimeExpression) {
            return 0.0;
        }
        if (expr instanceof StringExpression) {
            StringExpression e = (StringExpression)expr;
            return e.getValue();
        }
        if (expr instanceof RealExpression) {
            RealExpression e = (RealExpression)expr;
            try {
                return CifMath.strToReal((String)e.getValue(), null);
            }
            catch (CifEvalException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (expr instanceof IntExpression) {
            IntExpression e = (IntExpression)expr;
            return e.getValue();
        }
        if (expr instanceof BoolExpression) {
            BoolExpression e = (BoolExpression)expr;
            return e.isValue();
        }
        if (expr instanceof UnaryExpression) {
            return this.evalUnary((UnaryExpression)expr, state, commVal);
        }
        if (expr instanceof BinaryExpression) {
            return this.evalBinary((BinaryExpression)expr, state, commVal);
        }
        if (expr instanceof IfExpression) {
            IfExpression e = (IfExpression)expr;
            if (this.evalGuards((List<Expression>)e.getGuards(), state, commVal)) {
                return this.eval(e.getThen(), state, commVal);
            }
            for (ElifExpression ie : e.getElifs()) {
                if (!this.evalGuards((List<Expression>)ie.getGuards(), state, commVal)) continue;
                return this.eval(ie.getThen(), state, commVal);
            }
            return this.eval(e.getElse(), state, commVal);
        }
        if (expr instanceof SliceExpression) {
            return this.evalSlice((SliceExpression)expr, state, commVal);
        }
        if (expr instanceof FunctionCallExpression) {
            return this.evalFuncCall((FunctionCallExpression)expr, state, commVal);
        }
        if (expr instanceof ListExpression) {
            ListExpression e = (ListExpression)expr;
            List x = Lists.listc((int)e.getElements().size());
            for (Expression f : e.getElements()) {
                x.add(this.eval(f, state, commVal));
            }
            return x;
        }
        if (expr instanceof SetExpression) {
            SetExpression e = (SetExpression)expr;
            Set x = Sets.setc((int)e.getElements().size());
            for (Expression f : e.getElements()) {
                x.add(this.eval(f, state, commVal));
            }
            return x;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression e = (TupleExpression)expr;
            CifTuple x = new CifTuple(e.getFields().size());
            for (Expression f : e.getFields()) {
                x.add(this.eval(f, state, commVal));
            }
            return x;
        }
        if (expr instanceof DictExpression) {
            DictExpression e = (DictExpression)expr;
            Map x = Maps.mapc((int)e.getPairs().size());
            int dupCount = 0;
            for (DictPair p : e.getPairs()) {
                Object v;
                Object k = this.eval(p.getKey(), state, commVal);
                if (x.put(k, v = this.eval(p.getValue(), state, commVal)) == null) continue;
                ++dupCount;
            }
            if (dupCount != 0) {
                String msg = Strings.fmt((String)"Dictionary literal has %d duplicate key%s.", (Object[])new Object[]{dupCount, dupCount > 1 ? "s" : ""});
                throw new CifEvalException(msg, expr);
            }
            return x;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression e = (AlgVariableExpression)expr;
            expr = state.getAlgExpression(e.getVariable());
            return this.eval(expr, state, commVal);
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression e = (DiscVariableExpression)expr;
            return state.getVarValue((PositionObject)e.getVariable());
        }
        if (expr instanceof ConstantExpression) {
            ConstantExpression e = (ConstantExpression)expr;
            Object val = this.constValues.get(e.getConstant());
            if (val == null) {
                val = this.eval(e.getConstant().getValue(), state, commVal);
                this.constValues.put(e.getConstant(), val);
            }
            return val;
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression e = (ContVariableExpression)expr;
            Assert.check((!e.isDerivative() ? 1 : 0) != 0);
            return state.getVarValue((PositionObject)e.getVariable());
        }
        if (expr instanceof LocationExpression) {
            LocationExpression e = (LocationExpression)expr;
            int autIndex = state.explorer.indices.get(e.getLocation());
            if (state.getCurrentLocation(autIndex) == e.getLocation()) {
                return true;
            }
            return false;
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteralExpression e = (EnumLiteralExpression)expr;
            return new CifEnumLiteral(e.getLiteral());
        }
        if (expr instanceof ReceivedExpression) {
            return commVal;
        }
        if (expr instanceof ProjectionExpression) {
            return this.evalProjection((ProjectionExpression)expr, state, commVal);
        }
        if (expr instanceof SwitchExpression) {
            return this.evalSwitch((SwitchExpression)expr, state, commVal);
        }
        if (expr instanceof FunctionExpression) {
            return ((FunctionExpression)expr).getFunction();
        }
        String msg = Strings.fmt((String)"Unexpected expression to evaluate: %s", (Object[])new Object[]{expr});
        throw new RuntimeException(msg);
    }

    private boolean evalGuards(List<Expression> es, BaseState state, Object commVal) throws CifEvalException {
        for (Expression e : es) {
            boolean b = (Boolean)this.eval(e, state, commVal);
            if (b) continue;
            return false;
        }
        return true;
    }

    private Object evalSlice(SliceExpression expr, BaseState state, Object commVal) throws CifEvalException {
        Object result;
        Integer begin = null;
        if (expr.getBegin() != null) {
            begin = (Integer)this.eval(expr.getBegin(), state, commVal);
        }
        Integer end = null;
        if (expr.getEnd() != null) {
            end = (Integer)this.eval(expr.getEnd(), state, commVal);
        }
        if ((result = this.eval(expr.getChild(), state, commVal)) instanceof List) {
            return CifMath.slice((List)((List)result), (Integer)begin, (Integer)end);
        }
        return CifMath.slice((String)((String)result), (Integer)begin, (Integer)end);
    }

    private Object evalFuncCall(FunctionCallExpression expr, BaseState state, Object commVal) throws CifEvalException {
        Object[] args = new Object[expr.getArguments().size()];
        int i = 0;
        while (i < expr.getArguments().size()) {
            args[i] = this.eval((Expression)expr.getArguments().get(i), state, commVal);
            ++i;
        }
        Expression funcExpr = expr.getFunction();
        if (funcExpr instanceof StdLibFunctionExpression) {
            return this.evalStdLibFunc(expr, args);
        }
        Object funcObj = this.eval(funcExpr, state, commVal);
        InternalFunction func = (InternalFunction)funcObj;
        return this.evalInternalFunc(state.explorer, expr, func, args);
    }

    private Object evalStdLibFunc(FunctionCallExpression expr, Object[] args) throws CifEvalException {
        StdLibFunctionExpression stdlibExpr = (StdLibFunctionExpression)expr.getFunction();
        StdLibFunction func = stdlibExpr.getFunction();
        switch (func) {
            case ACOSH: {
                return CifMath.acosh((double)((Double)args[0]), (Expression)expr);
            }
            case ACOS: {
                return CifMath.acos((double)((Double)args[0]), (Expression)expr);
            }
            case ASINH: {
                return CifMath.asinh((double)((Double)args[0]), (Expression)expr);
            }
            case ASIN: {
                return CifMath.asin((double)((Double)args[0]), (Expression)expr);
            }
            case ATANH: {
                return CifMath.atanh((double)((Double)args[0]), (Expression)expr);
            }
            case ATAN: {
                return CifMath.atan((double)((Double)args[0]), (Expression)expr);
            }
            case COSH: {
                return CifMath.cosh((double)((Double)args[0]), (Expression)expr);
            }
            case COS: {
                return CifMath.cos((double)((Double)args[0]), (Expression)expr);
            }
            case SINH: {
                return CifMath.sinh((double)((Double)args[0]), (Expression)expr);
            }
            case SIN: {
                return CifMath.sin((double)((Double)args[0]), (Expression)expr);
            }
            case TANH: {
                return CifMath.tanh((double)((Double)args[0]), (Expression)expr);
            }
            case TAN: {
                return CifMath.tan((double)((Double)args[0]), (Expression)expr);
            }
            case ABS: {
                if (args[0] instanceof Integer) {
                    return CifMath.abs((int)((Integer)args[0]), (Expression)expr);
                }
                return CifMath.abs((double)((Double)args[0]));
            }
            case CBRT: {
                return CifMath.cbrt((double)((Double)args[0]));
            }
            case CEIL: {
                return CifMath.ceil((double)((Double)args[0]), (Expression)expr);
            }
            case DELETE: {
                return CifMath.delete((List)((List)args[0]), (int)((Integer)args[1]), (Expression)expr);
            }
            case EMPTY: {
                if (args[0] instanceof List) {
                    return ((List)args[0]).isEmpty();
                }
                if (args[0] instanceof Set) {
                    return ((Set)args[0]).isEmpty();
                }
                return ((Map)args[0]).isEmpty();
            }
            case EXP: {
                return CifMath.exp((double)((Double)args[0]), (Expression)expr);
            }
            case FLOOR: {
                return CifMath.floor((double)((Double)args[0]), (Expression)expr);
            }
            case FORMAT: {
                Object[] valueArgs = new Object[args.length - 1];
                System.arraycopy(args, 1, valueArgs, 0, valueArgs.length);
                return CifMath.fmt((String)((String)args[0]), (Object[])valueArgs);
            }
            case LN: {
                return CifMath.ln((double)((Double)args[0]), (Expression)expr);
            }
            case LOG: {
                return CifMath.log((double)((Double)args[0]), (Expression)expr);
            }
            case MAXIMUM: {
                if (args[0] instanceof Integer && args[1] instanceof Integer) {
                    return CifMath.max((int)((Integer)args[0]), (int)((Integer)args[1]));
                }
                double p0 = args[0] instanceof Integer ? (double)((Integer)args[0]).intValue() : (Double)args[0];
                double p1 = args[1] instanceof Integer ? (double)((Integer)args[1]).intValue() : (Double)args[1];
                return CifMath.max((double)p0, (double)p1);
            }
            case MINIMUM: {
                if (args[0] instanceof Integer && args[1] instanceof Integer) {
                    return CifMath.min((int)((Integer)args[0]), (int)((Integer)args[1]));
                }
                double p0 = args[0] instanceof Integer ? (double)((Integer)args[0]).intValue() : (Double)args[0];
                double p1 = args[1] instanceof Integer ? (double)((Integer)args[1]).intValue() : (Double)args[1];
                return CifMath.min((double)p0, (double)p1);
            }
            case POP: {
                return CifMath.pop((List)((List)args[0]), (Expression)expr);
            }
            case POWER: {
                int ps1;
                if (args[0] instanceof Integer && args[1] instanceof Integer && (ps1 = ((Integer)args[1]).intValue()) >= 0) {
                    return CifMath.pow((int)((Integer)args[0]), (int)ps1, (Expression)expr);
                }
                double p0 = args[0] instanceof Integer ? (double)((Integer)args[0]).intValue() : (Double)args[0];
                double p1 = args[1] instanceof Integer ? (double)((Integer)args[1]).intValue() : (Double)args[1];
                return CifMath.pow((double)p0, (double)p1, (Expression)expr);
            }
            case ROUND: {
                return CifMath.round((double)((Double)args[0]), (Expression)expr);
            }
            case SCALE: {
                double[] ds = new double[args.length];
                int i = 0;
                while (i < args.length) {
                    ds[i] = args[i] instanceof Integer ? (double)((Integer)args[i]).intValue() : (Double)args[i];
                    ++i;
                }
                return CifMath.scale((double)ds[0], (double)ds[1], (double)ds[2], (double)ds[3], (double)ds[4], (Expression)expr);
            }
            case SIGN: {
                if (args[0] instanceof Integer) {
                    return CifMath.sign((int)((Integer)args[0]));
                }
                return CifMath.sign((double)((Double)args[0]));
            }
            case SIZE: {
                if (args[0] instanceof String) {
                    return ((String)args[0]).length();
                }
                if (args[0] instanceof List) {
                    return ((List)args[0]).size();
                }
                if (args[0] instanceof Set) {
                    return ((Set)args[0]).size();
                }
                return ((Map)args[0]).size();
            }
            case SQRT: {
                return CifMath.sqrt((double)((Double)args[0]), (Expression)expr);
            }
            case BERNOULLI: 
            case BETA: 
            case BINOMIAL: 
            case CONSTANT: 
            case ERLANG: 
            case EXPONENTIAL: 
            case GAMMA: 
            case GEOMETRIC: 
            case LOG_NORMAL: 
            case NORMAL: 
            case POISSON: 
            case RANDOM: 
            case TRIANGLE: 
            case UNIFORM: 
            case WEIBULL: {
                throw new RuntimeException("Shouldn't occur.");
            }
        }
        String msg = "Unknown stdlib func: " + String.valueOf(expr.getFunction());
        throw new RuntimeException(msg);
    }

    private Object evalInternalFunc(Explorer explorer, FunctionCallExpression expr, InternalFunction func, Object[] args) throws CifEvalException {
        Object[] vs = new Object[func.getVariables().size()];
        FunctionState state = new FunctionState(explorer, func, args, vs);
        Object rslt = this.execFuncStatements((List<FunctionStatement>)func.getStatements(), state);
        Assert.notNull((Object)rslt);
        return rslt;
    }

    private Object execFuncStatements(List<FunctionStatement> statements, FunctionState state) throws CifEvalException {
        for (FunctionStatement statement : statements) {
            Object rslt = this.evalFuncStatement(statement, state);
            if (rslt == null) continue;
            return rslt;
        }
        return null;
    }

    private Object evalFuncStatement(FunctionStatement statement, FunctionState state) throws CifEvalException {
        if (statement instanceof AssignmentFuncStatement) {
            Object rhs;
            AssignmentFuncStatement asgn = (AssignmentFuncStatement)statement;
            try {
                rhs = this.eval(asgn.getValue(), state, null);
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute value to assign for assignment \"%s := %s\" for function valuation \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)asgn.getAddressable()), CifTextUtils.exprToStr((Expression)asgn.getValue()), state.toString()});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
            state.explorer.checkTypeRangeBoundaries(asgn.getAddressable().getType(), asgn.getValue().getType(), true, rhs, asgn.getAddressable(), asgn.getValue(), state);
            FunctionState origState = new FunctionState(state);
            state.explorer.assignValue(rhs, asgn.getAddressable(), null, origState, state);
            return null;
        }
        if (statement instanceof BreakFuncStatement) {
            throw new BreakException();
        }
        if (statement instanceof ContinueFuncStatement) {
            throw new ContinueException();
        }
        if (statement instanceof IfFuncStatement) {
            IfFuncStatement istat = (IfFuncStatement)statement;
            boolean condition = this.evalGuards((List<Expression>)istat.getGuards(), state, null);
            if (condition) {
                EList body = istat.getThens();
                return this.execFuncStatements((List<FunctionStatement>)body, state);
            }
            for (ElifFuncStatement elif : istat.getElifs()) {
                condition = this.evalGuards((List<Expression>)elif.getGuards(), state, null);
                if (!condition) continue;
                EList body = elif.getThens();
                return this.execFuncStatements((List<FunctionStatement>)body, state);
            }
            return this.execFuncStatements((List<FunctionStatement>)istat.getElses(), state);
        }
        if (statement instanceof ReturnFuncStatement) {
            EList es = ((ReturnFuncStatement)statement).getValues();
            List os = Lists.listc((int)es.size());
            for (Expression e : es) {
                os.add(this.eval(e, state, null));
            }
            if (os.size() == 1) {
                return os.get(0);
            }
            CifTuple tuple = new CifTuple(os.size());
            tuple.addAll((Collection)os);
            return tuple;
        }
        if (statement instanceof WhileFuncStatement) {
            boolean condition;
            WhileFuncStatement wstat = (WhileFuncStatement)statement;
            while (condition = this.evalGuards((List<Expression>)wstat.getGuards(), state, null)) {
                if (AppEnv.isTerminationRequested()) {
                    throw new ExplorationTerminatedException();
                }
                try {
                    EList body = wstat.getStatements();
                    Object rslt = this.execFuncStatements((List<FunctionStatement>)body, state);
                    if (rslt == null) continue;
                    return rslt;
                }
                catch (BreakException ex) {
                    break;
                }
                catch (ContinueException continueException) {
                }
            }
            return null;
        }
        throw new RuntimeException("Unknown statement: " + String.valueOf(statement));
    }

    private Object evalCast(CastExpression expr, BaseState state, Object commVal) throws CifEvalException {
        Expression child = expr.getChild();
        if (CifTypeUtils.isAutRefExpr((Expression)child)) {
            CifType ctype = child.getType();
            CifType nctype = CifTypeUtils.normalizeType((CifType)ctype);
            Assert.check((boolean)(nctype instanceof ComponentType));
            Component comp = ((ComponentType)nctype).getComponent();
            Automaton aut = CifScopeUtils.getAutomaton((Component)comp);
            int autIdx = state.explorer.indices.get(aut);
            Location loc = state.getCurrentLocation(autIdx);
            return CifLocationUtils.getName((Location)loc);
        }
        Object crslt = this.eval(expr.getChild(), state, commVal);
        CifType ctype = expr.getChild().getType();
        CifType nctype = CifTypeUtils.normalizeType((CifType)ctype);
        CifType ntype = CifTypeUtils.normalizeType((CifType)expr.getType());
        if (nctype instanceof IntType && ntype instanceof RealType) {
            int value = (Integer)crslt;
            return CifMath.intToReal((int)value);
        }
        if (nctype instanceof IntType && ntype instanceof StringType) {
            int value = (Integer)crslt;
            return CifMath.intToStr((int)value);
        }
        if (nctype instanceof RealType && ntype instanceof StringType) {
            double value = (Double)crslt;
            return CifMath.realToStr((double)value);
        }
        if (nctype instanceof BoolType && ntype instanceof StringType) {
            boolean value = (Boolean)crslt;
            return CifMath.boolToStr((boolean)value);
        }
        if (nctype instanceof StringType && ntype instanceof IntType) {
            String value = (String)crslt;
            return CifMath.strToInt((String)value, (Expression)expr);
        }
        if (nctype instanceof StringType && ntype instanceof RealType) {
            String value = (String)crslt;
            return CifMath.strToReal((String)value, (Expression)expr);
        }
        if (nctype instanceof StringType && ntype instanceof BoolType) {
            String value = (String)crslt;
            return CifMath.strToBool((String)value, (Expression)expr);
        }
        if (CifTypeUtils.checkTypeCompat((CifType)nctype, (CifType)ntype, (RangeCompat)RangeCompat.EQUAL)) {
            return crslt;
        }
        String msg = "Unknown cast: " + String.valueOf(nctype) + " to " + String.valueOf(ntype);
        throw new RuntimeException(msg);
    }

    private Object evalUnary(UnaryExpression expr, BaseState state, Object commVal) throws CifEvalException {
        Object result = this.eval(expr.getChild(), state, commVal);
        switch (expr.getOperator()) {
            case INVERSE: {
                return (Boolean)result == false;
            }
            case NEGATE: {
                if (result instanceof Integer) {
                    return CifMath.negate((int)((Integer)result), (Expression)expr);
                }
                return CifMath.negate((double)((Double)result));
            }
            case PLUS: {
                return result;
            }
        }
        String msg = Strings.fmt((String)"Unexpected type of unary operator %s", (Object[])new Object[]{expr.getOperator()});
        throw new RuntimeException(msg);
    }

    private Object evalBinary(BinaryExpression expr, BaseState state, Object commVal) throws CifEvalException {
        Object l = this.eval(expr.getLeft(), state, commVal);
        switch (expr.getOperator()) {
            case IMPLICATION: {
                if (!((Boolean)l).booleanValue()) {
                    return true;
                }
                return this.eval(expr.getRight(), state, commVal);
            }
            case DISJUNCTION: {
                if (!(l instanceof Boolean)) break;
                if (((Boolean)l).booleanValue()) {
                    return true;
                }
                return this.eval(expr.getRight(), state, commVal);
            }
            case CONJUNCTION: {
                if (!(l instanceof Boolean)) break;
                if (!((Boolean)l).booleanValue()) {
                    return false;
                }
                return this.eval(expr.getRight(), state, commVal);
            }
        }
        Object r = this.eval(expr.getRight(), state, commVal);
        switch (expr.getOperator()) {
            case ADDITION: {
                if (l instanceof Integer && r instanceof Integer) {
                    return CifMath.add((int)((Integer)l), (int)((Integer)r), (Expression)expr);
                }
                if (l instanceof List && r instanceof List) {
                    List llst = (List)l;
                    List rlst = (List)r;
                    List rslt = Lists.listc((int)(llst.size() + rlst.size()));
                    rslt.addAll(llst);
                    rslt.addAll(rlst);
                    return rslt;
                }
                if (l instanceof String && r instanceof String) {
                    return (String)l + (String)r;
                }
                if (l instanceof Map && r instanceof Map) {
                    Map lmap = (Map)l;
                    Map rmap = (Map)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    rslt.putAll(rmap);
                    return rslt;
                }
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.add((double)ld, (double)rd, (Expression)expr);
            }
            case BI_CONDITIONAL: {
                return ((Boolean)l).equals(r);
            }
            case CONJUNCTION: {
                Set lset = (Set)l;
                Set rset = (Set)r;
                Set rslt = Sets.copy((Set)lset);
                rslt.retainAll(rset);
                return rslt;
            }
            case DISJUNCTION: {
                Set lset = (Set)l;
                Set rset = (Set)r;
                Set rslt = Sets.copy((Set)lset);
                rslt.addAll(rset);
                return rslt;
            }
            case DIVISION: {
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.divide((double)ld, (double)rd, (Expression)expr);
            }
            case ELEMENT_OF: {
                if (r instanceof List) {
                    List list = (List)r;
                    return list.contains(l);
                }
                if (r instanceof Set) {
                    Set set = (Set)r;
                    return set.contains(l);
                }
                Map dict = (Map)r;
                return dict.containsKey(l);
            }
            case EQUAL: {
                return l.equals(r);
            }
            case GREATER_EQUAL: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld >= rd) {
                    return true;
                }
                return false;
            }
            case GREATER_THAN: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld > rd) {
                    return true;
                }
                return false;
            }
            case INTEGER_DIVISION: {
                return CifMath.div((int)((Integer)l), (int)((Integer)r), (Expression)expr);
            }
            case LESS_EQUAL: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld <= rd) {
                    return true;
                }
                return false;
            }
            case LESS_THAN: {
                double rd;
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double d = rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                if (ld < rd) {
                    return true;
                }
                return false;
            }
            case MODULUS: {
                return CifMath.mod((int)((Integer)l), (int)((Integer)r), (Expression)expr);
            }
            case MULTIPLICATION: {
                if (l instanceof Integer && r instanceof Integer) {
                    return CifMath.multiply((int)((Integer)l), (int)((Integer)r), (Expression)expr);
                }
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.multiply((double)ld, (double)rd, (Expression)expr);
            }
            case SUBSET: {
                Set lset = (Set)l;
                Set rset = (Set)r;
                return rset.containsAll(lset);
            }
            case SUBTRACTION: {
                if (l instanceof Integer && r instanceof Integer) {
                    return CifMath.subtract((int)((Integer)l), (int)((Integer)r), (Expression)expr);
                }
                if (l instanceof Set && r instanceof Set) {
                    Set lset = (Set)l;
                    Set rset = (Set)r;
                    Set rslt = Sets.copy((Set)lset);
                    rslt.removeAll(rset);
                    return rslt;
                }
                if (l instanceof Map && r instanceof Map) {
                    Map lmap = (Map)l;
                    Map rmap = (Map)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    for (Object key : rmap.keySet()) {
                        rslt.remove(key);
                    }
                    return rslt;
                }
                if (l instanceof Map && r instanceof List) {
                    Map lmap = (Map)l;
                    List rlst = (List)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    for (Object key : rlst) {
                        rslt.remove(key);
                    }
                    return rslt;
                }
                if (l instanceof Map && r instanceof Set) {
                    Map lmap = (Map)l;
                    Set rset = (Set)r;
                    LinkedHashMap rslt = Maps.copy((Map)lmap);
                    for (Object key : rset) {
                        rslt.remove(key);
                    }
                    return rslt;
                }
                double ld = l instanceof Integer ? (double)((Integer)l).intValue() : (Double)l;
                double rd = r instanceof Integer ? (double)((Integer)r).intValue() : (Double)r;
                return CifMath.subtract((double)ld, (double)rd, (Expression)expr);
            }
            case UNEQUAL: {
                return !l.equals(r);
            }
        }
        String msg = "Unknown binary op: " + String.valueOf(expr.getOperator());
        throw new RuntimeException(msg);
    }

    private Object evalProjection(ProjectionExpression expr, BaseState state, Object commVal) throws CifEvalException {
        Object child = this.eval(expr.getChild(), state, commVal);
        if (child instanceof CifTuple) {
            CifTuple tuple = (CifTuple)child;
            if (expr.getIndex() instanceof FieldExpression) {
                Field field = ((FieldExpression)expr.getIndex()).getField();
                TupleType ttype = (TupleType)field.eContainer();
                int idx = ttype.getFields().indexOf((Object)field);
                Assert.check((idx < tuple.size() ? 1 : 0) != 0);
                return tuple.get(idx);
            }
            int idx = (Integer)this.eval(expr.getIndex(), state, commVal);
            return tuple.get(idx);
        }
        Object idxVal = this.eval(expr.getIndex(), state, commVal);
        if (child instanceof List) {
            return CifMath.project((List)((List)child), (int)((Integer)idxVal), (Expression)expr);
        }
        if (child instanceof Map) {
            return CifMath.project((Map)((Map)child), (Object)idxVal, (Expression)expr);
        }
        if (child instanceof String) {
            return CifMath.project((String)((String)child), (int)((Integer)idxVal), (Expression)expr);
        }
        if (child instanceof CifTuple) {
            return CifMath.project((CifTuple)((CifTuple)child), (int)((Integer)idxVal), (Expression)expr);
        }
        String msg = Strings.fmt((String)"Unknown projection child: %s", (Object[])new Object[]{expr});
        throw new RuntimeException(msg);
    }

    private Object evalSwitch(SwitchExpression expr, BaseState state, Object commVal) throws CifEvalException {
        if (expr.getValue().getType() instanceof ComponentType) {
            ComponentType ct = (ComponentType)expr.getValue().getType();
            int autIndex = state.explorer.indices.get(ct.getComponent());
            Location curLoc = state.getCurrentLocation(autIndex);
            for (SwitchCase sc : expr.getCases()) {
                LocationExpression key;
                if (sc.getKey() != null && (key = (LocationExpression)sc.getKey()).getLocation() != curLoc) continue;
                return this.eval(sc.getValue(), state, commVal);
            }
            throw new RuntimeException("Unhandled location in switch.");
        }
        Object value = this.eval(expr.getValue(), state, commVal);
        for (SwitchCase sc : expr.getCases()) {
            Object keyValue;
            if (sc.getKey() != null && !value.equals(keyValue = this.eval(sc.getKey(), state, commVal))) continue;
            return this.eval(sc.getValue(), state, commVal);
        }
        throw new RuntimeException("Unhandled value in switch.");
    }

    private static class BreakException
    extends RuntimeException {
        private BreakException() {
        }
    }

    private static class ContinueException
    extends RuntimeException {
        private ContinueException() {
        }
    }
}

