/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import java.math.BigInteger;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.BddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.spec.CifBddDomain;
import org.eclipse.escet.common.java.Assert;

public class UnsignedBddBitVector
extends BddBitVector<UnsignedBddBitVector, UnsignedBddBitVectorAndCarry> {
    public static final int MINIMUM_LENGTH = 1;

    private UnsignedBddBitVector(BDDFactory factory, int length) {
        super(factory, length);
    }

    @Override
    protected int getMinimumLength() {
        return 1;
    }

    public static int getMinimumLength(int value) {
        Assert.check((value >= 0 ? 1 : 0) != 0);
        int count = 0;
        while (value > 0) {
            ++count;
            value >>= 1;
        }
        return Math.max(1, count);
    }

    @Override
    protected UnsignedBddBitVector createEmpty(int length) {
        return new UnsignedBddBitVector(this.factory, length);
    }

    public static UnsignedBddBitVector create(BDDFactory factory, int length) {
        return UnsignedBddBitVector.create(factory, length, false);
    }

    public static UnsignedBddBitVector create(BDDFactory factory, int length, boolean value) {
        UnsignedBddBitVector vector = new UnsignedBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = value ? factory.one() : factory.zero();
            ++i;
        }
        return vector;
    }

    public static UnsignedBddBitVector createFromInt(BDDFactory factory, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        int length = UnsignedBddBitVector.getMinimumLength(value);
        return UnsignedBddBitVector.createFromInt(factory, length, value);
    }

    public static UnsignedBddBitVector createFromInt(BDDFactory factory, int length, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        if (length < UnsignedBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        UnsignedBddBitVector vector = new UnsignedBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = (value & 1) != 0 ? factory.one() : factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.areEqual((Object)value, (Object)0);
        return vector;
    }

    public static UnsignedBddBitVector createFromDomain(CifBddDomain domain) {
        int varCnt = domain.getVarCount();
        UnsignedBddBitVector vector = new UnsignedBddBitVector(domain.getFactory(), varCnt);
        int[] vars = domain.getVarIndices();
        int i = 0;
        while (i < vars.length) {
            vector.bits[i] = vector.factory.ithVar(vars[i]);
            ++i;
        }
        return vector;
    }

    @Override
    public BigInteger getLower() {
        return BigInteger.ZERO;
    }

    @Override
    public int getLowerInt() {
        return 0;
    }

    @Override
    public BigInteger getUpper() {
        return BigInteger.TWO.pow(this.bits.length).subtract(BigInteger.ONE);
    }

    @Override
    public int getUpperInt() {
        return this.getUpper().intValueExact();
    }

    @Override
    public Integer getInt() {
        if (this.bits.length > 31) {
            throw new IllegalStateException("More than 31 bits in vector.");
        }
        Long value = this.getLong();
        return value == null ? null : Integer.valueOf((int)value.longValue());
    }

    @Override
    public Long getLong() {
        if (this.bits.length > 63) {
            throw new IllegalStateException("More than 63 bits in vector.");
        }
        long value = 0L;
        int bitIndex = this.bits.length - 1;
        while (bitIndex >= 0) {
            if (this.bits[bitIndex].isOne()) {
                value = value << 1 | 1L;
            } else if (this.bits[bitIndex].isZero()) {
                value <<= 1;
            } else {
                return null;
            }
            --bitIndex;
        }
        return value;
    }

    @Override
    public void setInt(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        if (this.bits.length < UnsignedBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = (value & 1) != 0 ? this.factory.one() : this.factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.areEqual((Object)value, (Object)0);
    }

    @Override
    public void resize(int length) {
        if (length == this.bits.length) {
            return;
        }
        if (length < 1) {
            throw new IllegalArgumentException("Length is less than one.");
        }
        BDD[] newBits = new BDD[length];
        int numberOfCommonBits = Math.min(this.bits.length, length);
        System.arraycopy(this.bits, 0, newBits, 0, numberOfCommonBits);
        int i = numberOfCommonBits;
        while (i < length) {
            newBits[i] = this.factory.zero();
            ++i;
        }
        i = numberOfCommonBits;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.bits = newBits;
    }

    @Override
    public UnsignedBddBitVector shrink() {
        int length = this.bits.length;
        while (length > 1 && this.bits[length - 1].isZero()) {
            --length;
        }
        this.resize(length);
        return this;
    }

    @Override
    public UnsignedBddBitVectorAndCarry negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedBddBitVectorAndCarry abs() {
        return new UnsignedBddBitVectorAndCarry((UnsignedBddBitVector)this.copy(), this.factory.zero());
    }

    @Override
    public UnsignedBddBitVectorAndCarry add(UnsignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        UnsignedBddBitVector rslt = new UnsignedBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            carry = this.bits[i].and(other.bits[i]).orWith(carry.andWith(this.bits[i].or(other.bits[i])));
            ++i;
        }
        return new UnsignedBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public UnsignedBddBitVector sign() {
        BDD isZero = this.factory.one();
        BDD[] bDDArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            BDD bit = bDDArray[n2];
            isZero = isZero.andWith(bit.not());
            ++n2;
        }
        UnsignedBddBitVector zero = UnsignedBddBitVector.createFromInt(this.factory, 1, 0);
        UnsignedBddBitVector one = UnsignedBddBitVector.createFromInt(this.factory, 1, 1);
        UnsignedBddBitVector result = UnsignedBddBitVector.ifThenElse(isZero, zero, one);
        isZero.free();
        zero.free();
        one.free();
        return result;
    }

    @Override
    public UnsignedBddBitVectorAndCarry subtract(UnsignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        UnsignedBddBitVector rslt = new UnsignedBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            BDD tmp1 = other.bits[i].or(carry);
            BDD tmp2 = this.bits[i].apply(tmp1, BDDFactory.less);
            tmp1.free();
            carry = this.bits[i].and(other.bits[i]).andWith(carry).orWith(tmp2);
            ++i;
        }
        return new UnsignedBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public UnsignedBddBitVectorAndCarry multiply(UnsignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        int length = this.bits.length;
        int doubleLength = length * 2;
        UnsignedBddBitVector left = (UnsignedBddBitVector)this.copy();
        UnsignedBddBitVector right = (UnsignedBddBitVector)other.copy();
        left.resize(doubleLength);
        right.resize(doubleLength);
        UnsignedBddBitVector result = UnsignedBddBitVector.create(this.factory, doubleLength, false);
        int i = 0;
        while (i < doubleLength) {
            UnsignedBddBitVectorAndCarry added = result.add(left);
            int j = 0;
            while (j < doubleLength) {
                BDD bit = result.bits[j];
                result.bits[j] = right.bits[i].ite(((UnsignedBddBitVector)added.vector).bits[j], bit);
                bit.free();
                ++j;
            }
            ((UnsignedBddBitVector)added.vector).free();
            added.carry.free();
            UnsignedBddBitVector oldLeft = left;
            left = (UnsignedBddBitVector)left.shiftLeft(1, this.factory.zero());
            oldLeft.free();
            ++i;
        }
        left.free();
        right.free();
        BDD overflow = this.factory.zero();
        int i2 = length;
        while (i2 < doubleLength) {
            overflow = overflow.orWith(result.bits[i2].id());
            ++i2;
        }
        result.resize(length);
        return new UnsignedBddBitVectorAndCarry(result, overflow);
    }

    @Override
    public UnsignedBddBitVector div(int divisor) {
        return this.divmod(divisor, true);
    }

    @Override
    public UnsignedBddBitVector mod(int divisor) {
        return this.divmod(divisor, false);
    }

    private UnsignedBddBitVector divmod(int divisorValue, boolean isDiv) {
        if (divisorValue <= 0) {
            throw new IllegalArgumentException("Divisor is not positive.");
        }
        if (this.bits.length < UnsignedBddBitVector.getMinimumLength(divisorValue)) {
            throw new IllegalArgumentException("Divisor doesn't fit.");
        }
        if (!isDiv && !this.bits[this.bits.length - 1].isZero()) {
            throw new IllegalStateException("Computing the remainder/'mod', and the highest bit of the dividend is not 'false'.");
        }
        UnsignedBddBitVector divisor = UnsignedBddBitVector.createFromInt(this.factory, this.bits.length, divisorValue);
        UnsignedBddBitVector quotient = (UnsignedBddBitVector)this.shiftLeft(1, this.factory.zero());
        UnsignedBddBitVector remainderZero = UnsignedBddBitVector.create(this.factory, this.bits.length);
        UnsignedBddBitVector remainder = (UnsignedBddBitVector)remainderZero.shiftLeft(1, this.bits[this.bits.length - 1]);
        remainderZero.free();
        this.divModRecursive(divisor, quotient, remainder, this.bits.length);
        divisor.free();
        if (isDiv) {
            remainder.free();
            return quotient;
        }
        quotient.free();
        UnsignedBddBitVector shiftedRemainder = (UnsignedBddBitVector)remainder.shiftRight(1, this.factory.zero());
        remainder.free();
        return shiftedRemainder;
    }

    private void divModRecursive(UnsignedBddBitVector divisor, UnsignedBddBitVector quotient, UnsignedBddBitVector remainder, int step) {
        int divLen = divisor.bits.length;
        BDD isSmaller = divisor.lessOrEqual(remainder);
        UnsignedBddBitVector newQuotient = (UnsignedBddBitVector)quotient.shiftLeft(1, isSmaller);
        UnsignedBddBitVector sub = UnsignedBddBitVector.create(this.factory, divLen);
        int i = 0;
        while (i < divLen) {
            sub.bits[i] = isSmaller.ite(divisor.bits[i], this.factory.zero());
            ++i;
        }
        UnsignedBddBitVectorAndCarry tmp = remainder.subtract(sub);
        UnsignedBddBitVector newRemainder = (UnsignedBddBitVector)((UnsignedBddBitVector)tmp.vector).shiftLeft(1, quotient.bits[divLen - 1]);
        if (step > 1) {
            this.divModRecursive(divisor, newQuotient, newRemainder, step - 1);
        }
        ((UnsignedBddBitVector)tmp.vector).free();
        tmp.carry.free();
        sub.free();
        isSmaller.free();
        quotient.replaceBy(newQuotient);
        remainder.replaceBy(newRemainder);
    }

    @Override
    public BDD lessThan(UnsignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD rslt = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            rslt = lt.orWith(eq.andWith(rslt));
            ++i;
        }
        return rslt;
    }

    @Override
    public BDD lessOrEqual(UnsignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD rslt = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            rslt = lt.orWith(eq.andWith(rslt));
            ++i;
        }
        return rslt;
    }

    @Override
    public UnsignedBddBitVector min(UnsignedBddBitVector other) {
        BDD cmp = this.lessOrEqual(other);
        UnsignedBddBitVector result = UnsignedBddBitVector.ifThenElse(cmp, this, other);
        cmp.free();
        return result;
    }

    @Override
    public UnsignedBddBitVector max(UnsignedBddBitVector other) {
        BDD cmp = this.greaterOrEqual(other);
        UnsignedBddBitVector result = UnsignedBddBitVector.ifThenElse(cmp, this, other);
        cmp.free();
        return result;
    }
}

