/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide.server;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.resource.impl.ProjectDescription;

public class DependencyAwareBuildManager
extends BuildManager {
    private WorkspaceManager workspaceManager;

    protected List<ProjectDescription> sortByDependencies(Iterable<ProjectDescription> projectDescriptions) {
        Set projectNames = StreamSupport.stream(projectDescriptions.spliterator(), false).map(ProjectDescription::getName).collect(Collectors.toSet());
        List downstream = this.workspaceManager.getProjectManagers().stream().map(ProjectManager::getProjectDescription).filter(description -> {
            if (projectNames.contains(description.getName())) return true;
            if (description.getDependencies().stream().anyMatch(projectNames::contains)) return true;
            return false;
        }).collect(Collectors.toList());
        return super.sortByDependencies(downstream);
    }

    public void setWorkspaceManager(WorkspaceManager workspaceManager) {
        super.setWorkspaceManager(workspaceManager);
        this.workspaceManager = workspaceManager;
    }
}

