/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide.server;

import com.google.inject.Inject;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.core.common.ide.modelpath.ModelPathManager;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.xtext.ide.server.MultiRootWorkspaceConfigFactory;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.UnknownProjectConfig;
import org.eclipse.xtext.workspace.WorkspaceConfig;

public class ModelWorkspaceConfigFactory
extends MultiRootWorkspaceConfigFactory {
    private static final Logger LOG = Logger.getLogger(ModelWorkspaceConfigFactory.class);
    @Inject
    private ModelPathManager modelPathManager;

    public IWorkspaceConfig getWorkspaceConfig(List<WorkspaceFolder> workspaceFolders) {
        WorkspaceConfig workspaceConfig = new WorkspaceConfig(new IProjectConfig[0]){

            public IProjectConfig findProjectContaining(URI member) {
                return this.getProjects().stream().filter(project -> project.getPath() != null && UriUtil.isPrefixOf((URI)project.getPath(), (URI)member)).max(Comparator.comparingInt(project -> project.getPath().segmentCount())).orElseGet(() -> new UnknownProjectConfig((IWorkspaceConfig)this));
            }
        };
        HashSet<String> existingNames = new HashSet<String>();
        for (WorkspaceFolder folder : workspaceFolders) {
            FileProjectConfig project = new FileProjectConfig(this.getUriExtensions().toUri(folder.getUri()), this.getUniqueProjectName(folder.getName(), existingNames), (IWorkspaceConfig)workspaceConfig);
            this.modelPathManager.getModelDirectories(folder.getUri()).forEach(arg_0 -> ((FileProjectConfig)project).addSourceFolder(arg_0));
            workspaceConfig.addProject((IProjectConfig)project);
        }
        return workspaceConfig;
    }

    protected String getUniqueProjectName(String proposal, Set<String> existingNames) {
        if (existingNames.contains(proposal)) {
            LOG.warn((Object)("Multiple workspace folders with name " + proposal));
        }
        return super.getUniqueProjectName(proposal, existingNames);
    }
}

