/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.eclipse.gemini.naming.NotSupportedContext;
import org.eclipse.gemini.naming.OSGiServiceListContext;
import org.eclipse.gemini.naming.OSGiURLParser;
import org.eclipse.gemini.naming.ReflectionUtils;
import org.eclipse.gemini.naming.ServiceProxyInfo;
import org.eclipse.gemini.naming.ServiceUtils;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class OSGiURLContextFactory
implements ObjectFactory {
    private static final String OSGI_BUNDLE_CONTEXT_LOOKUP = "osgi:framework/bundleContext";
    private static final Logger logger = Logger.getLogger(OSGiURLContextFactory.class.getName());
    private final BundleContext m_bundleContext;

    public OSGiURLContextFactory(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return new OSGiURLContext(this.m_bundleContext);
    }

    private static class OSGiURLContext
    extends NotSupportedContext {
        private final BundleContext m_bundleContext;

        public OSGiURLContext(BundleContext bundleContext) {
            super("This operation is not supported by the OSGi URL Context");
            this.m_bundleContext = bundleContext;
        }

        @Override
        public Object lookup(String name) throws NamingException {
            String osgiURL = name;
            try {
                if (osgiURL.equals(OSGiURLContextFactory.OSGI_BUNDLE_CONTEXT_LOOKUP)) {
                    AdminPermission adminPermission = new AdminPermission(this.m_bundleContext.getBundle(), "context");
                    try {
                        AccessController.checkPermission((Permission)adminPermission);
                        return this.m_bundleContext;
                    }
                    catch (AccessControlException accessControlException) {
                        NameNotFoundException namingException = new NameNotFoundException("BundleContext not available, caller does not have the correct permission.");
                        namingException.setRootCause(accessControlException);
                        throw namingException;
                    }
                }
                Object requestedService = this.obtainService(osgiURL);
                if (requestedService != null) {
                    return requestedService;
                }
            }
            catch (InvalidSyntaxException e) {
                NamingException namingException = new NamingException("Error occurred while parsing the OSGi URL");
                namingException.initCause(e);
                throw namingException;
            }
            throw new NameNotFoundException("The OSGi service referred to by the URL = " + osgiURL + " could not be located in the OSGi Service Registry");
        }

        private Object obtainService(String osgiURL) throws InvalidSyntaxException {
            OSGiURLParser urlParser = new OSGiURLParser(osgiURL);
            try {
                urlParser.parse();
            }
            catch (IllegalStateException stateException) {
                logger.log(Level.SEVERE, "An exception occurred while trying to parse this osgi URL", stateException);
                return null;
            }
            if (urlParser.getServiceInterface() == null) {
                return null;
            }
            return OSGiURLContext.getService(this.m_bundleContext, urlParser);
        }

        private static Object getService(BundleContext bundleContext, OSGiURLParser urlParser) throws InvalidSyntaxException {
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(urlParser.getServiceInterface(), urlParser.getFilter());
            if (serviceReferences != null) {
                ServiceReference[] sortedServiceReferences = ServiceUtils.sortServiceReferences(serviceReferences);
                if (urlParser.isServiceListURL()) {
                    return new OSGiServiceListContext(bundleContext, sortedServiceReferences, urlParser);
                }
                ServiceProxyInfo proxyInfo = ReflectionUtils.getProxyForSingleService(bundleContext, urlParser, sortedServiceReferences[0]);
                return proxyInfo.getService();
            }
            ServiceReference[] serviceReferencesByName = ServiceUtils.getServiceReferencesByServiceName(bundleContext, urlParser);
            if (serviceReferencesByName != null) {
                ServiceReference[] sortedServiceReferences = ServiceUtils.sortServiceReferences(serviceReferencesByName);
                ServiceProxyInfo proxyInfo = ReflectionUtils.getProxyForSingleService(bundleContext, urlParser, sortedServiceReferences[0]);
                return proxyInfo.getService();
            }
            return null;
        }
    }
}

