/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

abstract class ServiceBasedNamingEnumeration
implements NamingEnumeration {
    protected boolean m_isOpen = false;
    protected int m_index = -1;
    protected final BundleContext m_bundleContext;
    protected final String m_interfaceName;
    protected final ServiceReference[] m_serviceReferences;
    protected NameClassPair[] m_nameClassPairs;

    public ServiceBasedNamingEnumeration(BundleContext bundleContext, ServiceReference[] serviceReferences, String interfaceName) {
        this.m_bundleContext = bundleContext;
        this.m_interfaceName = interfaceName == null ? "" : interfaceName;
        this.m_serviceReferences = serviceReferences;
        if (this.m_serviceReferences.length > 0) {
            this.m_isOpen = true;
            this.m_index = 0;
        }
    }

    @Override
    public void close() throws NamingException {
        this.m_isOpen = false;
    }

    @Override
    public boolean hasMore() throws NamingException {
        this.checkIsOpen();
        return this.isIndexValid();
    }

    public Object next() throws NamingException {
        this.checkIsOpen();
        return this.internalNextElement();
    }

    @Override
    public boolean hasMoreElements() {
        if (!this.m_isOpen) {
            return false;
        }
        return this.isIndexValid();
    }

    @Override
    public Object nextElement() {
        return this.internalNextElement();
    }

    private void checkIsOpen() throws NamingException {
        if (!this.m_isOpen) {
            throw new NamingException("Operation cannot complete, since this NamingEnumeration has been closed");
        }
    }

    private boolean isIndexValid() {
        return this.m_index < this.m_nameClassPairs.length;
    }

    private Object internalNextElement() {
        if (this.isIndexValid()) {
            return this.internalNextClassPair();
        }
        throw new NoSuchElementException("No additional elements exist in this NamingEnumeration");
    }

    private NameClassPair internalNextClassPair() {
        return this.m_nameClassPairs[this.m_index++];
    }
}

