/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public final class ChainedClassLoader
extends ClassLoader
implements BundleReference {
    private final List<ClassLoader> loaders;
    private Bundle bundle;

    ChainedClassLoader(ClassLoader ... loaders) {
        ArrayList<ClassLoader> l = new ArrayList<ClassLoader>();
        int i = 0;
        while (i < loaders.length) {
            ClassLoader classLoader = loaders[i];
            if (!l.contains(classLoader)) {
                l.add(classLoader);
            }
            ++i;
        }
        this.loaders = Collections.unmodifiableList(l);
    }

    public static ChainedClassLoader create(final ClassLoader ... loaders) {
        return AccessController.doPrivileged(new PrivilegedAction<ChainedClassLoader>(){

            @Override
            public ChainedClassLoader run() {
                return new ChainedClassLoader(loaders);
            }
        });
    }

    @Override
    public URL getResource(final String name) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return ChainedClassLoader.this.doGetResource(name);
                }
            });
        }
        return this.doGetResource(name);
    }

    @Override
    public Enumeration<URL> getResources(final String name) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                    @Override
                    public Enumeration<URL> run() throws Exception {
                        return ChainedClassLoader.this.doGetResources(name);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception exception = e.getException();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IllegalStateException("Unexpected Exception from privileged action.", exception);
            }
        }
        return this.doGetResources(name);
    }

    private Enumeration<URL> doGetResources(String name) throws IOException {
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (ClassLoader loader : this.loaders) {
            Enumeration<URL> resources = loader.getResources(name);
            if (resources == null) continue;
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                urls.put(url.toExternalForm(), url);
            }
        }
        return Collections.enumeration(urls.values());
    }

    private URL doGetResource(String name) {
        URL url = null;
        int i = 0;
        while (i < this.loaders.size()) {
            ClassLoader loader = this.loaders.get(i);
            url = loader.getResource(name);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return url;
    }

    @Override
    public Class<?> loadClass(final String name) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws Exception {
                        return ChainedClassLoader.this.doLoadClass(name);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (ClassNotFoundException)pae.getException();
            }
        }
        return this.doLoadClass(name);
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        int i = 0;
        while (i < this.loaders.size()) {
            ClassLoader loader = this.loaders.get(i);
            try {
                clazz = loader.loadClass(name);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++i;
            }
        }
        throw new ClassNotFoundException(name);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }
}

