/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.parse.standard;

import java.util.List;
import org.eclipse.virgo.util.osgi.manifest.parse.BundleManifestParseException;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderProblem;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderProblemKind;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderToken;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderTokenKind;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderTokenStream;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderVisitor;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.MultiplexingVisitor;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.Severity;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.SourceContext;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.StandardHeaderLexer;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.StandardHeaderVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardHeaderParser
implements HeaderParser {
    private HeaderVisitor visitor = new StandardHeaderVisitor();
    private HeaderTokenStream tokenStream;
    private StandardHeaderLexer lexer;
    private final ParserLogger logger;
    private static final String STAR = "*";

    public StandardHeaderParser(ParserLogger logger) {
        this.logger = logger;
    }

    public StandardHeaderParser(HeaderVisitor visitor, ParserLogger logger) {
        this(logger);
        this.visitor = new MultiplexingVisitor(this.visitor, visitor);
    }

    @Override
    public HeaderDeclaration parseBundleSymbolicName(String header) {
        HeaderDeclaration declaration = this.internalParseBundleSymbolicName(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declaration;
    }

    @Override
    public List<HeaderDeclaration> parsePackageHeader(String header, String headerType) {
        List<HeaderDeclaration> declarations = this.internalParsePackageHeader(header, headerType);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declarations;
    }

    @Override
    public HeaderDeclaration parseBundleActivationPolicy(String header) {
        HeaderDeclaration declaration = this.internalParseBundleActivationPolicy(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declaration;
    }

    @Override
    public List<HeaderDeclaration> parseDynamicImportPackageHeader(String header) {
        List<HeaderDeclaration> declarations = this.internalParseDynamicImportPackageHeader(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declarations;
    }

    @Override
    public HeaderDeclaration parseFragmentHostHeader(String header) {
        HeaderDeclaration declaration = this.internalParseFragmentHostHeader(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declaration;
    }

    @Override
    public List<HeaderDeclaration> parseImportBundleHeader(String header) {
        List<HeaderDeclaration> declarations = this.internalParseImportBundleHeader(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declarations;
    }

    @Override
    public List<HeaderDeclaration> parseImportLibraryHeader(String header) {
        List<HeaderDeclaration> declarations = this.internalParseImportLibraryHeader(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declarations;
    }

    @Override
    public HeaderDeclaration parseLibrarySymbolicName(String header) {
        HeaderDeclaration declaration = this.internalParseLibrarySymbolicName(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declaration;
    }

    @Override
    public List<HeaderDeclaration> parseRequireBundleHeader(String header) {
        List<HeaderDeclaration> declarations = this.internalParseRequireBundleHeader(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declarations;
    }

    @Override
    public List<HeaderDeclaration> parseWebFilterMappingsHeader(String header) {
        List<HeaderDeclaration> declarations = this.internalParseWebFilterMappingsHeader(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declarations;
    }

    @Override
    public List<HeaderDeclaration> parseHeader(String header) {
        List<HeaderDeclaration> declarations = this.internalParseHeader(header);
        if (this.tokenStream.containsProblems(Severity.ERROR)) {
            throw new BundleManifestParseException(this.createErrorMessage());
        }
        return declarations;
    }

    public boolean foundProblems() {
        return this.tokenStream.containsProblems();
    }

    public boolean foundProblems(Severity severity) {
        return this.tokenStream.containsProblems(severity);
    }

    public List<HeaderProblem> getProblems() {
        return this.tokenStream.getProblems();
    }

    public SourceContext getSourceContext() {
        return this.tokenStream.getSourceContext();
    }

    private HeaderDeclaration internalParseBundleSymbolicName(String header) {
        return this.parseOneBundleDescription(header);
    }

    private HeaderDeclaration internalParseLibrarySymbolicName(String header) {
        return this.parseOneBundleDescription(header);
    }

    private HeaderDeclaration internalParseFragmentHostHeader(String header) {
        return this.parseOneBundleDescription(header);
    }

    public List<HeaderDeclaration> internalParseRequireBundleHeader(String header) {
        return this.parseMultipleBundleDescriptions(header);
    }

    public List<HeaderDeclaration> internalParseImportLibraryHeader(String header) {
        return this.parseMultipleBundleDescriptions(header);
    }

    public List<HeaderDeclaration> internalParseWebFilterMappingsHeader(String header) {
        return this.parseMultipleBundleDescriptions(header);
    }

    public List<HeaderDeclaration> internalParseImportBundleHeader(String header) {
        return this.parseMultipleBundleDescriptions(header);
    }

    public HeaderDeclaration internalParseBundleActivationPolicy(String header) {
        this.initializeTokenStream(header);
        this.eatActivationPolicy();
        this.checkNextIsSemiColon();
        while (this.maybeEatSemicolon()) {
            this.eatParameter(false);
        }
        this.visitor.clauseEnded();
        this.confirmEnd();
        return this.visitor.getHeaderDeclarations().get(0);
    }

    List<HeaderDeclaration> internalParsePackageHeader(String header, String headerType) {
        this.initializeTokenStream(header);
        this.parsePackageHeader();
        return this.visitor.getHeaderDeclarations();
    }

    private List<HeaderDeclaration> parseMultipleBundleDescriptions(String header) {
        this.initializeTokenStream(header);
        this.eatMultipleBundleDescriptions();
        return this.visitor.getHeaderDeclarations();
    }

    private HeaderDeclaration parseOneBundleDescription(String header) {
        this.initializeTokenStream(header);
        this.eatSingleBundleDescription();
        return this.visitor.getFirstHeaderDeclaration();
    }

    private void initializeTokenStream(String header) {
        this.visitor.initialize();
        this.lexer = new StandardHeaderLexer();
        this.lexer.process(header);
        this.tokenStream = this.lexer.getTokenStream();
    }

    private void checkNextIsSemiColon() {
        if (this.tokenStream.hasMore() && !HeaderTokenKind.isSemicolon(this.tokenStream.peek())) {
            HeaderToken next = this.tokenStream.next();
            this.recordProblem(HeaderProblemKind.EXPECTED_SEMICOLON, next.getStartOffset(), next.getEndOffset(), next.stringValue());
            this.recoverToNextSemiColon();
        }
    }

    private boolean eatActivationPolicy() {
        return this.eatUniqueName();
    }

    private void eatSingleBundleDescription() {
        this.eatSymbolicName();
        this.checkNextIsSemiColon();
        while (this.maybeEatSemicolon()) {
            this.eatParameter(true);
        }
        this.visitor.clauseEnded();
        this.confirmEnd();
    }

    private void eatBundleDescription() {
        this.eatSymbolicName();
        while (this.maybeEatSemicolon()) {
            this.eatParameter(true);
        }
        this.visitor.clauseEnded();
    }

    private void eatMultipleBundleDescriptions() {
        this.eatBundleDescription();
        while (this.maybeEatComma()) {
            this.eatBundleDescription();
        }
        this.visitor.endvisit();
        this.confirmEnd();
    }

    private boolean parsePackageHeader() {
        boolean ok = this.eatPackageInfo();
        this.visitor.clauseEnded();
        while (this.maybeEatComma() && ok) {
            ok = this.eatPackageInfo();
            this.visitor.clauseEnded();
        }
        this.visitor.endvisit();
        this.confirmEnd();
        return ok;
    }

    private void parseDynamicImportPackage() {
        this.eatDynamicDescription();
        this.visitor.clauseEnded();
        while (this.maybeEatComma()) {
            this.eatDynamicDescription();
            this.visitor.clauseEnded();
        }
        this.visitor.endvisit();
        this.confirmEnd();
    }

    private void parseHeader() {
        this.eatClause();
        this.visitor.clauseEnded();
        while (this.maybeEatComma()) {
            this.eatClause();
            this.visitor.clauseEnded();
        }
        this.visitor.endvisit();
        this.confirmEnd();
    }

    private List<HeaderDeclaration> internalParseDynamicImportPackageHeader(String header) {
        this.initializeTokenStream(header);
        this.parseDynamicImportPackage();
        return this.visitor.getHeaderDeclarations();
    }

    private List<HeaderDeclaration> internalParseHeader(String header) {
        this.visitor.initialize();
        this.lexer = new StandardHeaderLexer(true);
        this.lexer.process(header);
        this.tokenStream = this.lexer.getTokenStream();
        this.parseHeader();
        return this.visitor.getHeaderDeclarations();
    }

    private boolean eatPackageInfo() {
        boolean ok = this.eatPackageNames();
        while (this.maybeEatSemicolon()) {
            ok = this.eatParameter(true);
        }
        return ok;
    }

    private void eatDynamicDescription() {
        this.eatWildcardNames();
        while (this.maybeEatSemicolon()) {
            this.eatParameter(true);
        }
    }

    private void eatClause() {
        this.eatPaths();
        while (this.maybeEatSemicolon()) {
            this.eatParameter(true);
        }
    }

    private boolean peekSemiColon() {
        HeaderToken t = this.tokenStream.peek();
        return t != null && HeaderTokenKind.isSemicolon(t);
    }

    private boolean peekNextIsAttributeOrDirective() {
        HeaderToken tok = this.tokenStream.peek(1);
        return tok != null && tok.isAttributeOrDirectiveName();
    }

    private boolean recoverToNextSemiColon() {
        while (!this.peekSemiColon() && this.tokenStream.hasMore()) {
            this.tokenStream.next();
        }
        return this.tokenStream.hasMore();
    }

    private void eatWildcardNames() {
        boolean ok = this.eatWildcardName();
        if (this.tokenStream.hasMore() && !HeaderTokenKind.isSemicolonOrComma(this.tokenStream.peek())) {
            HeaderToken next = this.tokenStream.next();
            this.recordProblem(HeaderProblemKind.EXPECTED_SEMICOLON_OR_COMMA, next.getStartOffset(), next.getEndOffset(), next.stringValue());
            this.recoverToNextSemiColonOrComma();
            if (this.tokenStream.hasMore() && !HeaderTokenKind.isSemicolon(this.tokenStream.peek())) {
                return;
            }
        }
        do {
            if (!this.peekSemiColon() || !this.peekNextIsAttributeOrDirective()) continue;
            return;
        } while (this.maybeEatSemicolon() && (ok = this.eatWildcardName()));
    }

    private void eatPaths() {
        boolean ok = this.eatPath();
        if (this.tokenStream.hasMore() && !HeaderTokenKind.isSemicolonOrComma(this.tokenStream.peek())) {
            HeaderToken next = this.tokenStream.next();
            this.recordProblem(HeaderProblemKind.EXPECTED_SEMICOLON_OR_COMMA, next.getStartOffset(), next.getEndOffset(), next.stringValue());
            this.recoverToNextSemiColonOrComma();
            if (this.tokenStream.hasMore() && !HeaderTokenKind.isSemicolon(this.tokenStream.peek())) {
                return;
            }
        }
        do {
            if (!this.peekSemiColon() || !this.peekNextIsAttributeOrDirective()) continue;
            return;
        } while (this.maybeEatSemicolon() && (ok = this.eatPath()));
    }

    private boolean eatPath() {
        HeaderToken startToken = this.tokenStream.peek();
        if (startToken == null) {
            HeaderToken previousToken = this.tokenStream.peek(-1);
            this.recordProblem(HeaderProblemKind.UNEXPECTEDLY_OOD, previousToken == null ? 0 : previousToken.getEndOffset(), previousToken == null ? 0 : previousToken.getEndOffset(), new String[0]);
            return false;
        }
        HeaderToken endToken = startToken;
        if (HeaderTokenKind.isQuotedString(startToken)) {
            this.tokenStream.next();
        } else if (HeaderTokenKind.isSlash(startToken)) {
            this.tokenStream.next();
        } else {
            this.tokenStream.next();
            while (HeaderTokenKind.canBeTreatedAsPathElement(this.tokenStream.peek())) {
                if (endToken.hasFollowingSpace()) {
                    this.recordIllegalSpaceProblem(startToken, endToken);
                }
                endToken = this.tokenStream.next();
            }
            HeaderToken slashToken = this.maybeEatSlash();
            while (slashToken != null) {
                if (endToken.hasFollowingSpace()) {
                    this.recordIllegalSpaceProblem(startToken, slashToken);
                }
                endToken = slashToken;
                while (HeaderTokenKind.canBeTreatedAsPathElement(this.tokenStream.peek())) {
                    if (endToken.hasFollowingSpace()) {
                        this.recordIllegalSpaceProblem(startToken, endToken);
                    }
                    endToken = this.tokenStream.next();
                }
                if (slashToken.hasFollowingSpace()) {
                    this.recordIllegalSpaceProblem(startToken, endToken);
                }
                if ((slashToken = this.maybeEatSlash()) == null || !HeaderTokenKind.isSlash(endToken)) continue;
                this.recordDoubleSlashProblem(endToken, slashToken);
            }
        }
        this.visitor.visitUniqueName(StandardHeaderParser.subarray(this.lexer.data, startToken.getStartOffset(), endToken.getEndOffset()));
        return true;
    }

    private boolean eatPackageNames() {
        boolean ok = this.eatPackageName();
        if (this.tokenStream.hasMore() && !HeaderTokenKind.isSemicolonOrComma(this.tokenStream.peek())) {
            HeaderToken next = this.tokenStream.next();
            this.recordProblem(HeaderProblemKind.EXPECTED_SEMICOLON_OR_COMMA, next.getStartOffset(), next.getEndOffset(), next.stringValue());
            this.recoverToNextSemiColonOrComma();
            if (this.tokenStream.hasMore() && !HeaderTokenKind.isSemicolon(this.tokenStream.peek())) {
                return ok;
            }
        }
        while ((!this.peekSemiColon() || !this.peekNextIsAttributeOrDirective()) && this.maybeEatSemicolon() && (ok = this.eatPackageName())) {
        }
        return ok;
    }

    private boolean eatPackageName() {
        return this.eatUniqueName();
    }

    private boolean eatWildcardName() {
        return this.eatWildcardedUniqueName();
    }

    private boolean eatWildcardedUniqueName() {
        HeaderToken start = this.maybeEatStar();
        if (start != null) {
            this.visitor.visitWildcardName(STAR);
            return true;
        }
        start = this.eatIdentifier();
        if (start == null) {
            return false;
        }
        HeaderToken end = start;
        HeaderToken dot = this.maybeEatDot();
        while (dot != null) {
            if (end.hasFollowingSpace()) {
                this.recordIllegalSpaceProblem(start, dot);
            }
            if ((end = this.eatIdentifier()) == null) {
                return false;
            }
            if (dot.hasFollowingSpace()) {
                this.recordIllegalSpaceProblem(start, end);
            }
            dot = this.maybeEatDot();
        }
        HeaderToken dotStarEnding = this.maybeEatDotStar();
        if (dotStarEnding != null) {
            if (end.hasFollowingSpace()) {
                this.recordIllegalSpaceProblem(start, dotStarEnding);
            }
            this.visitor.visitWildcardName(StandardHeaderParser.subarray(this.lexer.data, start.getStartOffset(), dotStarEnding.getEndOffset()));
        } else {
            this.visitor.visitWildcardName(StandardHeaderParser.subarray(this.lexer.data, start.getStartOffset(), end.getEndOffset()));
        }
        return true;
    }

    private boolean eatUniqueName() {
        HeaderToken startToken = this.eatIdentifier();
        if (startToken == null) {
            return false;
        }
        HeaderToken endToken = startToken;
        HeaderToken dotToken = this.maybeEatDot();
        while (dotToken != null) {
            if (endToken.hasFollowingSpace()) {
                this.recordIllegalSpaceProblem(startToken, dotToken);
            }
            if ((endToken = this.eatIdentifier()) == null) {
                return false;
            }
            if (dotToken.hasFollowingSpace()) {
                this.recordIllegalSpaceProblem(startToken, endToken);
            }
            dotToken = this.maybeEatDot();
        }
        this.visitor.visitUniqueName(StandardHeaderParser.subarray(this.lexer.data, startToken.getStartOffset(), endToken.getEndOffset()));
        return true;
    }

    private void eatSymbolicName() {
        HeaderToken startToken = this.eatToken();
        if (startToken == null) {
            return;
        }
        HeaderToken endToken = startToken;
        HeaderToken dotToken = this.maybeEatDot();
        while (dotToken != null) {
            if (endToken.hasFollowingSpace()) {
                this.recordIllegalSpaceProblem(startToken, dotToken);
            }
            if ((endToken = this.eatToken()) == null) {
                this.recordProblem(HeaderProblemKind.TOKEN_CANNOT_END_WITH_DOT, dotToken.getStartOffset(), dotToken.getEndOffset(), new String[0]);
                endToken = dotToken;
                break;
            }
            if (dotToken.hasFollowingSpace()) {
                this.recordIllegalSpaceProblem(startToken, endToken);
            }
            dotToken = this.maybeEatDot();
        }
        this.visitor.visitSymbolicName(StandardHeaderParser.subarray(this.lexer.data, startToken.getStartOffset(), endToken.getEndOffset()));
    }

    private static final String subarray(char[] array, int start, int end) {
        return new String(array, start, end - start);
    }

    private static final String substring(char[] data, int start, int end) {
        return new String(data, start, end - start);
    }

    private void confirmEnd() {
        if (this.tokenStream.hasMore()) {
            HeaderToken current = this.tokenStream.next();
            this.tokenStream.setPosition(this.tokenStream.getCount() - 1);
            HeaderToken last = this.tokenStream.peek();
            String insert = StandardHeaderParser.substring(this.lexer.data, current.getStartOffset(), last.getEndOffset());
            this.recordProblem(HeaderProblemKind.UNCONSUMED_DATA, current.getStartOffset(), last.getEndOffset(), insert);
        }
    }

    private void recordProblem(HeaderProblemKind parseProblem, int startOffset, int endOffset, String ... inserts) {
        this.tokenStream.recordProblem(new HeaderProblem(parseProblem, startOffset, endOffset, inserts));
    }

    private void recordMismatch(HeaderToken token, HeaderProblemKind kind) {
        if (token == null) {
            if (this.tokenStream.getCount() == 0) {
                this.recordProblem(HeaderProblemKind.UNEXPECTEDLY_OOD, 0, 0, new String[0]);
            } else {
                HeaderToken previous = this.tokenStream.peek(-1);
                this.recordProblem(HeaderProblemKind.UNEXPECTEDLY_OOD, previous.getEndOffset(), previous.getEndOffset(), new String[0]);
            }
        } else {
            this.recordProblem(kind, token.getStartOffset(), token.getEndOffset(), token.stringValue());
        }
    }

    private void recoverToNextSemiColonOrComma() {
        HeaderToken tok = this.tokenStream.peek();
        while (tok != null && !HeaderTokenKind.isComma(tok) && !HeaderTokenKind.isSemicolon(tok)) {
            this.tokenStream.next();
            tok = this.tokenStream.peek();
        }
    }

    private boolean eatParameter(boolean attributesAllowed) {
        HeaderToken parameterName = this.eatToken();
        if (parameterName == null) {
            return false;
        }
        if (!parameterName.isAttributeOrDirectiveName()) {
            int pStart = parameterName.getStartOffset();
            char[] insert = parameterName.value();
            int pEnd = parameterName.getEndOffset();
            if (parameterName.isExtended()) {
                pEnd = parameterName.getExtendedEndOffset();
                insert = parameterName.extendedValue();
            }
            this.recordProblem(HeaderProblemKind.EXPECTED_ATTRIBUTE_OR_DIRECTIVE, pStart, pEnd, new String(insert));
            this.recoverToNextSemiColonOrComma();
            return false;
        }
        HeaderToken selector = this.tokenStream.next();
        assert (HeaderTokenKind.isColonEquals(selector) || HeaderTokenKind.isEquals(selector));
        HeaderToken argument = this.eatArgument();
        if (argument == null) {
            return false;
        }
        String argumentValue = null;
        argumentValue = argument.isExtended() ? new String(argument.extendedValue()) : new String(argument.value());
        if (parameterName.isAttributeName()) {
            if (!attributesAllowed) {
                this.recordProblem(HeaderProblemKind.ATTRIBUTES_NOT_ALLOWED_FOR_THIS_HEADER, parameterName.getStartOffset(), parameterName.getEndOffset(), StandardHeaderParser.substring(this.lexer.data, parameterName.getStartOffset(), parameterName.getEndOffset()));
                return false;
            }
            this.visitor.visitAttribute(new String(parameterName.value()), argumentValue);
        } else {
            this.visitor.visitDirective(new String(parameterName.value()), argumentValue);
        }
        HeaderToken next = this.tokenStream.peek();
        if (next != null && !HeaderTokenKind.isSemicolon(next) && !HeaderTokenKind.isComma(next)) {
            this.recordProblem(HeaderProblemKind.EXTRANEOUS_DATA_AFTER_PARAMETER, next.getStartOffset(), next.getEndOffset(), next.stringValue());
            this.recoverToNextSemiColonOrComma();
        }
        return true;
    }

    private HeaderToken eatArgument() {
        HeaderToken argumentToken = this.tokenStream.peek();
        if (argumentToken == null) {
            HeaderToken lastToken = this.tokenStream.peek(-1);
            int lastCharacterOfThatToken = lastToken.getEndOffset() - 1;
            this.recordProblem(HeaderProblemKind.UNEXPECTEDLY_OOD_AT_ARGUMENT_VALUE, lastCharacterOfThatToken, lastCharacterOfThatToken, new String[0]);
            return null;
        }
        if (HeaderTokenKind.isQuotedString(argumentToken)) {
            this.tokenStream.next();
            return argumentToken;
        }
        if (HeaderTokenKind.canBeTreatedAsExtendedToken(argumentToken)) {
            if (argumentToken.isExtended()) {
                HeaderToken next = this.tokenStream.next();
                while (next.getEndOffset() != argumentToken.getExtendedEndOffset()) {
                    next = this.tokenStream.next();
                }
            } else {
                this.tokenStream.next();
            }
            return argumentToken;
        }
        this.recordProblem(HeaderProblemKind.INVALID_ARGUMENT_VALUE, argumentToken.getStartOffset(), argumentToken.getEndOffset(), argumentToken.stringValue());
        this.recoverToNextSemiColonOrComma();
        return null;
    }

    private HeaderToken eatToken() {
        HeaderToken tok = this.tokenStream.peek();
        if (tok != null && HeaderTokenKind.canBeTreatedAsToken(tok)) {
            this.tokenStream.skip();
            return tok;
        }
        this.recordMismatch(tok, HeaderProblemKind.EXPECTED_TOKEN);
        this.recoverToNextSemiColonOrComma();
        return null;
    }

    private HeaderToken eatIdentifier() {
        HeaderToken hToken = this.tokenStream.peek();
        if (hToken != null && HeaderTokenKind.canBeTreatedAsIdentifier(hToken)) {
            this.tokenStream.skip();
            return hToken;
        }
        this.recordMismatch(hToken, HeaderProblemKind.EXPECTED_IDENTIFIER);
        this.recoverToNextSemiColonOrComma();
        return null;
    }

    private HeaderToken maybeEatDot() {
        return this.tokenStream.peekFor(HeaderTokenKind.DOT);
    }

    private HeaderToken maybeEatSlash() {
        return this.tokenStream.peekFor(HeaderTokenKind.SLASH);
    }

    private HeaderToken maybeEatStar() {
        return this.tokenStream.peekFor(HeaderTokenKind.STAR);
    }

    private HeaderToken maybeEatDotStar() {
        return this.tokenStream.peekFor(HeaderTokenKind.DOTSTAR);
    }

    private boolean maybeEatComma() {
        return this.tokenStream.peekFor(HeaderTokenKind.COMMA) != null;
    }

    private boolean maybeEatSemicolon() {
        return this.tokenStream.peekFor(HeaderTokenKind.SEMICOLON) != null;
    }

    private void recordIllegalSpaceProblem(HeaderToken start, HeaderToken end) {
        this.recordProblem(HeaderProblemKind.ILLEGAL_SPACE, start.getStartOffset(), end.getEndOffset(), StandardHeaderParser.substring(this.lexer.data, start.getStartOffset(), end.getEndOffset()));
    }

    private void recordDoubleSlashProblem(HeaderToken first, HeaderToken second) {
        this.recordProblem(HeaderProblemKind.ILLEGAL_DOUBLE_SLASH, first.getStartOffset(), second.getEndOffset(), StandardHeaderParser.substring(this.lexer.data, first.getStartOffset(), second.getEndOffset()));
    }

    private String createErrorMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Error parsing bundle manifest header [");
        char[] data = this.lexer.data;
        sb.append(StandardHeaderParser.subarray(data, 0, data.length - 1)).append("]\n");
        List<HeaderProblem> problems = this.tokenStream.getProblems();
        for (HeaderProblem headerProblem : problems) {
            this.logger.outputErrorMsg(null, headerProblem.toString(this.tokenStream.getSourceContext()));
            sb.append(headerProblem.toString(this.tokenStream.getSourceContext())).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StandardHeaderParser for [").append(this.lexer.data).append("]\n");
        sb.append(this.tokenStream.toFormattedString()).append("\n");
        return sb.toString();
    }
}

