/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.util.common.SynchronizedList;
import org.eclipse.virgo.util.common.Tree;

public final class ThreadSafeArrayListTree<V>
implements Tree<V> {
    private volatile V value;
    private final Object monitor;
    private static final Object tieMonitor = new Object();
    private final List<ThreadSafeArrayListTree<V>> children = new ArrayList<ThreadSafeArrayListTree<V>>();
    private Tree<V> parent;

    public ThreadSafeArrayListTree(V value) {
        this(value, new Object());
    }

    protected ThreadSafeArrayListTree(V value, Object monitor) {
        this.value = value;
        this.monitor = monitor;
    }

    protected ThreadSafeArrayListTree(Tree<V> tree, Tree<V> parent, Object monitor) {
        this.value = tree.getValue();
        this.monitor = monitor;
        this.parent = parent;
        for (Tree<V> child : tree.getChildren()) {
            this.children.add(new ThreadSafeArrayListTree<V>(child, this, this.monitor));
        }
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tree<V>> getChildren() {
        Object object = this.monitor;
        synchronized (object) {
            return new SynchronizedList<Tree<V>>(this.children, this.monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree<V> addChild(Tree<V> child) {
        Object object = this.monitor;
        synchronized (object) {
            ThreadSafeArrayListTree<V> childCopy = new ThreadSafeArrayListTree<V>(child, this, this.monitor);
            this.children.add(childCopy);
            return childCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(Tree<V> child) {
        Object object = this.monitor;
        synchronized (object) {
            boolean removed = this.children.remove(child);
            if (removed) {
                this.setParent(child, null);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParent(Tree<V> child, Tree<V> parent) {
        Object object = this.monitor;
        synchronized (object) {
            if (child instanceof ThreadSafeArrayListTree) {
                ThreadSafeArrayListTree concreteChild = (ThreadSafeArrayListTree)child;
                concreteChild.parent = parent;
            }
        }
    }

    @Override
    public void visit(Tree.TreeVisitor<V> visitor) {
        if (visitor.visit(this)) {
            int i = 0;
            while (i < this.numChildren()) {
                ThreadSafeArrayListTree<V> nextChild = this.getChild(i);
                if (nextChild == null) break;
                nextChild.visit(visitor);
                ++i;
            }
        }
    }

    @Override
    public <E extends Exception> void visit(Tree.ExceptionThrowingTreeVisitor<V, E> visitor) throws E {
        if (visitor.visit(this)) {
            int i = 0;
            while (i < this.numChildren()) {
                ThreadSafeArrayListTree<V> nextChild = this.getChild(i);
                if (nextChild == null) break;
                nextChild.visit(visitor);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadSafeArrayListTree<V> getChild(int i) {
        Object object = this.monitor;
        synchronized (object) {
            try {
                return this.children.get(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numChildren() {
        Object object = this.monitor;
        synchronized (object) {
            return this.children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 1;
        Object object = this.monitor;
        synchronized (object) {
            for (ThreadSafeArrayListTree<V> child : this.children) {
                size += child.size();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.monitor;
        synchronized (object) {
            int result = 1;
            result = 31 * result + this.children.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        int otherHash;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadSafeArrayListTree other = (ThreadSafeArrayListTree)obj;
        int thisHash = System.identityHashCode(this);
        if (thisHash < (otherHash = System.identityHashCode(other))) {
            Object object = this.monitor;
            synchronized (object) {
                Object object2 = other.monitor;
                synchronized (object2) {
                    if (this.children.equals(other.children)) return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                    return false;
                }
            }
        }
        if (thisHash > otherHash) {
            Object object = other.monitor;
            synchronized (object) {
                Object object3 = this.monitor;
                synchronized (object3) {
                    if (this.children.equals(other.children)) return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                    return false;
                }
            }
        }
        Object object = tieMonitor;
        synchronized (object) {
            Object object4 = this.monitor;
            synchronized (object4) {
                Object object5 = other.monitor;
                synchronized (object5) {
                    if (this.children.equals(other.children)) return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.value != null ? this.value : "null").append("<");
        Object object = this.monitor;
        synchronized (object) {
            boolean first = true;
            for (ThreadSafeArrayListTree<V> child : this.children) {
                if (!first) {
                    result.append(", ");
                }
                result.append(child.toString());
                first = false;
            }
        }
        result.append(">");
        return result.toString();
    }

    @Override
    public Tree<V> getParent() {
        return this.parent;
    }
}

