/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loader;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.eclipse.gemini.web.tomcat.internal.loader.BundleClassPathURLExtractor;
import org.eclipse.gemini.web.tomcat.internal.loader.BundleDelegatingClassLoader;
import org.eclipse.gemini.web.tomcat.internal.loader.ChainedClassLoader;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWebappClassLoader
extends URLClassLoader
implements Lifecycle,
BundleReference {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile boolean started = false;
    private final ClassLoader bundleDelegatingClassLoader;
    private final ClassLoaderCustomizer classLoaderCustomizer;
    private final Bundle bundle;
    private volatile LifecycleState state = LifecycleState.NEW;

    public BundleWebappClassLoader(Bundle bundle, ClassLoaderCustomizer classLoaderCustomizer) {
        super(new URL[0], BundleWebappClassLoader.class.getClassLoader().getParent());
        this.bundle = bundle;
        this.classLoaderCustomizer = classLoaderCustomizer;
        this.addBundleClassPathURLs(bundle);
        this.bundleDelegatingClassLoader = this.createClassLoaderChain(bundle);
    }

    private ChainedClassLoader createClassLoaderChain(Bundle bundle) {
        ClassLoader[] finalLoaders;
        ClassLoader[] loaders = new ClassLoader[]{BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle), Context.class.getClassLoader()};
        ClassLoader[] chainExtensions = this.classLoaderCustomizer.extendClassLoaderChain(bundle);
        if (chainExtensions != null && chainExtensions.length > 0) {
            finalLoaders = new ClassLoader[loaders.length + chainExtensions.length];
            System.arraycopy(loaders, 0, finalLoaders, 0, loaders.length);
            System.arraycopy(chainExtensions, 0, finalLoaders, loaders.length, chainExtensions.length);
        } else {
            finalLoaders = loaders;
        }
        return ChainedClassLoader.create(finalLoaders);
    }

    private void addBundleClassPathURLs(Bundle bundle) {
        Set<URI> uris = BundleClassPathURLExtractor.extractBundleClassPathURLs(bundle);
        for (URI uri : uris) {
            try {
                this.addURL(uri.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoaderCustomizer.addClassFileTransformer(transformer, this.bundle);
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.classLoaderCustomizer.createThrowawayClassLoader(this.bundle);
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void destroy() throws LifecycleException {
        this.state = LifecycleState.DESTROYING;
        try {
            super.close();
        }
        catch (IOException ioe) {
            this.log.warn("Failure calling close() on super class", (Throwable)ioe);
        }
        this.state = LifecycleState.DESTROYED;
    }

    public LifecycleState getState() {
        return this.state;
    }

    public String getStateName() {
        return this.getState().toString();
    }

    public void init() throws LifecycleException {
        this.state = LifecycleState.INITIALIZED;
    }

    public void start() throws LifecycleException {
        this.started = true;
    }

    public void stop() throws LifecycleException {
        this.clearReferences();
        this.started = false;
    }

    @Override
    public URL getResource(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getResource(" + name + ")");
        }
        URL url = null;
        url = this.bundleDelegatingClassLoader.getResource(name);
        if (url != null) {
            return url;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resource not found, returning null.");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.bundleDelegatingClassLoader.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getResources(" + name + ")");
        }
        return this.bundleDelegatingClassLoader.getResources(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clazz = null;
        if (!this.started) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                this.log.info("Illegal access: this web application instance has been stopped already.  Could not load [" + name + "].  The eventual following stack trace is caused by an error thrown for debugging purposes" + "as well as to attempt to terminate the thread which caused the illegal access, and has no functional impact.", (Throwable)e);
            }
        }
        if ((clazz = this.findLoadedClass(name)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Returning class from cache.");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Searching the application's bundle.");
        }
        try {
            clazz = this.bundleDelegatingClassLoader.loadClass(name);
            if (clazz != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Loading class from the delegating classloader.");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        throw new ClassNotFoundException(name);
    }

    private void clearReferences() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() != this) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                this.log.warn("SQL driver deregistration failed.", (Throwable)e);
            }
        }
        IntrospectionUtils.clear();
        LogFactory.release((ClassLoader)this);
        Introspector.flushCaches();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setClearReferencesStatic(boolean clearReferencesStatic) {
    }

    public void setClearReferencesStopThreads(boolean clearReferencesStopThreads) {
    }

    public void setClearReferencesStopTimerThreads(boolean clearReferencesStopTimerThreads) {
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean clearReferencesHttpClientKeepAliveThread) {
    }

    public void setClearReferencesRmiTargets(boolean clearReferencesRmiTargets) {
    }
}

