/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel;

import fr.inria.aoste.timesquare.ccslkernel.compiler.CompilerParameters;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.AbstractStatement;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.SimpleStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MemberFunction {
    private List<String> annotations = new ArrayList<String>();
    private boolean overrides = false;
    private boolean constructor = false;
    private List<String> modifiers = new ArrayList<String>();
    private String name;
    private String returnType;
    private List<String> exceptions = new ArrayList<String>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<AbstractStatement> statements = null;

    public MemberFunction(String name) {
        this.name = name;
    }

    public MemberFunction(String name, String returnType) {
        this.name = name;
        this.returnType = returnType;
    }

    public String getName() {
        return this.name;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public void setOverrides(boolean ov) {
        this.overrides = ov;
    }

    public void setConstructor(boolean v) {
        this.constructor = v;
    }

    public void addModifier(String modifier) {
        this.modifiers.add(modifier);
    }

    public void addParameter(String type, String name) {
        Parameter parameter = new Parameter(type, name);
        this.parameters.add(parameter);
    }

    public void addException(String type) {
        this.exceptions.add(type);
    }

    public void addStatement(AbstractStatement statement) {
        if (this.statements == null) {
            this.statements = new ArrayList<AbstractStatement>();
        }
        this.statements.add(statement);
    }

    public void addStatement(String code) {
        this.addStatement(new SimpleStatement(code));
    }

    public AbstractStatement getLastStatement() {
        if (this.statements == null) {
            return null;
        }
        return this.statements.get(this.statements.size() - 1);
    }

    private void addIndentation(int indent, StringBuilder content) {
        int i = 0;
        while (i < indent) {
            content.append(' ');
            ++i;
        }
    }

    public void generate(StringBuilder stringBuilder, int indentation) {
        for (String annotation : this.annotations) {
            this.addIndentation(indentation, stringBuilder);
            stringBuilder.append("@" + annotation + "\n");
        }
        if (this.overrides) {
            this.addIndentation(indentation, stringBuilder);
            stringBuilder.append("@" + Override.class.getSimpleName() + "\n");
        }
        this.addIndentation(indentation, stringBuilder);
        for (String modifier : this.modifiers) {
            stringBuilder.append(String.valueOf(modifier) + " ");
        }
        if (this.constructor) {
            stringBuilder.append(String.valueOf(this.name) + "(");
        } else if (this.returnType == null) {
            stringBuilder.append("void " + this.name + "(");
        } else {
            stringBuilder.append(String.valueOf(this.returnType) + " " + this.name + "(");
        }
        Iterator<Object> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Parameter parameter = iter.next();
            stringBuilder.append(String.valueOf(parameter.type) + " " + parameter.name);
            if (!iter.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        if (!this.exceptions.isEmpty()) {
            stringBuilder.append("\n");
            this.addIndentation(indentation * 4, stringBuilder);
            stringBuilder.append("throws ");
            iter = this.exceptions.iterator();
            while (iter.hasNext()) {
                stringBuilder.append((String)iter.next());
                if (!iter.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(" {\n");
        if (this.statements != null && !this.statements.isEmpty()) {
            for (AbstractStatement statement : this.statements) {
                statement.generate(stringBuilder, indentation + CompilerParameters.indentStep);
            }
        }
        this.addIndentation(indentation, stringBuilder);
        stringBuilder.append("}\n");
    }

    private class Parameter {
        public final String type;
        public final String name;

        public Parameter(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }
}

