/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.extensions.sirius;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.gemoc.executionframework.extensions.sirius";
    private static Activator plugin;

    public Activator() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    for (Map.Entry engineEntry : org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry.getRunningEngines().entrySet()) {
                        try {
                            URI uri;
                            IExecutionEngine engine = (IExecutionEngine)engineEntry.getValue();
                            if (engine.getRunningStatus() != EngineStatus.RunStatus.Stopped) {
                                engine.dispose();
                            }
                            if ((uri = engine.getExecutionContext().getRunConfiguration().getAnimatorURI()) == null) continue;
                            Session session = SessionManager.INSTANCE.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
                            session.close((IProgressMonitor)new NullProgressMonitor());
                            SessionManager.INSTANCE.remove(session);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

