/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.view;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gemoc.timeline.Activator;
import org.eclipse.gemoc.timeline.editpart.BranchEditPart;
import org.eclipse.gemoc.timeline.editpart.ChoiceEditPart;
import org.eclipse.gemoc.timeline.editpart.PossibleStepEditPart;
import org.eclipse.gemoc.timeline.editpart.TimelineEditPartFactory;
import org.eclipse.gemoc.timeline.model.ITimelineWindowListener;
import org.eclipse.gemoc.timeline.model.TimelineWindow;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractTimelineView
extends ViewPart {
    public static final String ID = "org.eclipse.gemoc.timeline.view";
    private static final int DETAIL_RATIO = 10;
    private static final int TIMELINE_RATIO = 90;
    private TreeViewer detailViewer;
    private ScrollingGraphicalViewer timelineViewer;
    private ScalableFreeformRootEditPart rootEditPart;
    private Slider timelineSlider;
    private TimelineWindow timelineWindow;
    private ITimelineProvider provider;
    private ITimelineWindowListener timelineWindowListener;
    private boolean follow;
    private int nbVirtualChoices;
    private MenuManager menuManager;

    public void createPartControl(Composite parent) {
        Command followCommand;
        Composite container;
        if (this.hasDetailViewer()) {
            SashForm mainSashForm = new SashForm(parent, 256);
            container = mainSashForm;
            this.detailViewer = this.createDetailViewer(container);
        } else {
            container = parent;
        }
        this.timelineViewer = new ScrollingGraphicalViewer();
        Composite timelineComposite = new Composite(container, 0);
        timelineComposite.setLayout((Layout)new FillLayout(768));
        if (this.hasDetailViewer()) {
            ((SashForm)container).setWeights(new int[]{10, 90});
        }
        GridLayout layout = new GridLayout(1, false);
        timelineComposite.setLayout((Layout)layout);
        this.timelineViewer.createControl(timelineComposite);
        this.timelineSlider = new Slider(timelineComposite, 256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.timelineSlider.setLayoutData((Object)gridData);
        gridData.grabExcessHorizontalSpace = true;
        this.rootEditPart = new ScalableFreeformRootEditPart();
        this.rootEditPart.setViewer((EditPartViewer)this.timelineViewer);
        this.timelineViewer.setRootEditPart((RootEditPart)this.rootEditPart);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.timelineViewer.getControl().setLayoutData((Object)gridData);
        this.timelineViewer.setEditPartFactory((EditPartFactory)this.getTimelineEditPartFactory());
        this.timelineWindow = new TimelineWindow(this.provider);
        this.timelineViewer.setContents((Object)this.timelineWindow);
        this.timelineSlider.setPageIncrement(this.timelineWindow.getLength());
        this.timelineSlider.setThumb(this.timelineWindow.getLength());
        this.timelineSlider.setSelection(this.timelineWindow.getStart());
        if (this.provider != null) {
            this.timelineSlider.setMaximum(this.timelineWindow.getMaxTimelineIndex() + this.nbVirtualChoices);
            this.timelineSlider.setVisible(this.timelineWindow.getLength() < this.timelineWindow.getMaxTimelineIndex() + this.nbVirtualChoices);
        } else {
            this.timelineSlider.setVisible(false);
        }
        this.timelineSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractTimelineView.this.follow) {
                    AbstractTimelineView.this.toggleFollow();
                }
                AbstractTimelineView.this.timelineWindow.setStart(AbstractTimelineView.this.timelineSlider.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AbstractTimelineView.this.follow) {
                    AbstractTimelineView.this.toggleFollow();
                }
                AbstractTimelineView.this.timelineWindow.setStart(AbstractTimelineView.this.timelineSlider.getSelection());
            }
        });
        this.timelineWindowListener = new TimelineWindowListener();
        this.timelineWindow.addTimelineWindowListener(this.timelineWindowListener);
        if (this.provider != null) {
            this.provider.addTimelineListener(this.timelineWindowListener);
        }
        this.timelineViewer.getControl().setBackground(ColorConstants.listBackground);
        if (this.hasDetailViewer()) {
            this.timelineViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object firstElement;
                    ISelection selection = event.getSelection();
                    if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof PossibleStepEditPart) {
                        PossibleStepEditPart possibleStepEditPart = (PossibleStepEditPart)((Object)firstElement);
                        AbstractTimelineView.this.detailViewer.setInput(possibleStepEditPart.getModel().getPossibleStep());
                    }
                }
            });
        }
        this.timelineViewer.getControl().addKeyListener((KeyListener)new TimelineKeyListener());
        TimelineMouseListener listener = new TimelineMouseListener();
        this.timelineViewer.getControl().addMouseListener((MouseListener)listener);
        this.timelineViewer.getControl().addMouseMoveListener((MouseMoveListener)listener);
        this.timelineViewer.getControl().addMouseWheelListener((MouseWheelListener)new TimelineMouseWheelListener());
        this.rootEditPart.getZoomManager().addZoomListener(new ZoomListener(){

            public void zoomChanged(double zoom) {
                AbstractTimelineView.this.timelineWindow.setLength(AbstractTimelineView.this.getWindowLength());
            }
        });
        this.timelineViewer.getControl().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                AbstractTimelineView.this.timelineWindow.setLength(AbstractTimelineView.this.getWindowLength());
                Canvas canevas = (Canvas)AbstractTimelineView.this.timelineViewer.getControl();
                canevas.getHorizontalBar().setVisible(false);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        ICommandService cmdService = (ICommandService)this.getSite().getService(ICommandService.class);
        String commandID = this.getFollowCommandID();
        if (commandID != null && (followCommand = cmdService.getCommand(commandID)) != null) {
            State state = followCommand.getState("org.eclipse.ui.commands.toggleState");
            this.follow = state != null && (Boolean)state.getValue() != false;
        }
        this.createMenuManager();
    }

    private void createMenuManager() {
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractTimelineView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = this.menuManager.createContextMenu(this.timelineViewer.getControl());
        this.timelineViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.timelineViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.timelineViewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    protected abstract TimelineEditPartFactory getTimelineEditPartFactory();

    private void toggleFollow() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        try {
            String commandId = this.getFollowCommandID();
            if (commandId != null) {
                handlerService.executeCommand(commandId, null);
            }
        }
        catch (ExecutionException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gemoc.timeline", e1.getMessage()));
        }
        catch (NotDefinedException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gemoc.timeline", e1.getMessage()));
        }
        catch (NotEnabledException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gemoc.timeline", e1.getMessage()));
        }
        catch (NotHandledException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gemoc.timeline", e1.getMessage()));
        }
    }

    public ScrollingGraphicalViewer getTimelineViewer() {
        return this.timelineViewer;
    }

    public void setTimelineProvider(ITimelineProvider timelineProvider, int start) {
        this.timelineWindow.setProvider(timelineProvider, start);
        if (this.provider != null) {
            this.provider.removeTimelineListener(this.timelineWindowListener);
        }
        this.provider = timelineProvider;
        if (timelineProvider != null) {
            this.provider.addTimelineListener(this.timelineWindowListener);
        }
        this.timelineWindow.setLength(this.getWindowLength());
    }

    public int getStart() {
        int res = this.timelineWindow != null ? this.timelineWindow.getStart() : 0;
        return res;
    }

    private int getWindowLength() {
        int length = 0;
        double averageWidth = 20.0;
        int lastChoiceWidth = 20;
        if (this.provider != null && this.timelineViewer != null) {
            for (BranchEditPart branchEditPart : this.timelineViewer.getContents().getChildren()) {
                double[] widthes = this.computeWidthesForBranch(branchEditPart);
                averageWidth = Math.max(averageWidth, widthes[0]);
                lastChoiceWidth = Math.max(lastChoiceWidth, (int)widthes[1]);
            }
            double baseWidth = (averageWidth + 10.0) * this.rootEditPart.getZoomManager().getZoom();
            length = this.timelineViewer.getControl().getBounds().width > 20 ? (int)Math.floor((double)(this.timelineViewer.getControl().getBounds().width - 20) / baseWidth) : 0;
            if (lastChoiceWidth > 20) {
                this.nbVirtualChoices = (int)Math.floor((double)lastChoiceWidth * this.rootEditPart.getZoomManager().getZoom() / baseWidth);
                if (this.provider != null) {
                    this.timelineSlider.setMaximum(this.timelineWindow.getMaxTimelineIndex() + this.nbVirtualChoices);
                }
            }
        }
        return length;
    }

    private double[] computeWidthesForBranch(BranchEditPart branchEditPart) {
        double averageWidth = 0.0;
        int lastChoiceWidth = 0;
        if (branchEditPart.getChildren().size() != 0) {
            Iterator it = branchEditPart.getChildren().iterator();
            while (it.hasNext()) {
                ChoiceEditPart editPart = (ChoiceEditPart)((Object)it.next());
                if (this.timelineWindow.getEnd() >= this.timelineWindow.getMaxTimelineIndex()) {
                    if (it.hasNext()) {
                        averageWidth += (double)editPart.getFigure().getPreferredSize().width;
                        continue;
                    }
                    lastChoiceWidth = editPart.getFigure().getPreferredSize((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE).width;
                    continue;
                }
                averageWidth += (double)editPart.getFigure().getPreferredSize().width;
            }
            averageWidth /= (double)branchEditPart.getChildren().size();
        } else {
            averageWidth = 20.0;
            lastChoiceWidth = 20;
        }
        return new double[]{averageWidth, lastChoiceWidth};
    }

    protected TreeViewer createDetailViewer(Composite parent) {
        FilteredTree treeViewer = new FilteredTree(parent, 0, this.createDetailPatternFilter(), false);
        return treeViewer.getViewer();
    }

    public void setDetailViewerContentProvider(IContentProvider detailContentProvider) {
        if (this.detailViewer != null) {
            this.detailViewer.setContentProvider(detailContentProvider);
        }
    }

    public void setDetailViewerLabelProvider(ILabelProvider detailLabelProvider) {
        if (this.detailViewer != null) {
            this.detailViewer.setLabelProvider((IBaseLabelProvider)detailLabelProvider);
        }
    }

    protected PatternFilter createDetailPatternFilter() {
        PatternFilter res = new PatternFilter();
        return res;
    }

    public Viewer getDetailViewer() {
        return this.detailViewer;
    }

    public void setFocus() {
        if (this.timelineViewer != null) {
            this.timelineViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        this.timelineWindow.removeTimelineWindowListener(this.timelineWindowListener);
        super.dispose();
    }

    public void setFollow(boolean newFollow) {
        int start;
        this.follow = newFollow;
        if (this.follow && this.provider != null && this.timelineWindow != null && (start = this.timelineWindow.getMaxTimelineIndex() + this.nbVirtualChoices - this.timelineWindow.getLength()) >= 0) {
            this.timelineWindow.setStart(start);
        }
    }

    public abstract boolean hasDetailViewer();

    public abstract String getFollowCommandID();

    private final class TimelineKeyListener
    implements KeyListener {
        private TimelineKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            List selected = AbstractTimelineView.this.timelineViewer.getSelectedEditParts();
            if (selected.size() == 1 && selected.get(0) instanceof PossibleStepEditPart) {
                PossibleStepEditPart toSelect;
                PossibleStepEditPart part = (PossibleStepEditPart)((Object)selected.get(0));
                switch (e.keyCode) {
                    case 0x1000003: {
                        if (AbstractTimelineView.this.timelineWindow.getStart() > part.getModel().getChoice().getIndex() - 1 && part.getModel().getChoice().getIndex() - 1 >= 0) {
                            if (AbstractTimelineView.this.follow) {
                                AbstractTimelineView.this.toggleFollow();
                            }
                            AbstractTimelineView.this.timelineWindow.setStart(AbstractTimelineView.this.timelineWindow.getStart() - 1);
                        }
                        toSelect = part.getLeftPossibleStepEditPart();
                        break;
                    }
                    case 0x1000004: {
                        if (AbstractTimelineView.this.timelineWindow.getEnd() <= part.getModel().getChoice().getIndex() + 1 && part.getModel().getChoice().getIndex() + 1 <= AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices) {
                            AbstractTimelineView.this.timelineWindow.setStart(AbstractTimelineView.this.timelineWindow.getStart() + 1);
                        }
                        toSelect = part.getRightPossibleStepEditPart();
                        break;
                    }
                    case 0x1000001: {
                        toSelect = part.getAbovePossibleStepEditPart();
                        break;
                    }
                    case 0x1000002: {
                        toSelect = part.getBeneathPossibleStepEditPart();
                        break;
                    }
                    default: {
                        toSelect = null;
                    }
                }
                if (toSelect != null) {
                    AbstractTimelineView.this.timelineViewer.getSelectionManager().deselectAll();
                    AbstractTimelineView.this.timelineViewer.getSelectionManager().appendSelection((EditPart)toSelect);
                    part.getViewer().reveal((EditPart)toSelect);
                }
            }
        }
    }

    private final class TimelineMouseListener
    implements MouseListener,
    MouseMoveListener {
        private Point originMousePosition;
        private Point offset = new Point();
        private int doneShift;

        private TimelineMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                this.originMousePosition = new Point(e.x, e.y);
                Canvas canevas = (Canvas)AbstractTimelineView.this.timelineViewer.getControl();
                this.doneShift = 0;
                this.offset.y = canevas.getVerticalBar() != null ? canevas.getVerticalBar().getSelection() : 0;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1) {
                this.originMousePosition = null;
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.originMousePosition != null) {
                FigureCanvas canvas = (FigureCanvas)AbstractTimelineView.this.timelineViewer.getControl();
                canvas.scrollTo(this.offset.x, this.offset.y - e.y + this.originMousePosition.y);
                int shift = (int)((double)((-e.x + this.originMousePosition.x) / 30) / AbstractTimelineView.this.rootEditPart.getZoomManager().getZoom()) - this.doneShift;
                int multiplier = (e.stateMask & SWT.MOD1) != 0 ? AbstractTimelineView.this.timelineWindow.getLength() : 1;
                if (AbstractTimelineView.this.follow && shift < 0) {
                    AbstractTimelineView.this.toggleFollow();
                }
                if (AbstractTimelineView.this.timelineWindow.getStart() + shift * multiplier < 0) {
                    AbstractTimelineView.this.timelineWindow.setStart(0);
                } else if (AbstractTimelineView.this.provider != null && AbstractTimelineView.this.timelineWindow.getStart() + AbstractTimelineView.this.timelineWindow.getLength() + shift * multiplier > AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices) {
                    AbstractTimelineView.this.timelineWindow.setStart(Math.max(AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices - AbstractTimelineView.this.timelineWindow.getLength(), 0));
                } else if (shift != 0) {
                    this.doneShift += shift;
                    AbstractTimelineView.this.timelineWindow.setStart(AbstractTimelineView.this.timelineWindow.getStart() + shift * multiplier);
                }
            }
        }
    }

    private final class TimelineMouseWheelListener
    implements MouseWheelListener {
        private TimelineMouseWheelListener() {
        }

        public void mouseScrolled(MouseEvent e) {
            if ((e.stateMask & SWT.MOD1) != 0) {
                this.zoom(e);
            } else {
                this.scroll(e);
            }
        }

        private void scroll(MouseEvent e) {
            FigureCanvas canvas = (FigureCanvas)AbstractTimelineView.this.timelineViewer.getControl();
            if (canvas.getVerticalBar() != null) {
                int offsetY = canvas.getVerticalBar().getSelection();
                if (e.count > 0) {
                    int destinationY = offsetY + 10;
                    if (destinationY <= canvas.getVerticalBar().getMinimum()) {
                        canvas.scrollTo(0, destinationY);
                    }
                } else {
                    int destinationY = offsetY - 10;
                    if (destinationY >= canvas.getVerticalBar().getMaximum()) {
                        canvas.scrollTo(0, destinationY);
                    }
                }
            }
        }

        private void zoom(MouseEvent e) {
            if (e.count > 0) {
                AbstractTimelineView.this.rootEditPart.getZoomManager().zoomIn();
            } else {
                AbstractTimelineView.this.rootEditPart.getZoomManager().zoomOut();
                int length = AbstractTimelineView.this.getWindowLength();
                if (AbstractTimelineView.this.provider != null && AbstractTimelineView.this.timelineWindow.getStart() + length > AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices && AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices - length >= 0) {
                    AbstractTimelineView.this.timelineWindow.setStart(AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices - length);
                }
            }
        }
    }

    private class TimelineWindowListener
    extends ITimelineWindowListener.Stub {
        private TimelineWindowListener() {
        }

        @Override
        public void endChanged(int branch, int end) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractTimelineView.this.timelineSlider.isDisposed()) {
                        AbstractTimelineView.this.timelineSlider.setMaximum(AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices);
                        AbstractTimelineView.this.timelineSlider.setVisible(AbstractTimelineView.this.timelineWindow.getLength() < AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices);
                    }
                    if (AbstractTimelineView.this.follow && AbstractTimelineView.this.provider != null) {
                        int start = AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices - AbstractTimelineView.this.timelineWindow.getLength();
                        if (start < 0) {
                            start = 0;
                        }
                        AbstractTimelineView.this.timelineWindow.setStart(start);
                    }
                }
            });
        }

        @Override
        public void startChanged(final int start) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractTimelineView.this.timelineSlider.isDisposed()) {
                        AbstractTimelineView.this.timelineSlider.setSelection(start);
                    }
                    AbstractTimelineView.this.timelineWindow.setLength(AbstractTimelineView.this.getWindowLength());
                }
            });
        }

        @Override
        public void lengthChanged(final int length) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    int start;
                    if (!AbstractTimelineView.this.timelineSlider.isDisposed()) {
                        AbstractTimelineView.this.timelineSlider.setPageIncrement(length);
                        AbstractTimelineView.this.timelineSlider.setThumb(length);
                        if (AbstractTimelineView.this.provider != null) {
                            AbstractTimelineView.this.timelineSlider.setMaximum(AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices);
                            AbstractTimelineView.this.timelineSlider.setVisible(AbstractTimelineView.this.timelineWindow.getLength() < AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices);
                        } else {
                            AbstractTimelineView.this.timelineSlider.setVisible(false);
                        }
                    }
                    if (AbstractTimelineView.this.follow && AbstractTimelineView.this.provider != null && (start = AbstractTimelineView.this.timelineWindow.getMaxTimelineIndex() + AbstractTimelineView.this.nbVirtualChoices - length) >= 0) {
                        AbstractTimelineView.this.timelineWindow.setStart(start);
                    }
                }
            });
        }
    }
}

