/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.findrefs;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.ui.editor.findrefs.FindReferencesHandler;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQueryExecutor;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.ui.jvmmodel.findrefs.JdtReferenceFinder;

public class JvmModelFindReferenceHandler
extends FindReferencesHandler {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private JdtReferenceFinder jdtReferenceFinder;
    @Inject
    private OverrideHelper overrideHelper;

    protected void findReferences(EObject target) {
        ReferenceQueryExecutor queryExecutor = this.getQueryExecutor(target);
        if (queryExecutor != null) {
            Iterable<IJavaElement> javaElements = this.getJavaElements(target);
            if (Iterables.size(javaElements) > 0) {
                this.jdtReferenceFinder.run(queryExecutor.getLabel(target), javaElements);
            } else {
                queryExecutor.execute();
            }
        }
    }

    public Iterable<IJavaElement> getJavaElements(EObject target) {
        Set<EObject> jvmElements = this.isJvmElement(target) ? Collections.singleton(target) : this.associations.getJvmElements(target);
        if (!(jvmElements = this.filterJvmElements(jvmElements)).isEmpty()) {
            ArrayList javaElements = Lists.newArrayList();
            for (EObject jvmElement : jvmElements) {
                IJavaElement javaElement;
                if (!(jvmElement instanceof JvmIdentifiableElement) || (javaElement = this.javaElementFinder.findExactElementFor((JvmIdentifiableElement)jvmElement)) == null) continue;
                javaElements.add(javaElement);
            }
            return javaElements;
        }
        return Collections.emptyList();
    }

    protected Set<EObject> filterJvmElements(Set<EObject> unfiltered) {
        LinkedHashSet filtered = Sets.newLinkedHashSet();
        for (EObject element : unfiltered) {
            if (!this.isAcceptedElement(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    protected boolean isAcceptedElement(EObject jvmElement) {
        JvmOperation op;
        return !(jvmElement instanceof JvmOperation) || this.associations.isPrimaryJvmElement((EObject)(op = (JvmOperation)jvmElement)) || this.overrideHelper.findOverriddenOperation(op) == null;
    }

    protected boolean isJvmElement(EObject target) {
        return target.eClass().getEPackage() == TypesPackage.eINSTANCE;
    }
}

