/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.IncompleteTagException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.ITagExtensionService;
import org.eclipse.gendoc.tags.ITagHandler;
import org.eclipse.gendoc.tags.TagsExtensionPoint;
import org.eclipse.gendoc.tags.handlers.ITagHandlerService;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.eclipse.gendoc.tags.parsers.ITagParserService;

public abstract class AbstractTagHandler
implements ITagHandler,
IExecutableExtension {
    private String tagName;

    public String getTagName() {
        return this.tagName;
    }

    public boolean isHandlerFor(ITag tag) {
        return this.tagName.equals(tag.getName());
    }

    public String run(ITag tag) throws GenDocException {
        IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        String value = "";
        try {
            StringBuffer buffer;
            if (Platform.inDebugMode()) {
                buffer = new StringBuffer("AbstractTagHandler.run -> Tag :");
                buffer.append(tag.getName());
                buffer.append("  value :");
                buffer.append(tag.getValue());
                buffer.append("\n");
                buffer.append("Attributes  :\n");
                for (String key : tag.getAttributes().keySet()) {
                    buffer.append(" - ");
                    buffer.append(key);
                    buffer.append(":");
                    buffer.append((String)tag.getAttributes().get(key));
                    buffer.append("\n");
                }
                logger.log(buffer.toString(), 16);
            }
            if (!tag.isComplete()) {
                throw new IncompleteTagException(tag.getName());
            }
            value = this.runAttributes(tag, tag.getValue());
            if (Platform.inDebugMode()) {
                buffer = new StringBuffer("AbstractTagHandler.run -> Tag :");
                buffer.append(tag.getName());
                buffer.append(" value after RunAttributes : ");
                buffer.append(value);
                buffer.append("\n");
                logger.log(buffer.toString(), 16);
            }
            value = this.runScripts(tag, value);
            if (Platform.inDebugMode()) {
                buffer = new StringBuffer("AbstractTagHandler.run -> Tag :");
                buffer.append(tag.getName());
                buffer.append(" value after RunScript : ");
                buffer.append(value);
                buffer.append("\n");
                logger.log(buffer.toString(), 16);
            }
            value = this.runChildren(tag, value);
            if (Platform.inDebugMode()) {
                buffer = new StringBuffer("AbstractTagHandler.run -> Tag :");
                buffer.append(tag.getName());
                buffer.append(" value after RunChildren : ");
                buffer.append(value);
                buffer.append("\n");
                logger.log(buffer.toString(), 16);
            }
        }
        catch (GenDocException e) {
            String tagIdFound = (String)tag.getAttributes().get(RegisteredTags.ID);
            String message = e.getUIMessage();
            if (tagIdFound == null) {
                throw e;
            }
            message = "The execution of tag with id '" + tagIdFound + "' failed : " + e.getUIMessage();
            logger.log(message, 16);
            diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.tags.handlers", 0, message, null));
            e.printStackTrace();
        }
        return value;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.tagName = config.getAttribute(TagsExtensionPoint.TAG_NAME);
    }

    protected String runAttributes(ITag tag, String value) throws GenDocException {
        return value;
    }

    protected String runChildren(ITag tag, String value) throws GenDocException {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        ITagExtensionService tagExtensionService = (ITagExtensionService)GendocServices.getDefault().getService(ITagExtensionService.class);
        ITagHandlerService tagHandlerService = (ITagHandlerService)GendocServices.getDefault().getService(ITagHandlerService.class);
        ITagParserService tagParserService = (ITagParserService)GendocServices.getDefault().getService(ITagParserService.class);
        List subTagNames = tagExtensionService.getTagExtension(this.getTagName()).getSubTagNames();
        String cleanedTagContent = documentService.cleanTagContent(value, subTagNames);
        List tags = tagParserService.parse(tag, cleanedTagContent, subTagNames);
        StringBuffer tagValue = new StringBuffer(cleanedTagContent.length());
        IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        for (ITag subTag : tags) {
            ITagHandler tagHandler = tagHandlerService.getHandlerFor(subTag);
            try {
                if (tagHandler != null) {
                    tagValue.append(tagHandler.run(subTag));
                    continue;
                }
                tagValue.append(subTag.getRawText());
            }
            catch (GenDocException e) {
                String subTagIdFound = (String)subTag.getAttributes().get(RegisteredTags.ID);
                String message = e.getUIMessage();
                if (subTagIdFound == null) {
                    throw e;
                }
                message = "The execution of tag with id '" + subTagIdFound + "' failed : " + e.getUIMessage();
                diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.tags.handlers", 0, message, null));
            }
        }
        return tagValue.toString();
    }

    protected String runScripts(ITag tag, String value) throws GenDocException {
        return value;
    }
}

