/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx.cellmarkers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.xlsx.CellRef;
import org.eclipse.gendoc.document.parser.xlsx.XLSXParser;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.AbstractCellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.CellMark;
import org.eclipse.gendoc.document.parser.xlsx.cellmarkers.ICellRefMarker;
import org.eclipse.gendoc.document.parser.xlsx.helper.XPathXlsxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CellRefMarker
extends AbstractCellRefMarker
implements ICellRefMarker {
    protected final String attrPath;
    protected final String parentCountAttrPath;

    public CellRefMarker(String mark, String xpath, String attrPath) {
        super(mark, xpath);
        this.attrPath = attrPath;
        this.parentCountAttrPath = null;
    }

    public CellRefMarker(String mark, String relationType, String xpath, String attrPath) {
        super(mark, xpath);
        this.attrPath = attrPath;
        this.parentCountAttrPath = null;
    }

    public CellRefMarker(String mark, String relationType, String xpath, String attrPath, String parentCountAttrPath) {
        super(mark, relationType, xpath);
        this.attrPath = attrPath;
        this.parentCountAttrPath = parentCountAttrPath;
    }

    @Override
    public List<CellMark> getMarksToApply(XLSXParser xlsxParser) {
        XLSXParser parser = xlsxParser;
        if (this.relationType != null) {
            try {
                parser = xlsxParser.loadImplicitPartDocument(this.relationType);
                if (parser == null) {
                    return Collections.EMPTY_LIST;
                }
            }
            catch (IOException iOException) {
                return Collections.EMPTY_LIST;
            }
        }
        try {
            ArrayList<CellMark> marks = new ArrayList<CellMark>();
            NodeList nl = this.evaluateNodes(parser);
            XPathExpression attrXpath = XPathXlsxUtils.compile(this.attrPath);
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(0);
                String ref = attrXpath.evaluate(el);
                String elXPath = XPathXlsxUtils.getNodeXPath(el);
                marks.add(this.createMark(xlsxParser, new CellRef(ref), this.relationType, elXPath, 0));
                ++i;
            }
            return marks;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected NodeList evaluateNodes(XMLParser xlsxParser) throws XPathExpressionException {
        return XPathXlsxUtils.evaluateNodes(xlsxParser.getDocument(), String.valueOf(this.xpath) + "[" + this.attrPath + "]");
    }

    @Override
    public void layoutCellReference(XLSXParser xlsxParser, CellRef source, List<CellMark> targets) {
        if (targets == null || targets.isEmpty()) {
            return;
        }
        XLSXParser parser = xlsxParser;
        if (this.relationType != null) {
            try {
                parser = xlsxParser.loadImplicitPartDocument(this.relationType);
                if (parser == null) {
                    return;
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
        int nCount = 0;
        CellMark first = targets.get(0);
        try {
            Element firstEl = this.getTargetElement(xlsxParser, first);
            if (firstEl == null) {
                return;
            }
            Node refNode = firstEl.getNextSibling();
            XPathExpression attrXpath = XPathXlsxUtils.compile(this.attrPath);
            for (CellMark target : targets) {
                Node n;
                Element el = firstEl;
                if (first != target) {
                    el = (Element)firstEl.cloneNode(true);
                    firstEl.getParentNode().insertBefore(el, refNode);
                    ++nCount;
                }
                if ((n = (Node)attrXpath.evaluate(el, XPathConstants.NODE)) == null) continue;
                n.setNodeValue(target.cell.toString());
            }
            if (this.parentCountAttrPath != null) {
                Node n = XPathXlsxUtils.evaluateNode(parser.getDocument(), String.valueOf(first.path) + "/" + this.parentCountAttrPath);
                n.setNodeValue(String.valueOf(nCount += Integer.valueOf(n.getNodeValue()).intValue()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

