/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.DeleteOperation;
import org.eclipse.glsp.server.operations.GModelOperationHandler;

public class GModelDeleteOperationHandler
extends GModelOperationHandler<DeleteOperation> {
    private static Logger LOGGER = LogManager.getLogger(GModelDeleteOperationHandler.class);
    protected Set<String> allDependantsIds;

    @Override
    public Optional<Command> createCommand(DeleteOperation operation) {
        List<String> elementIds = operation.getElementIds();
        if (elementIds == null || elementIds.size() == 0) {
            LOGGER.warn("Elements to delete are not specified");
            return GModelDeleteOperationHandler.doNothing();
        }
        return this.commandOf(() -> this.deleteElements(elementIds));
    }

    public void deleteElements(List<String> elementIds) {
        GModelIndex index = this.modelState.getIndex();
        this.allDependantsIds = new HashSet<String>();
        boolean success = elementIds.stream().allMatch(eId -> this.delete((String)eId, index));
        if (!success) {
            LOGGER.warn("Could not delete all elements as requested (see messages above to find out why)");
        }
    }

    protected boolean delete(String elementId, GModelIndex index) {
        if (this.allDependantsIds.contains(elementId)) {
            return true;
        }
        Optional element = index.get(elementId);
        if (!element.isPresent()) {
            LOGGER.warn("Element not found: " + elementId);
            return false;
        }
        GModelElement elementToDelete = this.findTopLevelElement((GModelElement)element.get());
        if (elementToDelete.getParent() == null) {
            LOGGER.warn("The requested node doesn't have a parent; it can't be deleted");
            return false;
        }
        LinkedHashSet<GModelElement> dependents = new LinkedHashSet<GModelElement>();
        this.collectDependents(dependents, elementToDelete, this.modelState, false);
        this.allDependantsIds.addAll(dependents.stream().map(GModelElement::getId).collect(Collectors.toSet()));
        dependents.forEach(EcoreUtil::delete);
        return true;
    }

    protected void collectDependents(Set<GModelElement> dependents, GModelElement nodeToDelete, GModelState modelState, boolean isChild) {
        if (dependents.contains(nodeToDelete)) {
            return;
        }
        if (nodeToDelete.getChildren() != null) {
            for (GModelElement child : nodeToDelete.getChildren()) {
                this.collectDependents(dependents, child, modelState, true);
            }
        }
        if (nodeToDelete instanceof GNode) {
            GModelIndex index = modelState.getIndex();
            dependents.addAll(index.getIncomingEdges(nodeToDelete));
            dependents.addAll(index.getOutgoingEdges(nodeToDelete));
        }
        if (!isChild) {
            dependents.add(nodeToDelete);
        }
    }

    protected GModelElement findTopLevelElement(GModelElement element) {
        if (element instanceof GNode || element instanceof GEdge) {
            return element;
        }
        GModelElement parent = element.getParent();
        if (parent == null) {
            return element;
        }
        return this.findTopLevelElement(parent);
    }
}

