/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.streams.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.streams.Delivery;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.message.Message;

public class DeliveryImpl
implements Delivery {
    private static final Accepted ACCEPTED = Accepted.getInstance();
    private final Message message;
    private final ProtonDelivery delivery;
    private ContextInternal ctx;

    DeliveryImpl(Message message, ProtonDelivery delivery, ContextInternal ctx) {
        this.message = message;
        this.delivery = delivery;
        this.ctx = ctx;
    }

    @Override
    public Message message() {
        return this.message;
    }

    public ProtonDelivery delivery() {
        return this.delivery;
    }

    @Override
    public Delivery accept() {
        this.ackOnContext(v -> this.delivery.disposition(ACCEPTED, true));
        return this;
    }

    @Override
    public Delivery disposition(DeliveryState state, boolean settle) {
        this.ackOnContext(v -> this.delivery.disposition(state, settle));
        return this;
    }

    private void ackOnContext(Handler<Void> action) {
        if (this.onContextEventLoop()) {
            action.handle(null);
        } else {
            this.ctx.runOnContext(action);
        }
    }

    public boolean onContextEventLoop() {
        return this.ctx.nettyEventLoop().inEventLoop();
    }

    public Context getCtx() {
        return this.ctx;
    }
}

