/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.utils.PodStatusUtil;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.command.CgroupV1KubernetesContainerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesContainerInfoProvider {
    public static final String KUBERNETES_CONTAINER_NAME_ENV_VAR = "KUBERNETES_CONTAINER_NAME";
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesContainerInfoProvider.class);
    private static final KubernetesContainerInfoProvider INSTANCE = new KubernetesContainerInfoProvider();
    private final AtomicReference<Promise<String>> containerIdPromiseRef = new AtomicReference();
    private String containerId;
    private final String podName;
    private final boolean isRunningInKubernetes = System.getenv("KUBERNETES_SERVICE_HOST") != null;

    private KubernetesContainerInfoProvider() {
        this.podName = this.isRunningInKubernetes ? System.getenv("HOSTNAME") : null;
    }

    public static KubernetesContainerInfoProvider getInstance() {
        return INSTANCE;
    }

    boolean isRunningInKubernetes() {
        return this.isRunningInKubernetes;
    }

    public String getPodName() {
        return this.podName;
    }

    public Future<String> getContainerId(Context context) {
        Objects.requireNonNull(context);
        if (this.containerId != null) {
            return Future.succeededFuture(this.containerId);
        }
        if (!this.isRunningInKubernetes()) {
            return Future.succeededFuture(null);
        }
        String containerIdViaCgroup1 = CgroupV1KubernetesContainerUtil.getContainerId();
        if (containerIdViaCgroup1 != null) {
            this.containerId = containerIdViaCgroup1;
            return Future.succeededFuture(this.containerId);
        }
        Promise containerIdPromise = Promise.promise();
        if (!this.containerIdPromiseRef.compareAndSet(null, containerIdPromise)) {
            this.containerIdPromiseRef.get().future().onComplete(containerIdPromise);
            LOG.debug("getContainerId result future will be completed with the result of an already ongoing invocation");
            return containerIdPromise.future();
        }
        context.executeBlocking(codeHandler -> {
            try {
                this.containerId = this.getContainerIdViaK8sApi();
                codeHandler.complete(this.containerId);
            }
            catch (Exception e) {
                codeHandler.fail(e);
            }
        }, containerIdPromise);
        containerIdPromise.future().onComplete(ar -> this.containerIdPromiseRef.set(null));
        return containerIdPromise.future();
    }

    private String getContainerIdViaK8sApi() throws ServerErrorException, IllegalStateException {
        String string;
        block9: {
            KubernetesClient client = new KubernetesClientBuilder().build();
            try {
                String containerNameEnvVarValue = System.getenv(KUBERNETES_CONTAINER_NAME_ENV_VAR);
                string = KubernetesContainerInfoProvider.getContainerIdViaK8sApi(client, this.getPodName(), containerNameEnvVarValue);
                if (client == null) break block9;
            }
            catch (Throwable containerNameEnvVarValue) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            containerNameEnvVarValue.addSuppressed(throwable);
                        }
                    }
                    throw containerNameEnvVarValue;
                }
                catch (KubernetesClientException e) {
                    if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().contains("timed out")) {
                        String errorMsg = "Timed out getting container id via K8s API. Consider increasing the request timeout via the KUBERNETES_REQUEST_TIMEOUT env var (default is 10000[ms]).";
                        LOG.error("Timed out getting container id via K8s API. Consider increasing the request timeout via the KUBERNETES_REQUEST_TIMEOUT env var (default is 10000[ms]).");
                        throw new ServerErrorException(500, "Timed out getting container id via K8s API. Consider increasing the request timeout via the KUBERNETES_REQUEST_TIMEOUT env var (default is 10000[ms]).");
                    }
                    throw new ServerErrorException(500, "Error getting container id via K8s API: " + e.getMessage());
                }
            }
            client.close();
        }
        return string;
    }

    static String getContainerIdViaK8sApi(KubernetesClient client, String podName, String containerNameEnvVarValue) throws KubernetesClientException, IllegalStateException {
        LOG.info("get container id via K8s API");
        try {
            ContainerStatus foundContainerStatus;
            String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).get();
            if (pod == null) {
                throw new KubernetesClientException("application pod not found in Kubernetes namespace " + namespace);
            }
            List<ContainerStatus> containerStatuses = PodStatusUtil.getContainerStatus(pod).stream().filter(KubernetesContainerInfoProvider::isContainerRunning).toList();
            if (containerStatuses.isEmpty()) {
                LOG.debug("got empty container statuses list");
                throw new KubernetesClientException("no running container found in pod %s, namespace %s".formatted(podName, namespace));
            }
            if (containerStatuses.size() > 1) {
                String foundContainerNames = containerStatuses.stream().map(ContainerStatus::getName).collect(Collectors.joining(", "));
                if (containerNameEnvVarValue == null) {
                    LOG.error("can't get container id: found multiple running containers, but {} env var is not set to specify which container to use; found containers [{}] in pod {}", KUBERNETES_CONTAINER_NAME_ENV_VAR, foundContainerNames, podName);
                    throw new IllegalStateException("can't get container id via K8s API: multiple running containers found; the %s env variable needs to be set for the container this application is running in, having the container name as value".formatted(KUBERNETES_CONTAINER_NAME_ENV_VAR));
                }
                LOG.info("multiple running containers found: {}", (Object)foundContainerNames);
                LOG.info("using container name {} (derived from env var {}) to determine container id", (Object)containerNameEnvVarValue, (Object)KUBERNETES_CONTAINER_NAME_ENV_VAR);
                foundContainerStatus = containerStatuses.stream().filter(status -> status.getName().equals(containerNameEnvVarValue)).findFirst().orElseThrow(() -> new KubernetesClientException("no running container with name %s found in pod %s, namespace %s".formatted(containerNameEnvVarValue, podName, namespace)));
            } else {
                foundContainerStatus = containerStatuses.get(0);
            }
            String containerId = foundContainerStatus.getContainerID();
            int delimIdx = containerId.lastIndexOf("://");
            if (delimIdx > -1) {
                containerId = containerId.substring(delimIdx + 3);
            }
            LOG.info("got container id via K8s API: {}", (Object)containerId);
            return containerId;
        }
        catch (KubernetesClientException e) {
            if (e.getMessage().contains("orbidden")) {
                LOG.error("Error getting container id via K8s API: \n{}", (Object)e.getMessage());
                throw new IllegalStateException("error getting container id via K8s API: application pod needs service account with role binding allowing 'get' on 'pods' resource");
            }
            LOG.error("Error getting container id via K8s API", e);
            throw e;
        }
    }

    private static boolean isContainerRunning(ContainerStatus containerStatus) {
        return containerStatus.getState() != null && containerStatus.getState().getRunning() != null;
    }
}

